/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.LinearRingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Geometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Geometry> {
    private static final SdkField<List<List<List<Double>>>> COORDINATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Coordinates").getter(Geometry.getter(Geometry::coordinates)).setter(Geometry.setter(Builder::coordinates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Geometry.getter(Geometry::type)).setter(Geometry.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Geometry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<List<List<Double>>> coordinates;
    private final String type;

    private Geometry(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
        this.type = builder.type;
    }

    public final boolean hasCoordinates() {
        return this.coordinates != null && !(this.coordinates instanceof SdkAutoConstructList);
    }

    public final List<List<List<Double>>> coordinates() {
        return this.coordinates;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoordinates() ? this.coordinates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry)obj;
        return this.hasCoordinates() == other.hasCoordinates() && Objects.equals(this.coordinates(), other.coordinates()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"Geometry").add("Coordinates", (Object)(this.coordinates() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Coordinates": {
                return Optional.ofNullable(clazz.cast(this.coordinates()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Coordinates", COORDINATES_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Geometry, T> g) {
        return obj -> g.apply((Geometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<List<Double>>> coordinates = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Geometry model) {
            this.coordinates(model.coordinates);
            this.type(model.type);
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getCoordinates() {
            if (this.coordinates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.coordinates;
        }

        public final void setCoordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates) {
            this.coordinates = LinearRingsCopier.copy(coordinates);
        }

        @Override
        public final Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates) {
            this.coordinates = LinearRingsCopier.copy(coordinates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coordinates(Collection<? extends Collection<Double>> ... coordinates) {
            this.coordinates((Collection<? extends Collection<? extends Collection<Double>>>)Arrays.asList(coordinates));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public Geometry build() {
            return new Geometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Geometry> {
        public Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>> var1);

        public Builder coordinates(Collection<? extends Collection<Double>> ... var1);

        public Builder type(String var1);
    }
}

