/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.ItemSource;
import software.amazon.awssdk.services.sagemakergeospatial.model.ItemSourceListCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRasterDataCollectionResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, SearchRasterDataCollectionResponse> {
    private static final SdkField<Integer> APPROXIMATE_RESULT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ApproximateResultCount").getter(SearchRasterDataCollectionResponse.getter(SearchRasterDataCollectionResponse::approximateResultCount)).setter(SearchRasterDataCollectionResponse.setter(Builder::approximateResultCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateResultCount").build()}).build();
    private static final SdkField<List<ItemSource>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(SearchRasterDataCollectionResponse.getter(SearchRasterDataCollectionResponse::items)).setter(SearchRasterDataCollectionResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchRasterDataCollectionResponse.getter(SearchRasterDataCollectionResponse::nextToken)).setter(SearchRasterDataCollectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROXIMATE_RESULT_COUNT_FIELD, ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchRasterDataCollectionResponse.memberNameToFieldInitializer();
    private final Integer approximateResultCount;
    private final List<ItemSource> items;
    private final String nextToken;

    private SearchRasterDataCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.approximateResultCount = builder.approximateResultCount;
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    public final Integer approximateResultCount() {
        return this.approximateResultCount;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ItemSource> items() {
        return this.items;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateResultCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRasterDataCollectionResponse)) {
            return false;
        }
        SearchRasterDataCollectionResponse other = (SearchRasterDataCollectionResponse)((Object)obj);
        return Objects.equals(this.approximateResultCount(), other.approximateResultCount()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRasterDataCollectionResponse").add("ApproximateResultCount", (Object)this.approximateResultCount()).add("Items", this.hasItems() ? this.items() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateResultCount": {
                return Optional.ofNullable(clazz.cast(this.approximateResultCount()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApproximateResultCount", APPROXIMATE_RESULT_COUNT_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRasterDataCollectionResponse, T> g) {
        return obj -> g.apply((SearchRasterDataCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private Integer approximateResultCount;
        private List<ItemSource> items = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRasterDataCollectionResponse model) {
            super(model);
            this.approximateResultCount(model.approximateResultCount);
            this.items(model.items);
            this.nextToken(model.nextToken);
        }

        public final Integer getApproximateResultCount() {
            return this.approximateResultCount;
        }

        public final void setApproximateResultCount(Integer approximateResultCount) {
            this.approximateResultCount = approximateResultCount;
        }

        @Override
        public final Builder approximateResultCount(Integer approximateResultCount) {
            this.approximateResultCount = approximateResultCount;
            return this;
        }

        public final List<ItemSource.Builder> getItems() {
            List<ItemSource.Builder> result = ItemSourceListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ItemSource.BuilderImpl> items) {
            this.items = ItemSourceListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ItemSource> items) {
            this.items = ItemSourceListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ItemSource ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ItemSource.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ItemSource)((ItemSource.Builder)ItemSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchRasterDataCollectionResponse build() {
            return new SearchRasterDataCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchRasterDataCollectionResponse> {
        public Builder approximateResultCount(Integer var1);

        public Builder items(Collection<ItemSource> var1);

        public Builder items(ItemSource ... var1);

        public Builder items(Consumer<ItemSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

