/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.MapMatchingConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.ReverseGeocodingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorEnrichmentJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorEnrichmentJobConfig> {
    private static final SdkField<MapMatchingConfig> MAP_MATCHING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MapMatchingConfig").getter(VectorEnrichmentJobConfig.getter(VectorEnrichmentJobConfig::mapMatchingConfig)).setter(VectorEnrichmentJobConfig.setter(Builder::mapMatchingConfig)).constructor(MapMatchingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapMatchingConfig").build()}).build();
    private static final SdkField<ReverseGeocodingConfig> REVERSE_GEOCODING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReverseGeocodingConfig").getter(VectorEnrichmentJobConfig.getter(VectorEnrichmentJobConfig::reverseGeocodingConfig)).setter(VectorEnrichmentJobConfig.setter(Builder::reverseGeocodingConfig)).constructor(ReverseGeocodingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReverseGeocodingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_MATCHING_CONFIG_FIELD, REVERSE_GEOCODING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MapMatchingConfig", MAP_MATCHING_CONFIG_FIELD);
            this.put("ReverseGeocodingConfig", REVERSE_GEOCODING_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MapMatchingConfig mapMatchingConfig;
    private final ReverseGeocodingConfig reverseGeocodingConfig;
    private final Type type;

    private VectorEnrichmentJobConfig(BuilderImpl builder) {
        this.mapMatchingConfig = builder.mapMatchingConfig;
        this.reverseGeocodingConfig = builder.reverseGeocodingConfig;
        this.type = builder.type;
    }

    public final MapMatchingConfig mapMatchingConfig() {
        return this.mapMatchingConfig;
    }

    public final ReverseGeocodingConfig reverseGeocodingConfig() {
        return this.reverseGeocodingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mapMatchingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseGeocodingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorEnrichmentJobConfig)) {
            return false;
        }
        VectorEnrichmentJobConfig other = (VectorEnrichmentJobConfig)obj;
        return Objects.equals(this.mapMatchingConfig(), other.mapMatchingConfig()) && Objects.equals(this.reverseGeocodingConfig(), other.reverseGeocodingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"VectorEnrichmentJobConfig").add("MapMatchingConfig", (Object)this.mapMatchingConfig()).add("ReverseGeocodingConfig", (Object)this.reverseGeocodingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapMatchingConfig": {
                return Optional.ofNullable(clazz.cast(this.mapMatchingConfig()));
            }
            case "ReverseGeocodingConfig": {
                return Optional.ofNullable(clazz.cast(this.reverseGeocodingConfig()));
            }
        }
        return Optional.empty();
    }

    public static VectorEnrichmentJobConfig fromMapMatchingConfig(MapMatchingConfig mapMatchingConfig) {
        return (VectorEnrichmentJobConfig)VectorEnrichmentJobConfig.builder().mapMatchingConfig(mapMatchingConfig).build();
    }

    public static VectorEnrichmentJobConfig fromMapMatchingConfig(Consumer<MapMatchingConfig.Builder> mapMatchingConfig) {
        MapMatchingConfig.Builder builder = MapMatchingConfig.builder();
        mapMatchingConfig.accept(builder);
        return VectorEnrichmentJobConfig.fromMapMatchingConfig((MapMatchingConfig)builder.build());
    }

    public static VectorEnrichmentJobConfig fromReverseGeocodingConfig(ReverseGeocodingConfig reverseGeocodingConfig) {
        return (VectorEnrichmentJobConfig)VectorEnrichmentJobConfig.builder().reverseGeocodingConfig(reverseGeocodingConfig).build();
    }

    public static VectorEnrichmentJobConfig fromReverseGeocodingConfig(Consumer<ReverseGeocodingConfig.Builder> reverseGeocodingConfig) {
        ReverseGeocodingConfig.Builder builder = ReverseGeocodingConfig.builder();
        reverseGeocodingConfig.accept(builder);
        return VectorEnrichmentJobConfig.fromReverseGeocodingConfig((ReverseGeocodingConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VectorEnrichmentJobConfig, T> g) {
        return obj -> g.apply((VectorEnrichmentJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MAP_MATCHING_CONFIG,
        REVERSE_GEOCODING_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private MapMatchingConfig mapMatchingConfig;
        private ReverseGeocodingConfig reverseGeocodingConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VectorEnrichmentJobConfig model) {
            this.mapMatchingConfig(model.mapMatchingConfig);
            this.reverseGeocodingConfig(model.reverseGeocodingConfig);
        }

        public final MapMatchingConfig.Builder getMapMatchingConfig() {
            return this.mapMatchingConfig != null ? this.mapMatchingConfig.toBuilder() : null;
        }

        public final void setMapMatchingConfig(MapMatchingConfig.BuilderImpl mapMatchingConfig) {
            MapMatchingConfig oldValue = this.mapMatchingConfig;
            this.mapMatchingConfig = mapMatchingConfig != null ? mapMatchingConfig.build() : null;
            this.handleUnionValueChange(Type.MAP_MATCHING_CONFIG, oldValue, this.mapMatchingConfig);
        }

        @Override
        public final Builder mapMatchingConfig(MapMatchingConfig mapMatchingConfig) {
            MapMatchingConfig oldValue = this.mapMatchingConfig;
            this.mapMatchingConfig = mapMatchingConfig;
            this.handleUnionValueChange(Type.MAP_MATCHING_CONFIG, oldValue, this.mapMatchingConfig);
            return this;
        }

        public final ReverseGeocodingConfig.Builder getReverseGeocodingConfig() {
            return this.reverseGeocodingConfig != null ? this.reverseGeocodingConfig.toBuilder() : null;
        }

        public final void setReverseGeocodingConfig(ReverseGeocodingConfig.BuilderImpl reverseGeocodingConfig) {
            ReverseGeocodingConfig oldValue = this.reverseGeocodingConfig;
            this.reverseGeocodingConfig = reverseGeocodingConfig != null ? reverseGeocodingConfig.build() : null;
            this.handleUnionValueChange(Type.REVERSE_GEOCODING_CONFIG, oldValue, this.reverseGeocodingConfig);
        }

        @Override
        public final Builder reverseGeocodingConfig(ReverseGeocodingConfig reverseGeocodingConfig) {
            ReverseGeocodingConfig oldValue = this.reverseGeocodingConfig;
            this.reverseGeocodingConfig = reverseGeocodingConfig;
            this.handleUnionValueChange(Type.REVERSE_GEOCODING_CONFIG, oldValue, this.reverseGeocodingConfig);
            return this;
        }

        public VectorEnrichmentJobConfig build() {
            return new VectorEnrichmentJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorEnrichmentJobConfig> {
        public Builder mapMatchingConfig(MapMatchingConfig var1);

        default public Builder mapMatchingConfig(Consumer<MapMatchingConfig.Builder> mapMatchingConfig) {
            return this.mapMatchingConfig((MapMatchingConfig)((MapMatchingConfig.Builder)MapMatchingConfig.builder().applyMutation(mapMatchingConfig)).build());
        }

        public Builder reverseGeocodingConfig(ReverseGeocodingConfig var1);

        default public Builder reverseGeocodingConfig(Consumer<ReverseGeocodingConfig.Builder> reverseGeocodingConfig) {
            return this.reverseGeocodingConfig((ReverseGeocodingConfig)((ReverseGeocodingConfig.Builder)ReverseGeocodingConfig.builder().applyMutation(reverseGeocodingConfig)).build());
        }
    }
}

