/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response structure for an OutputConfig returned by an ExportEarthObservationJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputConfigInput.Builder, OutputConfigInput> {
    private static final SdkField<ExportS3DataInput> S3_DATA_FIELD = SdkField
            .<ExportS3DataInput> builder(MarshallingType.SDK_POJO).memberName("S3Data").getter(getter(OutputConfigInput::s3Data))
            .setter(setter(Builder::s3Data)).constructor(ExportS3DataInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExportS3DataInput s3Data;

    private OutputConfigInput(BuilderImpl builder) {
        this.s3Data = builder.s3Data;
    }

    /**
     * <p>
     * Path to Amazon S3 storage location for the output configuration file.
     * </p>
     * 
     * @return Path to Amazon S3 storage location for the output configuration file.
     */
    public final ExportS3DataInput s3Data() {
        return s3Data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfigInput)) {
            return false;
        }
        OutputConfigInput other = (OutputConfigInput) obj;
        return Objects.equals(s3Data(), other.s3Data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputConfigInput").add("S3Data", s3Data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Data":
            return Optional.ofNullable(clazz.cast(s3Data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputConfigInput, T> g) {
        return obj -> g.apply((OutputConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputConfigInput> {
        /**
         * <p>
         * Path to Amazon S3 storage location for the output configuration file.
         * </p>
         * 
         * @param s3Data
         *        Path to Amazon S3 storage location for the output configuration file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Data(ExportS3DataInput s3Data);

        /**
         * <p>
         * Path to Amazon S3 storage location for the output configuration file.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportS3DataInput.Builder} avoiding the
         * need to create one manually via {@link ExportS3DataInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportS3DataInput.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Data(ExportS3DataInput)}.
         * 
         * @param s3Data
         *        a consumer that will call methods on {@link ExportS3DataInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Data(ExportS3DataInput)
         */
        default Builder s3Data(Consumer<ExportS3DataInput.Builder> s3Data) {
            return s3Data(ExportS3DataInput.builder().applyMutation(s3Data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportS3DataInput s3Data;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConfigInput model) {
            s3Data(model.s3Data);
        }

        public final ExportS3DataInput.Builder getS3Data() {
            return s3Data != null ? s3Data.toBuilder() : null;
        }

        public final void setS3Data(ExportS3DataInput.BuilderImpl s3Data) {
            this.s3Data = s3Data != null ? s3Data.build() : null;
        }

        @Override
        public final Builder s3Data(ExportS3DataInput s3Data) {
            this.s3Data = s3Data;
            return this;
        }

        @Override
        public OutputConfigInput build() {
            return new OutputConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
