/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputType;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.TargetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTileRequest
extends SageMakerGeospatialRequest
implements ToCopyableBuilder<Builder, GetTileRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetTileRequest.getter(GetTileRequest::arn)).setter(GetTileRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> IMAGE_ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageAssets").getter(GetTileRequest.getter(GetTileRequest::imageAssets)).setter(GetTileRequest.setter(Builder::imageAssets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ImageAssets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IMAGE_MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImageMask").getter(GetTileRequest.getter(GetTileRequest::imageMask)).setter(GetTileRequest.setter(Builder::imageMask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ImageMask").build()}).build();
    private static final SdkField<String> OUTPUT_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputDataType").getter(GetTileRequest.getter(GetTileRequest::outputDataTypeAsString)).setter(GetTileRequest.setter(Builder::outputDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OutputDataType").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(GetTileRequest.getter(GetTileRequest::outputFormat)).setter(GetTileRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OutputFormat").build()}).build();
    private static final SdkField<String> PROPERTY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyFilters").getter(GetTileRequest.getter(GetTileRequest::propertyFilters)).setter(GetTileRequest.setter(Builder::propertyFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PropertyFilters").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(GetTileRequest.getter(GetTileRequest::targetAsString)).setter(GetTileRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Target").build()}).build();
    private static final SdkField<String> TIME_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeRangeFilter").getter(GetTileRequest.getter(GetTileRequest::timeRangeFilter)).setter(GetTileRequest.setter(Builder::timeRangeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TimeRangeFilter").build()}).build();
    private static final SdkField<Integer> X_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("x").getter(GetTileRequest.getter(GetTileRequest::x)).setter(GetTileRequest.setter(Builder::x)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("x").build()}).build();
    private static final SdkField<Integer> Y_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("y").getter(GetTileRequest.getter(GetTileRequest::y)).setter(GetTileRequest.setter(Builder::y)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("y").build()}).build();
    private static final SdkField<Integer> Z_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("z").getter(GetTileRequest.getter(GetTileRequest::z)).setter(GetTileRequest.setter(Builder::z)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("z").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, IMAGE_ASSETS_FIELD, IMAGE_MASK_FIELD, OUTPUT_DATA_TYPE_FIELD, OUTPUT_FORMAT_FIELD, PROPERTY_FILTERS_FIELD, TARGET_FIELD, TIME_RANGE_FILTER_FIELD, X_FIELD, Y_FIELD, Z_FIELD));
    private final String arn;
    private final List<String> imageAssets;
    private final Boolean imageMask;
    private final String outputDataType;
    private final String outputFormat;
    private final String propertyFilters;
    private final String target;
    private final String timeRangeFilter;
    private final Integer x;
    private final Integer y;
    private final Integer z;

    private GetTileRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.imageAssets = builder.imageAssets;
        this.imageMask = builder.imageMask;
        this.outputDataType = builder.outputDataType;
        this.outputFormat = builder.outputFormat;
        this.propertyFilters = builder.propertyFilters;
        this.target = builder.target;
        this.timeRangeFilter = builder.timeRangeFilter;
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasImageAssets() {
        return this.imageAssets != null && !(this.imageAssets instanceof SdkAutoConstructList);
    }

    public final List<String> imageAssets() {
        return this.imageAssets;
    }

    public final Boolean imageMask() {
        return this.imageMask;
    }

    public final OutputType outputDataType() {
        return OutputType.fromValue(this.outputDataType);
    }

    public final String outputDataTypeAsString() {
        return this.outputDataType;
    }

    public final String outputFormat() {
        return this.outputFormat;
    }

    public final String propertyFilters() {
        return this.propertyFilters;
    }

    public final TargetOptions target() {
        return TargetOptions.fromValue(this.target);
    }

    public final String targetAsString() {
        return this.target;
    }

    public final String timeRangeFilter() {
        return this.timeRangeFilter;
    }

    public final Integer x() {
        return this.x;
    }

    public final Integer y() {
        return this.y;
    }

    public final Integer z() {
        return this.z;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageAssets() ? this.imageAssets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageMask());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.x());
        hashCode = 31 * hashCode + Objects.hashCode(this.y());
        hashCode = 31 * hashCode + Objects.hashCode(this.z());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTileRequest)) {
            return false;
        }
        GetTileRequest other = (GetTileRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasImageAssets() == other.hasImageAssets() && Objects.equals(this.imageAssets(), other.imageAssets()) && Objects.equals(this.imageMask(), other.imageMask()) && Objects.equals(this.outputDataTypeAsString(), other.outputDataTypeAsString()) && Objects.equals(this.outputFormat(), other.outputFormat()) && Objects.equals(this.propertyFilters(), other.propertyFilters()) && Objects.equals(this.targetAsString(), other.targetAsString()) && Objects.equals(this.timeRangeFilter(), other.timeRangeFilter()) && Objects.equals(this.x(), other.x()) && Objects.equals(this.y(), other.y()) && Objects.equals(this.z(), other.z());
    }

    public final String toString() {
        return ToString.builder((String)"GetTileRequest").add("Arn", (Object)this.arn()).add("ImageAssets", this.hasImageAssets() ? this.imageAssets() : null).add("ImageMask", (Object)this.imageMask()).add("OutputDataType", (Object)this.outputDataTypeAsString()).add("OutputFormat", (Object)this.outputFormat()).add("PropertyFilters", (Object)this.propertyFilters()).add("Target", (Object)this.targetAsString()).add("TimeRangeFilter", (Object)this.timeRangeFilter()).add("X", (Object)this.x()).add("Y", (Object)this.y()).add("Z", (Object)this.z()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ImageAssets": {
                return Optional.ofNullable(clazz.cast(this.imageAssets()));
            }
            case "ImageMask": {
                return Optional.ofNullable(clazz.cast(this.imageMask()));
            }
            case "OutputDataType": {
                return Optional.ofNullable(clazz.cast(this.outputDataTypeAsString()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormat()));
            }
            case "PropertyFilters": {
                return Optional.ofNullable(clazz.cast(this.propertyFilters()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.targetAsString()));
            }
            case "TimeRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeRangeFilter()));
            }
            case "x": {
                return Optional.ofNullable(clazz.cast(this.x()));
            }
            case "y": {
                return Optional.ofNullable(clazz.cast(this.y()));
            }
            case "z": {
                return Optional.ofNullable(clazz.cast(this.z()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTileRequest, T> g) {
        return obj -> g.apply((GetTileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialRequest.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> imageAssets = DefaultSdkAutoConstructList.getInstance();
        private Boolean imageMask;
        private String outputDataType;
        private String outputFormat;
        private String propertyFilters;
        private String target;
        private String timeRangeFilter;
        private Integer x;
        private Integer y;
        private Integer z;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTileRequest model) {
            super(model);
            this.arn(model.arn);
            this.imageAssets(model.imageAssets);
            this.imageMask(model.imageMask);
            this.outputDataType(model.outputDataType);
            this.outputFormat(model.outputFormat);
            this.propertyFilters(model.propertyFilters);
            this.target(model.target);
            this.timeRangeFilter(model.timeRangeFilter);
            this.x(model.x);
            this.y(model.y);
            this.z(model.z);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getImageAssets() {
            if (this.imageAssets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageAssets;
        }

        public final void setImageAssets(Collection<String> imageAssets) {
            this.imageAssets = StringListInputCopier.copy(imageAssets);
        }

        @Override
        public final Builder imageAssets(Collection<String> imageAssets) {
            this.imageAssets = StringListInputCopier.copy(imageAssets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageAssets(String ... imageAssets) {
            this.imageAssets(Arrays.asList(imageAssets));
            return this;
        }

        public final Boolean getImageMask() {
            return this.imageMask;
        }

        public final void setImageMask(Boolean imageMask) {
            this.imageMask = imageMask;
        }

        @Override
        public final Builder imageMask(Boolean imageMask) {
            this.imageMask = imageMask;
            return this;
        }

        public final String getOutputDataType() {
            return this.outputDataType;
        }

        public final void setOutputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
        }

        @Override
        public final Builder outputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
            return this;
        }

        @Override
        public final Builder outputDataType(OutputType outputDataType) {
            this.outputDataType(outputDataType == null ? null : outputDataType.toString());
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public final String getPropertyFilters() {
            return this.propertyFilters;
        }

        public final void setPropertyFilters(String propertyFilters) {
            this.propertyFilters = propertyFilters;
        }

        @Override
        public final Builder propertyFilters(String propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(TargetOptions target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final String getTimeRangeFilter() {
            return this.timeRangeFilter;
        }

        public final void setTimeRangeFilter(String timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
        }

        @Override
        public final Builder timeRangeFilter(String timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public final Integer getX() {
            return this.x;
        }

        public final void setX(Integer x) {
            this.x = x;
        }

        @Override
        public final Builder x(Integer x) {
            this.x = x;
            return this;
        }

        public final Integer getY() {
            return this.y;
        }

        public final void setY(Integer y) {
            this.y = y;
        }

        @Override
        public final Builder y(Integer y) {
            this.y = y;
            return this;
        }

        public final Integer getZ() {
            return this.z;
        }

        public final void setZ(Integer z) {
            this.z = z;
        }

        @Override
        public final Builder z(Integer z) {
            this.z = z;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTileRequest build() {
            return new GetTileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTileRequest> {
        public Builder arn(String var1);

        public Builder imageAssets(Collection<String> var1);

        public Builder imageAssets(String ... var1);

        public Builder imageMask(Boolean var1);

        public Builder outputDataType(String var1);

        public Builder outputDataType(OutputType var1);

        public Builder outputFormat(String var1);

        public Builder propertyFilters(String var1);

        public Builder target(String var1);

        public Builder target(TargetOptions var1);

        public Builder timeRangeFilter(String var1);

        public Builder x(Integer var1);

        public Builder y(Integer var1);

        public Builder z(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

