/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordRequest extends SageMakerFeatureStoreRuntimeRequest implements
        ToCopyableBuilder<PutRecordRequest.Builder, PutRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(PutRecordRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()).build();

    private static final SdkField<List<FeatureValue>> RECORD_FIELD = SdkField
            .<List<FeatureValue>> builder(MarshallingType.LIST)
            .memberName("Record")
            .getter(getter(PutRecordRequest::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_STORES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetStores")
            .getter(getter(PutRecordRequest::targetStoresAsStrings))
            .setter(setter(Builder::targetStoresWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TtlDuration> TTL_DURATION_FIELD = SdkField.<TtlDuration> builder(MarshallingType.SDK_POJO)
            .memberName("TtlDuration").getter(getter(PutRecordRequest::ttlDuration)).setter(setter(Builder::ttlDuration))
            .constructor(TtlDuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TtlDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_FIELD, TARGET_STORES_FIELD, TTL_DURATION_FIELD));

    private final String featureGroupName;

    private final List<FeatureValue> record;

    private final List<String> targetStores;

    private final TtlDuration ttlDuration;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.record = builder.record;
        this.targetStores = builder.targetStores;
        this.ttlDuration = builder.ttlDuration;
    }

    /**
     * <p>
     * The name of the feature group that you want to insert the record into.
     * </p>
     * 
     * @return The name of the feature group that you want to insert the record into.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Record property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
     * feature values, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>GetRecord</code> to retrieve the latest record.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the record returned from <code>GetRecord</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutRecord</code> to update feature values.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecord} method.
     * </p>
     * 
     * @return List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of
     *         the feature values, do the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>GetRecord</code> to retrieve the latest record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Update the record returned from <code>GetRecord</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>PutRecord</code> to update feature values.
     *         </p>
     *         </li>
     */
    public final List<FeatureValue> record() {
        return record;
    }

    /**
     * <p>
     * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the
     * stores that you're using for the <code>FeatureGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetStores} method.
     * </p>
     * 
     * @return A list of stores to which you're adding the record. By default, Feature Store adds the record to all of
     *         the stores that you're using for the <code>FeatureGroup</code>.
     */
    public final List<TargetStore> targetStores() {
        return TargetStoresCopier.copyStringToEnum(targetStores);
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetStores() {
        return targetStores != null && !(targetStores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the
     * stores that you're using for the <code>FeatureGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetStores} method.
     * </p>
     * 
     * @return A list of stores to which you're adding the record. By default, Feature Store adds the record to all of
     *         the stores that you're using for the <code>FeatureGroup</code>.
     */
    public final List<String> targetStoresAsStrings() {
        return targetStores;
    }

    /**
     * <p>
     * Time to live duration, where the record is hard deleted after the expiration time is reached;
     * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete, see
     * the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">
     * DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
     * </p>
     * 
     * @return Time to live duration, where the record is hard deleted after the expiration time is reached;
     *         <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on
     *         HardDelete, see the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
     *         >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
     */
    public final TtlDuration ttlDuration() {
        return ttlDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetStores() ? targetStoresAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ttlDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName()) && hasRecord() == other.hasRecord()
                && Objects.equals(record(), other.record()) && hasTargetStores() == other.hasTargetStores()
                && Objects.equals(targetStoresAsStrings(), other.targetStoresAsStrings())
                && Objects.equals(ttlDuration(), other.ttlDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecordRequest").add("FeatureGroupName", featureGroupName())
                .add("Record", hasRecord() ? record() : null)
                .add("TargetStores", hasTargetStores() ? targetStoresAsStrings() : null).add("TtlDuration", ttlDuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "Record":
            return Optional.ofNullable(clazz.cast(record()));
        case "TargetStores":
            return Optional.ofNullable(clazz.cast(targetStoresAsStrings()));
        case "TtlDuration":
            return Optional.ofNullable(clazz.cast(ttlDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordRequest, T> g) {
        return obj -> g.apply((PutRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRecordRequest> {
        /**
         * <p>
         * The name of the feature group that you want to insert the record into.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the feature group that you want to insert the record into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
         * feature values, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>GetRecord</code> to retrieve the latest record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the record returned from <code>GetRecord</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>PutRecord</code> to update feature values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param record
         *        List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few
         *        of the feature values, do the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>GetRecord</code> to retrieve the latest record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the record returned from <code>GetRecord</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>PutRecord</code> to update feature values.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Collection<FeatureValue> record);

        /**
         * <p>
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
         * feature values, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>GetRecord</code> to retrieve the latest record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the record returned from <code>GetRecord</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>PutRecord</code> to update feature values.
         * </p>
         * </li>
         * </ul>
         * 
         * @param record
         *        List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few
         *        of the feature values, do the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>GetRecord</code> to retrieve the latest record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Update the record returned from <code>GetRecord</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>PutRecord</code> to update feature values.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(FeatureValue... record);

        /**
         * <p>
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the
         * feature values, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>GetRecord</code> to retrieve the latest record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Update the record returned from <code>GetRecord</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>PutRecord</code> to update feature values.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue.Builder#build()} is
         * called immediately and its result is passed to {@link #record(List<FeatureValue>)}.
         * 
         * @param record
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #record(java.util.Collection<FeatureValue>)
         */
        Builder record(Consumer<FeatureValue.Builder>... record);

        /**
         * <p>
         * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the
         * stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores to which you're adding the record. By default, Feature Store adds the record to all
         *        of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStoresWithStrings(Collection<String> targetStores);

        /**
         * <p>
         * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the
         * stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores to which you're adding the record. By default, Feature Store adds the record to all
         *        of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStoresWithStrings(String... targetStores);

        /**
         * <p>
         * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the
         * stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores to which you're adding the record. By default, Feature Store adds the record to all
         *        of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStores(Collection<TargetStore> targetStores);

        /**
         * <p>
         * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the
         * stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores to which you're adding the record. By default, Feature Store adds the record to all
         *        of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStores(TargetStore... targetStores);

        /**
         * <p>
         * Time to live duration, where the record is hard deleted after the expiration time is reached;
         * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete,
         * see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
         * >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * </p>
         * 
         * @param ttlDuration
         *        Time to live duration, where the record is hard deleted after the expiration time is reached;
         *        <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on
         *        HardDelete, see the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
         *        >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttlDuration(TtlDuration ttlDuration);

        /**
         * <p>
         * Time to live duration, where the record is hard deleted after the expiration time is reached;
         * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete,
         * see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
         * >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link TtlDuration.Builder} avoiding the need to
         * create one manually via {@link TtlDuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TtlDuration.Builder#build()} is called immediately and its result
         * is passed to {@link #ttlDuration(TtlDuration)}.
         * 
         * @param ttlDuration
         *        a consumer that will call methods on {@link TtlDuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttlDuration(TtlDuration)
         */
        default Builder ttlDuration(Consumer<TtlDuration.Builder> ttlDuration) {
            return ttlDuration(TtlDuration.builder().applyMutation(ttlDuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private List<FeatureValue> record = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetStores = DefaultSdkAutoConstructList.getInstance();

        private TtlDuration ttlDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            record(model.record);
            targetStoresWithStrings(model.targetStores);
            ttlDuration(model.ttlDuration);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final List<FeatureValue.Builder> getRecord() {
            List<FeatureValue.Builder> result = RecordCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecord(Collection<FeatureValue.BuilderImpl> record) {
            this.record = RecordCopier.copyFromBuilder(record);
        }

        @Override
        public final Builder record(Collection<FeatureValue> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(FeatureValue... record) {
            record(Arrays.asList(record));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder record(Consumer<FeatureValue.Builder>... record) {
            record(Stream.of(record).map(c -> FeatureValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTargetStores() {
            if (targetStores instanceof SdkAutoConstructList) {
                return null;
            }
            return targetStores;
        }

        public final void setTargetStores(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
        }

        @Override
        public final Builder targetStoresWithStrings(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStoresWithStrings(String... targetStores) {
            targetStoresWithStrings(Arrays.asList(targetStores));
            return this;
        }

        @Override
        public final Builder targetStores(Collection<TargetStore> targetStores) {
            this.targetStores = TargetStoresCopier.copyEnumToString(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStores(TargetStore... targetStores) {
            targetStores(Arrays.asList(targetStores));
            return this;
        }

        public final TtlDuration.Builder getTtlDuration() {
            return ttlDuration != null ? ttlDuration.toBuilder() : null;
        }

        public final void setTtlDuration(TtlDuration.BuilderImpl ttlDuration) {
            this.ttlDuration = ttlDuration != null ? ttlDuration.build() : null;
        }

        @Override
        public final Builder ttlDuration(TtlDuration ttlDuration) {
            this.ttlDuration = ttlDuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
