/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStoresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRecordRequest
extends SageMakerFeatureStoreRuntimeRequest
implements ToCopyableBuilder<Builder, DeleteRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(DeleteRecordRequest.getter(DeleteRecordRequest::featureGroupName)).setter(DeleteRecordRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordIdentifierValueAsString").getter(DeleteRecordRequest.getter(DeleteRecordRequest::recordIdentifierValueAsString)).setter(DeleteRecordRequest.setter(Builder::recordIdentifierValueAsString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecordIdentifierValueAsString").build()}).build();
    private static final SdkField<String> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventTime").getter(DeleteRecordRequest.getter(DeleteRecordRequest::eventTime)).setter(DeleteRecordRequest.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EventTime").build()}).build();
    private static final SdkField<List<String>> TARGET_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetStores").getter(DeleteRecordRequest.getter(DeleteRecordRequest::targetStoresAsStrings)).setter(DeleteRecordRequest.setter(Builder::targetStoresWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TargetStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, EVENT_TIME_FIELD, TARGET_STORES_FIELD));
    private final String featureGroupName;
    private final String recordIdentifierValueAsString;
    private final String eventTime;
    private final List<String> targetStores;

    private DeleteRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.eventTime = builder.eventTime;
        this.targetStores = builder.targetStores;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String recordIdentifierValueAsString() {
        return this.recordIdentifierValueAsString;
    }

    public final String eventTime() {
        return this.eventTime;
    }

    public final List<TargetStore> targetStores() {
        return TargetStoresCopier.copyStringToEnum(this.targetStores);
    }

    public final boolean hasTargetStores() {
        return this.targetStores != null && !(this.targetStores instanceof SdkAutoConstructList);
    }

    public final List<String> targetStoresAsStrings() {
        return this.targetStores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetStores() ? this.targetStoresAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecordRequest)) {
            return false;
        }
        DeleteRecordRequest other = (DeleteRecordRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.recordIdentifierValueAsString(), other.recordIdentifierValueAsString()) && Objects.equals(this.eventTime(), other.eventTime()) && this.hasTargetStores() == other.hasTargetStores() && Objects.equals(this.targetStoresAsStrings(), other.targetStoresAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRecordRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("RecordIdentifierValueAsString", (Object)this.recordIdentifierValueAsString()).add("EventTime", (Object)this.eventTime()).add("TargetStores", this.hasTargetStores() ? this.targetStoresAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "RecordIdentifierValueAsString": {
                return Optional.ofNullable(clazz.cast(this.recordIdentifierValueAsString()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "TargetStores": {
                return Optional.ofNullable(clazz.cast(this.targetStoresAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecordRequest, T> g) {
        return obj -> g.apply((DeleteRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private String recordIdentifierValueAsString;
        private String eventTime;
        private List<String> targetStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecordRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            this.eventTime(model.eventTime);
            this.targetStoresWithStrings(model.targetStores);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierValueAsString() {
            return this.recordIdentifierValueAsString;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final String getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(String eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final Collection<String> getTargetStores() {
            if (this.targetStores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetStores;
        }

        public final void setTargetStores(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
        }

        @Override
        public final Builder targetStoresWithStrings(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStoresWithStrings(String ... targetStores) {
            this.targetStoresWithStrings(Arrays.asList(targetStores));
            return this;
        }

        @Override
        public final Builder targetStores(Collection<TargetStore> targetStores) {
            this.targetStores = TargetStoresCopier.copyEnumToString(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStores(TargetStore ... targetStores) {
            this.targetStores(Arrays.asList(targetStores));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecordRequest build() {
            return new DeleteRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerFeatureStoreRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRecordRequest> {
        public Builder featureGroupName(String var1);

        public Builder recordIdentifierValueAsString(String var1);

        public Builder eventTime(String var1);

        public Builder targetStoresWithStrings(Collection<String> var1);

        public Builder targetStoresWithStrings(String ... var1);

        public Builder targetStores(Collection<TargetStore> var1);

        public Builder targetStores(TargetStore ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

