/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakera2iruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakera2iruntime.SageMakerA2IRuntimeClient;
import software.amazon.awssdk.services.sagemakera2iruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest;
import software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse;

public class ListHumanLoopsIterable
implements SdkIterable<ListHumanLoopsResponse> {
    private final SageMakerA2IRuntimeClient client;
    private final ListHumanLoopsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHumanLoopsIterable(SageMakerA2IRuntimeClient client, ListHumanLoopsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHumanLoopsResponseFetcher();
    }

    public Iterator<ListHumanLoopsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HumanLoopSummary> humanLoopSummaries() {
        Function<ListHumanLoopsResponse, Iterator> getIterator = response -> {
            if (response != null && response.humanLoopSummaries() != null) {
                return response.humanLoopSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHumanLoopsResponseFetcher
    implements SyncPageFetcher<ListHumanLoopsResponse> {
        private ListHumanLoopsResponseFetcher() {
        }

        public boolean hasNextPage(ListHumanLoopsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHumanLoopsResponse nextPage(ListHumanLoopsResponse previousPage) {
            if (previousPage == null) {
                return ListHumanLoopsIterable.this.client.listHumanLoops(ListHumanLoopsIterable.this.firstRequest);
            }
            return ListHumanLoopsIterable.this.client.listHumanLoops((ListHumanLoopsRequest)((Object)ListHumanLoopsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

