/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopDataAttributes;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopInput;
import software.amazon.awssdk.services.sagemakera2iruntime.model.SageMakerA2IRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartHumanLoopRequest
extends SageMakerA2IRuntimeRequest
implements ToCopyableBuilder<Builder, StartHumanLoopRequest> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartHumanLoopRequest.getter(StartHumanLoopRequest::humanLoopName)).setter(StartHumanLoopRequest.setter(Builder::humanLoopName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartHumanLoopRequest.getter(StartHumanLoopRequest::flowDefinitionArn)).setter(StartHumanLoopRequest.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()}).build();
    private static final SdkField<HumanLoopInput> HUMAN_LOOP_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartHumanLoopRequest.getter(StartHumanLoopRequest::humanLoopInput)).setter(StartHumanLoopRequest.setter(Builder::humanLoopInput)).constructor(HumanLoopInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopInput").build()}).build();
    private static final SdkField<HumanLoopDataAttributes> DATA_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartHumanLoopRequest.getter(StartHumanLoopRequest::dataAttributes)).setter(StartHumanLoopRequest.setter(Builder::dataAttributes)).constructor(HumanLoopDataAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD, FLOW_DEFINITION_ARN_FIELD, HUMAN_LOOP_INPUT_FIELD, DATA_ATTRIBUTES_FIELD));
    private final String humanLoopName;
    private final String flowDefinitionArn;
    private final HumanLoopInput humanLoopInput;
    private final HumanLoopDataAttributes dataAttributes;

    private StartHumanLoopRequest(BuilderImpl builder) {
        super(builder);
        this.humanLoopName = builder.humanLoopName;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.humanLoopInput = builder.humanLoopInput;
        this.dataAttributes = builder.dataAttributes;
    }

    public String humanLoopName() {
        return this.humanLoopName;
    }

    public String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public HumanLoopInput humanLoopInput() {
        return this.humanLoopInput;
    }

    public HumanLoopDataAttributes dataAttributes() {
        return this.dataAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartHumanLoopRequest)) {
            return false;
        }
        StartHumanLoopRequest other = (StartHumanLoopRequest)((Object)obj);
        return Objects.equals(this.humanLoopName(), other.humanLoopName()) && Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn()) && Objects.equals(this.humanLoopInput(), other.humanLoopInput()) && Objects.equals(this.dataAttributes(), other.dataAttributes());
    }

    public String toString() {
        return ToString.builder((String)"StartHumanLoopRequest").add("HumanLoopName", (Object)this.humanLoopName()).add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).add("HumanLoopInput", (Object)this.humanLoopInput()).add("DataAttributes", (Object)this.dataAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanLoopName": {
                return Optional.ofNullable(clazz.cast(this.humanLoopName()));
            }
            case "FlowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
            case "HumanLoopInput": {
                return Optional.ofNullable(clazz.cast(this.humanLoopInput()));
            }
            case "DataAttributes": {
                return Optional.ofNullable(clazz.cast(this.dataAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartHumanLoopRequest, T> g) {
        return obj -> g.apply((StartHumanLoopRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerA2IRuntimeRequest.BuilderImpl
    implements Builder {
        private String humanLoopName;
        private String flowDefinitionArn;
        private HumanLoopInput humanLoopInput;
        private HumanLoopDataAttributes dataAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartHumanLoopRequest model) {
            super(model);
            this.humanLoopName(model.humanLoopName);
            this.flowDefinitionArn(model.flowDefinitionArn);
            this.humanLoopInput(model.humanLoopInput);
            this.dataAttributes(model.dataAttributes);
        }

        public final String getHumanLoopName() {
            return this.humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public final HumanLoopInput.Builder getHumanLoopInput() {
            return this.humanLoopInput != null ? this.humanLoopInput.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopInput(HumanLoopInput humanLoopInput) {
            this.humanLoopInput = humanLoopInput;
            return this;
        }

        public final void setHumanLoopInput(HumanLoopInput.BuilderImpl humanLoopInput) {
            this.humanLoopInput = humanLoopInput != null ? humanLoopInput.build() : null;
        }

        public final HumanLoopDataAttributes.Builder getDataAttributes() {
            return this.dataAttributes != null ? this.dataAttributes.toBuilder() : null;
        }

        @Override
        public final Builder dataAttributes(HumanLoopDataAttributes dataAttributes) {
            this.dataAttributes = dataAttributes;
            return this;
        }

        public final void setDataAttributes(HumanLoopDataAttributes.BuilderImpl dataAttributes) {
            this.dataAttributes = dataAttributes != null ? dataAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartHumanLoopRequest build() {
            return new StartHumanLoopRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerA2IRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartHumanLoopRequest> {
        public Builder humanLoopName(String var1);

        public Builder flowDefinitionArn(String var1);

        public Builder humanLoopInput(HumanLoopInput var1);

        default public Builder humanLoopInput(Consumer<HumanLoopInput.Builder> humanLoopInput) {
            return this.humanLoopInput((HumanLoopInput)((HumanLoopInput.Builder)HumanLoopInput.builder().applyMutation(humanLoopInput)).build());
        }

        public Builder dataAttributes(HumanLoopDataAttributes var1);

        default public Builder dataAttributes(Consumer<HumanLoopDataAttributes.Builder> dataAttributes) {
            return this.dataAttributes((HumanLoopDataAttributes)((HumanLoopDataAttributes.Builder)HumanLoopDataAttributes.builder().applyMutation(dataAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

