/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanLoopSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanLoopSummary> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HumanLoopSummary.getter(HumanLoopSummary::humanLoopName)).setter(HumanLoopSummary.setter(Builder::humanLoopName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()}).build();
    private static final SdkField<String> HUMAN_LOOP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HumanLoopSummary.getter(HumanLoopSummary::humanLoopStatusAsString)).setter(HumanLoopSummary.setter(Builder::humanLoopStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(HumanLoopSummary.getter(HumanLoopSummary::creationTime)).setter(HumanLoopSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HumanLoopSummary.getter(HumanLoopSummary::failureReason)).setter(HumanLoopSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HumanLoopSummary.getter(HumanLoopSummary::flowDefinitionArn)).setter(HumanLoopSummary.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD, HUMAN_LOOP_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, FLOW_DEFINITION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String humanLoopName;
    private final String humanLoopStatus;
    private final Instant creationTime;
    private final String failureReason;
    private final String flowDefinitionArn;

    private HumanLoopSummary(BuilderImpl builder) {
        this.humanLoopName = builder.humanLoopName;
        this.humanLoopStatus = builder.humanLoopStatus;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.flowDefinitionArn = builder.flowDefinitionArn;
    }

    public String humanLoopName() {
        return this.humanLoopName;
    }

    public HumanLoopStatus humanLoopStatus() {
        return HumanLoopStatus.fromValue(this.humanLoopStatus);
    }

    public String humanLoopStatusAsString() {
        return this.humanLoopStatus;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopSummary)) {
            return false;
        }
        HumanLoopSummary other = (HumanLoopSummary)obj;
        return Objects.equals(this.humanLoopName(), other.humanLoopName()) && Objects.equals(this.humanLoopStatusAsString(), other.humanLoopStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn());
    }

    public String toString() {
        return ToString.builder((String)"HumanLoopSummary").add("HumanLoopName", (Object)this.humanLoopName()).add("HumanLoopStatus", (Object)this.humanLoopStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanLoopName": {
                return Optional.ofNullable(clazz.cast(this.humanLoopName()));
            }
            case "HumanLoopStatus": {
                return Optional.ofNullable(clazz.cast(this.humanLoopStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "FlowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopSummary, T> g) {
        return obj -> g.apply((HumanLoopSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String humanLoopName;
        private String humanLoopStatus;
        private Instant creationTime;
        private String failureReason;
        private String flowDefinitionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopSummary model) {
            this.humanLoopName(model.humanLoopName);
            this.humanLoopStatus(model.humanLoopStatus);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.flowDefinitionArn(model.flowDefinitionArn);
        }

        public final String getHumanLoopName() {
            return this.humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        public final String getHumanLoopStatusAsString() {
            return this.humanLoopStatus;
        }

        @Override
        public final Builder humanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
            return this;
        }

        @Override
        public final Builder humanLoopStatus(HumanLoopStatus humanLoopStatus) {
            this.humanLoopStatus(humanLoopStatus == null ? null : humanLoopStatus.toString());
            return this;
        }

        public final void setHumanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public HumanLoopSummary build() {
            return new HumanLoopSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanLoopSummary> {
        public Builder humanLoopName(String var1);

        public Builder humanLoopStatus(String var1);

        public Builder humanLoopStatus(HumanLoopStatus var1);

        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder flowDefinitionArn(String var1);
    }
}

