/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.Framework;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfig.getter(InputConfig::s3Uri)).setter(InputConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> DATA_INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfig.getter(InputConfig::dataInputConfig)).setter(InputConfig.setter(Builder::dataInputConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfig").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputConfig.getter(InputConfig::frameworkAsString)).setter(InputConfig.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, DATA_INPUT_CONFIG_FIELD, FRAMEWORK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String dataInputConfig;
    private final String framework;

    private InputConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.dataInputConfig = builder.dataInputConfig;
        this.framework = builder.framework;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public String dataInputConfig() {
        return this.dataInputConfig;
    }

    public Framework framework() {
        return Framework.fromValue(this.framework);
    }

    public String frameworkAsString() {
        return this.framework;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataInputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfig)) {
            return false;
        }
        InputConfig other = (InputConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.dataInputConfig(), other.dataInputConfig()) && Objects.equals(this.frameworkAsString(), other.frameworkAsString());
    }

    public String toString() {
        return ToString.builder((String)"InputConfig").add("S3Uri", (Object)this.s3Uri()).add("DataInputConfig", (Object)this.dataInputConfig()).add("Framework", (Object)this.frameworkAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "DataInputConfig": {
                return Optional.ofNullable(clazz.cast(this.dataInputConfig()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.frameworkAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfig, T> g) {
        return obj -> g.apply((InputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String dataInputConfig;
        private String framework;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfig model) {
            this.s3Uri(model.s3Uri);
            this.dataInputConfig(model.dataInputConfig);
            this.framework(model.framework);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getDataInputConfig() {
            return this.dataInputConfig;
        }

        @Override
        public final Builder dataInputConfig(String dataInputConfig) {
            this.dataInputConfig = dataInputConfig;
            return this;
        }

        public final void setDataInputConfig(String dataInputConfig) {
            this.dataInputConfig = dataInputConfig;
        }

        public final String getFrameworkAsString() {
            return this.framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework.toString());
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public InputConfig build() {
            return new InputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputConfig> {
        public Builder s3Uri(String var1);

        public Builder dataInputConfig(String var1);

        public Builder framework(String var1);

        public Builder framework(Framework var1);
    }
}

