/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ParameterType {
    INTEGER("Integer"),
    CONTINUOUS("Continuous"),
    CATEGORICAL("Categorical"),
    FREE_TEXT("FreeText"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ParameterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParameterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ParameterType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParameterType> knownValues() {
        return Stream.of(ParameterType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

