/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class USD
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, USD> {
    private static final SdkField<Integer> DOLLARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(USD.getter(USD::dollars)).setter(USD.setter(Builder::dollars)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dollars").build()}).build();
    private static final SdkField<Integer> CENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(USD.getter(USD::cents)).setter(USD.setter(Builder::cents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cents").build()}).build();
    private static final SdkField<Integer> TENTH_FRACTIONS_OF_A_CENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(USD.getter(USD::tenthFractionsOfACent)).setter(USD.setter(Builder::tenthFractionsOfACent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenthFractionsOfACent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOLLARS_FIELD, CENTS_FIELD, TENTH_FRACTIONS_OF_A_CENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dollars;
    private final Integer cents;
    private final Integer tenthFractionsOfACent;

    private USD(BuilderImpl builder) {
        this.dollars = builder.dollars;
        this.cents = builder.cents;
        this.tenthFractionsOfACent = builder.tenthFractionsOfACent;
    }

    public Integer dollars() {
        return this.dollars;
    }

    public Integer cents() {
        return this.cents;
    }

    public Integer tenthFractionsOfACent() {
        return this.tenthFractionsOfACent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dollars());
        hashCode = 31 * hashCode + Objects.hashCode(this.cents());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenthFractionsOfACent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof USD)) {
            return false;
        }
        USD other = (USD)obj;
        return Objects.equals(this.dollars(), other.dollars()) && Objects.equals(this.cents(), other.cents()) && Objects.equals(this.tenthFractionsOfACent(), other.tenthFractionsOfACent());
    }

    public String toString() {
        return ToString.builder((String)"USD").add("Dollars", (Object)this.dollars()).add("Cents", (Object)this.cents()).add("TenthFractionsOfACent", (Object)this.tenthFractionsOfACent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dollars": {
                return Optional.ofNullable(clazz.cast(this.dollars()));
            }
            case "Cents": {
                return Optional.ofNullable(clazz.cast(this.cents()));
            }
            case "TenthFractionsOfACent": {
                return Optional.ofNullable(clazz.cast(this.tenthFractionsOfACent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<USD, T> g) {
        return obj -> g.apply((USD)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dollars;
        private Integer cents;
        private Integer tenthFractionsOfACent;

        private BuilderImpl() {
        }

        private BuilderImpl(USD model) {
            this.dollars(model.dollars);
            this.cents(model.cents);
            this.tenthFractionsOfACent(model.tenthFractionsOfACent);
        }

        public final Integer getDollars() {
            return this.dollars;
        }

        @Override
        public final Builder dollars(Integer dollars) {
            this.dollars = dollars;
            return this;
        }

        public final void setDollars(Integer dollars) {
            this.dollars = dollars;
        }

        public final Integer getCents() {
            return this.cents;
        }

        @Override
        public final Builder cents(Integer cents) {
            this.cents = cents;
            return this;
        }

        public final void setCents(Integer cents) {
            this.cents = cents;
        }

        public final Integer getTenthFractionsOfACent() {
            return this.tenthFractionsOfACent;
        }

        @Override
        public final Builder tenthFractionsOfACent(Integer tenthFractionsOfACent) {
            this.tenthFractionsOfACent = tenthFractionsOfACent;
            return this;
        }

        public final void setTenthFractionsOfACent(Integer tenthFractionsOfACent) {
            this.tenthFractionsOfACent = tenthFractionsOfACent;
        }

        public USD build() {
            return new USD(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, USD> {
        public Builder dollars(Integer var1);

        public Builder cents(Integer var1);

        public Builder tenthFractionsOfACent(Integer var1);
    }
}

