/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListUltraServersByReservedCapacityRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUltraServersByReservedCapacityResponse;
import software.amazon.awssdk.services.sagemaker.model.UltraServer;

public class ListUltraServersByReservedCapacityIterable
implements SdkIterable<ListUltraServersByReservedCapacityResponse> {
    private final SageMakerClient client;
    private final ListUltraServersByReservedCapacityRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUltraServersByReservedCapacityIterable(SageMakerClient client, ListUltraServersByReservedCapacityRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUltraServersByReservedCapacityResponseFetcher();
    }

    public Iterator<ListUltraServersByReservedCapacityResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UltraServer> ultraServers() {
        Function<ListUltraServersByReservedCapacityResponse, Iterator> getIterator = response -> {
            if (response != null && response.ultraServers() != null) {
                return response.ultraServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUltraServersByReservedCapacityResponseFetcher
    implements SyncPageFetcher<ListUltraServersByReservedCapacityResponse> {
        private ListUltraServersByReservedCapacityResponseFetcher() {
        }

        public boolean hasNextPage(ListUltraServersByReservedCapacityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUltraServersByReservedCapacityResponse nextPage(ListUltraServersByReservedCapacityResponse previousPage) {
            if (previousPage == null) {
                return ListUltraServersByReservedCapacityIterable.this.client.listUltraServersByReservedCapacity(ListUltraServersByReservedCapacityIterable.this.firstRequest);
            }
            return ListUltraServersByReservedCapacityIterable.this.client.listUltraServersByReservedCapacity((ListUltraServersByReservedCapacityRequest)((Object)ListUltraServersByReservedCapacityIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

