/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Phase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Phase> {
    private static final SdkField<Integer> INITIAL_NUMBER_OF_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InitialNumberOfUsers").getter(Phase.getter(Phase::initialNumberOfUsers)).setter(Phase.setter(Builder::initialNumberOfUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialNumberOfUsers").build()}).build();
    private static final SdkField<Integer> SPAWN_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SpawnRate").getter(Phase.getter(Phase::spawnRate)).setter(Phase.setter(Builder::spawnRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpawnRate").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInSeconds").getter(Phase.getter(Phase::durationInSeconds)).setter(Phase.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_NUMBER_OF_USERS_FIELD, SPAWN_RATE_FIELD, DURATION_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Phase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer initialNumberOfUsers;
    private final Integer spawnRate;
    private final Integer durationInSeconds;

    private Phase(BuilderImpl builder) {
        this.initialNumberOfUsers = builder.initialNumberOfUsers;
        this.spawnRate = builder.spawnRate;
        this.durationInSeconds = builder.durationInSeconds;
    }

    public final Integer initialNumberOfUsers() {
        return this.initialNumberOfUsers;
    }

    public final Integer spawnRate() {
        return this.spawnRate;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initialNumberOfUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.spawnRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Phase)) {
            return false;
        }
        Phase other = (Phase)obj;
        return Objects.equals(this.initialNumberOfUsers(), other.initialNumberOfUsers()) && Objects.equals(this.spawnRate(), other.spawnRate()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"Phase").add("InitialNumberOfUsers", (Object)this.initialNumberOfUsers()).add("SpawnRate", (Object)this.spawnRate()).add("DurationInSeconds", (Object)this.durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InitialNumberOfUsers": {
                return Optional.ofNullable(clazz.cast(this.initialNumberOfUsers()));
            }
            case "SpawnRate": {
                return Optional.ofNullable(clazz.cast(this.spawnRate()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("InitialNumberOfUsers", INITIAL_NUMBER_OF_USERS_FIELD);
        map.put("SpawnRate", SPAWN_RATE_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Phase, T> g) {
        return obj -> g.apply((Phase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer initialNumberOfUsers;
        private Integer spawnRate;
        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Phase model) {
            this.initialNumberOfUsers(model.initialNumberOfUsers);
            this.spawnRate(model.spawnRate);
            this.durationInSeconds(model.durationInSeconds);
        }

        public final Integer getInitialNumberOfUsers() {
            return this.initialNumberOfUsers;
        }

        public final void setInitialNumberOfUsers(Integer initialNumberOfUsers) {
            this.initialNumberOfUsers = initialNumberOfUsers;
        }

        @Override
        public final Builder initialNumberOfUsers(Integer initialNumberOfUsers) {
            this.initialNumberOfUsers = initialNumberOfUsers;
            return this;
        }

        public final Integer getSpawnRate() {
            return this.spawnRate;
        }

        public final void setSpawnRate(Integer spawnRate) {
            this.spawnRate = spawnRate;
        }

        @Override
        public final Builder spawnRate(Integer spawnRate) {
            this.spawnRate = spawnRate;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public Phase build() {
            return new Phase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Phase> {
        public Builder initialNumberOfUsers(Integer var1);

        public Builder spawnRate(Integer var1);

        public Builder durationInSeconds(Integer var1);
    }
}

