/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MlflowConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MlflowConfig> {
    private static final SdkField<String> MLFLOW_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowResourceArn").getter(MlflowConfig.getter(MlflowConfig::mlflowResourceArn)).setter(MlflowConfig.setter(Builder::mlflowResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowResourceArn").build()}).build();
    private static final SdkField<String> MLFLOW_EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowExperimentName").getter(MlflowConfig.getter(MlflowConfig::mlflowExperimentName)).setter(MlflowConfig.setter(Builder::mlflowExperimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowExperimentName").build()}).build();
    private static final SdkField<String> MLFLOW_RUN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowRunName").getter(MlflowConfig.getter(MlflowConfig::mlflowRunName)).setter(MlflowConfig.setter(Builder::mlflowRunName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowRunName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MLFLOW_RESOURCE_ARN_FIELD, MLFLOW_EXPERIMENT_NAME_FIELD, MLFLOW_RUN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MlflowConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mlflowResourceArn;
    private final String mlflowExperimentName;
    private final String mlflowRunName;

    private MlflowConfig(BuilderImpl builder) {
        this.mlflowResourceArn = builder.mlflowResourceArn;
        this.mlflowExperimentName = builder.mlflowExperimentName;
        this.mlflowRunName = builder.mlflowRunName;
    }

    public final String mlflowResourceArn() {
        return this.mlflowResourceArn;
    }

    public final String mlflowExperimentName() {
        return this.mlflowExperimentName;
    }

    public final String mlflowRunName() {
        return this.mlflowRunName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowExperimentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowRunName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MlflowConfig)) {
            return false;
        }
        MlflowConfig other = (MlflowConfig)obj;
        return Objects.equals(this.mlflowResourceArn(), other.mlflowResourceArn()) && Objects.equals(this.mlflowExperimentName(), other.mlflowExperimentName()) && Objects.equals(this.mlflowRunName(), other.mlflowRunName());
    }

    public final String toString() {
        return ToString.builder((String)"MlflowConfig").add("MlflowResourceArn", (Object)this.mlflowResourceArn()).add("MlflowExperimentName", (Object)this.mlflowExperimentName()).add("MlflowRunName", (Object)this.mlflowRunName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MlflowResourceArn": {
                return Optional.ofNullable(clazz.cast(this.mlflowResourceArn()));
            }
            case "MlflowExperimentName": {
                return Optional.ofNullable(clazz.cast(this.mlflowExperimentName()));
            }
            case "MlflowRunName": {
                return Optional.ofNullable(clazz.cast(this.mlflowRunName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MlflowResourceArn", MLFLOW_RESOURCE_ARN_FIELD);
        map.put("MlflowExperimentName", MLFLOW_EXPERIMENT_NAME_FIELD);
        map.put("MlflowRunName", MLFLOW_RUN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MlflowConfig, T> g) {
        return obj -> g.apply((MlflowConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mlflowResourceArn;
        private String mlflowExperimentName;
        private String mlflowRunName;

        private BuilderImpl() {
        }

        private BuilderImpl(MlflowConfig model) {
            this.mlflowResourceArn(model.mlflowResourceArn);
            this.mlflowExperimentName(model.mlflowExperimentName);
            this.mlflowRunName(model.mlflowRunName);
        }

        public final String getMlflowResourceArn() {
            return this.mlflowResourceArn;
        }

        public final void setMlflowResourceArn(String mlflowResourceArn) {
            this.mlflowResourceArn = mlflowResourceArn;
        }

        @Override
        public final Builder mlflowResourceArn(String mlflowResourceArn) {
            this.mlflowResourceArn = mlflowResourceArn;
            return this;
        }

        public final String getMlflowExperimentName() {
            return this.mlflowExperimentName;
        }

        public final void setMlflowExperimentName(String mlflowExperimentName) {
            this.mlflowExperimentName = mlflowExperimentName;
        }

        @Override
        public final Builder mlflowExperimentName(String mlflowExperimentName) {
            this.mlflowExperimentName = mlflowExperimentName;
            return this;
        }

        public final String getMlflowRunName() {
            return this.mlflowRunName;
        }

        public final void setMlflowRunName(String mlflowRunName) {
            this.mlflowRunName = mlflowRunName;
        }

        @Override
        public final Builder mlflowRunName(String mlflowRunName) {
            this.mlflowRunName = mlflowRunName;
            return this;
        }

        public MlflowConfig build() {
            return new MlflowConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MlflowConfig> {
        public Builder mlflowResourceArn(String var1);

        public Builder mlflowExperimentName(String var1);

        public Builder mlflowRunName(String var1);
    }
}

