/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum;
import software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum;
import software.amazon.awssdk.services.sagemaker.model.MetricSetSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDatum
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDatum> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricDatum.getter(MetricDatum::metricNameAsString)).setter(MetricDatum.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> STANDARD_METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardMetricName").getter(MetricDatum.getter(MetricDatum::standardMetricNameAsString)).setter(MetricDatum.setter(Builder::standardMetricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardMetricName").build()}).build();
    private static final SdkField<Float> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Value").getter(MetricDatum.getter(MetricDatum::value)).setter(MetricDatum.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Set").getter(MetricDatum.getter(MetricDatum::setAsString)).setter(MetricDatum.setter(Builder::set)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Set").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, STANDARD_METRIC_NAME_FIELD, VALUE_FIELD, SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricDatum.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String standardMetricName;
    private final Float value;
    private final String set;

    private MetricDatum(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.standardMetricName = builder.standardMetricName;
        this.value = builder.value;
        this.set = builder.set;
    }

    public final AutoMLMetricEnum metricName() {
        return AutoMLMetricEnum.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final AutoMLMetricExtendedEnum standardMetricName() {
        return AutoMLMetricExtendedEnum.fromValue(this.standardMetricName);
    }

    public final String standardMetricNameAsString() {
        return this.standardMetricName;
    }

    public final Float value() {
        return this.value;
    }

    public final MetricSetSource set() {
        return MetricSetSource.fromValue(this.set);
    }

    public final String setAsString() {
        return this.set;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardMetricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        return Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.standardMetricNameAsString(), other.standardMetricNameAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.setAsString(), other.setAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDatum").add("MetricName", (Object)this.metricNameAsString()).add("StandardMetricName", (Object)this.standardMetricNameAsString()).add("Value", (Object)this.value()).add("Set", (Object)this.setAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "StandardMetricName": {
                return Optional.ofNullable(clazz.cast(this.standardMetricNameAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Set": {
                return Optional.ofNullable(clazz.cast(this.setAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("StandardMetricName", STANDARD_METRIC_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Set", SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDatum, T> g) {
        return obj -> g.apply((MetricDatum)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String standardMetricName;
        private Float value;
        private String set;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatum model) {
            this.metricName(model.metricName);
            this.standardMetricName(model.standardMetricName);
            this.value(model.value);
            this.set(model.set);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(AutoMLMetricEnum metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final String getStandardMetricName() {
            return this.standardMetricName;
        }

        public final void setStandardMetricName(String standardMetricName) {
            this.standardMetricName = standardMetricName;
        }

        @Override
        public final Builder standardMetricName(String standardMetricName) {
            this.standardMetricName = standardMetricName;
            return this;
        }

        @Override
        public final Builder standardMetricName(AutoMLMetricExtendedEnum standardMetricName) {
            this.standardMetricName(standardMetricName == null ? null : standardMetricName.toString());
            return this;
        }

        public final Float getValue() {
            return this.value;
        }

        public final void setValue(Float value) {
            this.value = value;
        }

        @Override
        public final Builder value(Float value) {
            this.value = value;
            return this;
        }

        public final String getSet() {
            return this.set;
        }

        public final void setSet(String set) {
            this.set = set;
        }

        @Override
        @Transient
        public final Builder set(String set) {
            this.set = set;
            return this;
        }

        @Override
        @Transient
        public final Builder set(MetricSetSource set) {
            this.set(set == null ? null : set.toString());
            return this;
        }

        public MetricDatum build() {
            return new MetricDatum(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDatum> {
        public Builder metricName(String var1);

        public Builder metricName(AutoMLMetricEnum var1);

        public Builder standardMetricName(String var1);

        public Builder standardMetricName(AutoMLMetricExtendedEnum var1);

        public Builder value(Float var1);

        public Builder set(String var1);

        public Builder set(MetricSetSource var1);
    }
}

