/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MIGProfileType {
    MIG_1_G_5_GB("mig-1g.5gb"),
    MIG_1_G_10_GB("mig-1g.10gb"),
    MIG_1_G_18_GB("mig-1g.18gb"),
    MIG_1_G_20_GB("mig-1g.20gb"),
    MIG_1_G_23_GB("mig-1g.23gb"),
    MIG_1_G_35_GB("mig-1g.35gb"),
    MIG_1_G_45_GB("mig-1g.45gb"),
    MIG_1_G_47_GB("mig-1g.47gb"),
    MIG_2_G_10_GB("mig-2g.10gb"),
    MIG_2_G_20_GB("mig-2g.20gb"),
    MIG_2_G_35_GB("mig-2g.35gb"),
    MIG_2_G_45_GB("mig-2g.45gb"),
    MIG_2_G_47_GB("mig-2g.47gb"),
    MIG_3_G_20_GB("mig-3g.20gb"),
    MIG_3_G_40_GB("mig-3g.40gb"),
    MIG_3_G_71_GB("mig-3g.71gb"),
    MIG_3_G_90_GB("mig-3g.90gb"),
    MIG_3_G_93_GB("mig-3g.93gb"),
    MIG_4_G_20_GB("mig-4g.20gb"),
    MIG_4_G_40_GB("mig-4g.40gb"),
    MIG_4_G_71_GB("mig-4g.71gb"),
    MIG_4_G_90_GB("mig-4g.90gb"),
    MIG_4_G_93_GB("mig-4g.93gb"),
    MIG_7_G_40_GB("mig-7g.40gb"),
    MIG_7_G_80_GB("mig-7g.80gb"),
    MIG_7_G_141_GB("mig-7g.141gb"),
    MIG_7_G_180_GB("mig-7g.180gb"),
    MIG_7_G_186_GB("mig-7g.186gb"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MIGProfileType> VALUE_MAP;
    private final String value;

    private MIGProfileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MIGProfileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MIGProfileType> knownValues() {
        EnumSet<MIGProfileType> knownValues = EnumSet.allOf(MIGProfileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MIGProfileType.class, MIGProfileType::toString);
    }
}

