/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaseModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BaseModel> {
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(BaseModel.getter(BaseModel::hubContentName)).setter(BaseModel.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentVersion").getter(BaseModel.getter(BaseModel::hubContentVersion)).setter(BaseModel.setter(Builder::hubContentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()}).build();
    private static final SdkField<String> RECIPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipeName").getter(BaseModel.getter(BaseModel::recipeName)).setter(BaseModel.setter(Builder::recipeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_NAME_FIELD, HUB_CONTENT_VERSION_FIELD, RECIPE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BaseModel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hubContentName;
    private final String hubContentVersion;
    private final String recipeName;

    private BaseModel(BuilderImpl builder) {
        this.hubContentName = builder.hubContentName;
        this.hubContentVersion = builder.hubContentVersion;
        this.recipeName = builder.recipeName;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final String hubContentVersion() {
        return this.hubContentVersion;
    }

    public final String recipeName() {
        return this.recipeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseModel)) {
            return false;
        }
        BaseModel other = (BaseModel)obj;
        return Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.hubContentVersion(), other.hubContentVersion()) && Objects.equals(this.recipeName(), other.recipeName());
    }

    public final String toString() {
        return ToString.builder((String)"BaseModel").add("HubContentName", (Object)this.hubContentName()).add("HubContentVersion", (Object)this.hubContentVersion()).add("RecipeName", (Object)this.recipeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "HubContentVersion": {
                return Optional.ofNullable(clazz.cast(this.hubContentVersion()));
            }
            case "RecipeName": {
                return Optional.ofNullable(clazz.cast(this.recipeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("RecipeName", RECIPE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BaseModel, T> g) {
        return obj -> g.apply((BaseModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hubContentName;
        private String hubContentVersion;
        private String recipeName;

        private BuilderImpl() {
        }

        private BuilderImpl(BaseModel model) {
            this.hubContentName(model.hubContentName);
            this.hubContentVersion(model.hubContentVersion);
            this.recipeName(model.recipeName);
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentVersion() {
            return this.hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getRecipeName() {
            return this.recipeName;
        }

        public final void setRecipeName(String recipeName) {
            this.recipeName = recipeName;
        }

        @Override
        public final Builder recipeName(String recipeName) {
            this.recipeName = recipeName;
            return this;
        }

        public BaseModel build() {
            return new BaseModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BaseModel> {
        public Builder hubContentName(String var1);

        public Builder hubContentVersion(String var1);

        public Builder recipeName(String var1);
    }
}

