/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;

public class ListCompilationJobsIterable
implements SdkIterable<ListCompilationJobsResponse> {
    private final SageMakerClient client;
    private final ListCompilationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCompilationJobsIterable(SageMakerClient client, ListCompilationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCompilationJobsResponseFetcher();
    }

    public Iterator<ListCompilationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListCompilationJobsIterable resume(ListCompilationJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCompilationJobsIterable(this.client, (ListCompilationJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCompilationJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCompilationJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCompilationJobsResponseFetcher
    implements SyncPageFetcher<ListCompilationJobsResponse> {
        private ListCompilationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompilationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCompilationJobsResponse nextPage(ListCompilationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCompilationJobsIterable.this.client.listCompilationJobs(ListCompilationJobsIterable.this.firstRequest);
            }
            return ListCompilationJobsIterable.this.client.listCompilationJobs((ListCompilationJobsRequest)((Object)ListCompilationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

