/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListUltraServersByReservedCapacityRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUltraServersByReservedCapacityResponse;
import software.amazon.awssdk.services.sagemaker.model.UltraServer;

public class ListUltraServersByReservedCapacityPublisher
implements SdkPublisher<ListUltraServersByReservedCapacityResponse> {
    private final SageMakerAsyncClient client;
    private final ListUltraServersByReservedCapacityRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUltraServersByReservedCapacityPublisher(SageMakerAsyncClient client, ListUltraServersByReservedCapacityRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUltraServersByReservedCapacityPublisher(SageMakerAsyncClient client, ListUltraServersByReservedCapacityRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUltraServersByReservedCapacityResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUltraServersByReservedCapacityResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UltraServer> ultraServers() {
        Function<ListUltraServersByReservedCapacityResponse, Iterator> getIterator = response -> {
            if (response != null && response.ultraServers() != null) {
                return response.ultraServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUltraServersByReservedCapacityResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUltraServersByReservedCapacityResponseFetcher
    implements AsyncPageFetcher<ListUltraServersByReservedCapacityResponse> {
        private ListUltraServersByReservedCapacityResponseFetcher() {
        }

        public boolean hasNextPage(ListUltraServersByReservedCapacityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUltraServersByReservedCapacityResponse> nextPage(ListUltraServersByReservedCapacityResponse previousPage) {
            if (previousPage == null) {
                return ListUltraServersByReservedCapacityPublisher.this.client.listUltraServersByReservedCapacity(ListUltraServersByReservedCapacityPublisher.this.firstRequest);
            }
            return ListUltraServersByReservedCapacityPublisher.this.client.listUltraServersByReservedCapacity((ListUltraServersByReservedCapacityRequest)((Object)ListUltraServersByReservedCapacityPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

