/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterAutoScalerType;
import software.amazon.awssdk.services.sagemaker.model.ClusterAutoScalingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterAutoScalingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterAutoScalingConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ClusterAutoScalingConfig.getter(ClusterAutoScalingConfig::modeAsString)).setter(ClusterAutoScalingConfig.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> AUTO_SCALER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalerType").getter(ClusterAutoScalingConfig.getter(ClusterAutoScalingConfig::autoScalerTypeAsString)).setter(ClusterAutoScalingConfig.setter(Builder::autoScalerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, AUTO_SCALER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterAutoScalingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String autoScalerType;

    private ClusterAutoScalingConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.autoScalerType = builder.autoScalerType;
    }

    public final ClusterAutoScalingMode mode() {
        return ClusterAutoScalingMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ClusterAutoScalerType autoScalerType() {
        return ClusterAutoScalerType.fromValue(this.autoScalerType);
    }

    public final String autoScalerTypeAsString() {
        return this.autoScalerType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterAutoScalingConfig)) {
            return false;
        }
        ClusterAutoScalingConfig other = (ClusterAutoScalingConfig)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.autoScalerTypeAsString(), other.autoScalerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterAutoScalingConfig").add("Mode", (Object)this.modeAsString()).add("AutoScalerType", (Object)this.autoScalerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "AutoScalerType": {
                return Optional.ofNullable(clazz.cast(this.autoScalerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Mode", MODE_FIELD);
        map.put("AutoScalerType", AUTO_SCALER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterAutoScalingConfig, T> g) {
        return obj -> g.apply((ClusterAutoScalingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String autoScalerType;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterAutoScalingConfig model) {
            this.mode(model.mode);
            this.autoScalerType(model.autoScalerType);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterAutoScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getAutoScalerType() {
            return this.autoScalerType;
        }

        public final void setAutoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
        }

        @Override
        public final Builder autoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
            return this;
        }

        @Override
        public final Builder autoScalerType(ClusterAutoScalerType autoScalerType) {
            this.autoScalerType(autoScalerType == null ? null : autoScalerType.toString());
            return this;
        }

        public ClusterAutoScalingConfig build() {
            return new ClusterAutoScalingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterAutoScalingConfig> {
        public Builder mode(String var1);

        public Builder mode(ClusterAutoScalingMode var1);

        public Builder autoScalerType(String var1);

        public Builder autoScalerType(ClusterAutoScalerType var1);
    }
}

