/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OptimizationModelAccessConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationJobModelSourceS3
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationJobModelSourceS3> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(OptimizationJobModelSourceS3.getter(OptimizationJobModelSourceS3::s3Uri)).setter(OptimizationJobModelSourceS3.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<OptimizationModelAccessConfig> MODEL_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelAccessConfig").getter(OptimizationJobModelSourceS3.getter(OptimizationJobModelSourceS3::modelAccessConfig)).setter(OptimizationJobModelSourceS3.setter(Builder::modelAccessConfig)).constructor(OptimizationModelAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelAccessConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, MODEL_ACCESS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizationJobModelSourceS3.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final OptimizationModelAccessConfig modelAccessConfig;

    private OptimizationJobModelSourceS3(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.modelAccessConfig = builder.modelAccessConfig;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final OptimizationModelAccessConfig modelAccessConfig() {
        return this.modelAccessConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelAccessConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobModelSourceS3)) {
            return false;
        }
        OptimizationJobModelSourceS3 other = (OptimizationJobModelSourceS3)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.modelAccessConfig(), other.modelAccessConfig());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationJobModelSourceS3").add("S3Uri", (Object)this.s3Uri()).add("ModelAccessConfig", (Object)this.modelAccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "ModelAccessConfig": {
                return Optional.ofNullable(clazz.cast(this.modelAccessConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3Uri", S3_URI_FIELD);
        map.put("ModelAccessConfig", MODEL_ACCESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobModelSourceS3, T> g) {
        return obj -> g.apply((OptimizationJobModelSourceS3)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private OptimizationModelAccessConfig modelAccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobModelSourceS3 model) {
            this.s3Uri(model.s3Uri);
            this.modelAccessConfig(model.modelAccessConfig);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final OptimizationModelAccessConfig.Builder getModelAccessConfig() {
            return this.modelAccessConfig != null ? this.modelAccessConfig.toBuilder() : null;
        }

        public final void setModelAccessConfig(OptimizationModelAccessConfig.BuilderImpl modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig != null ? modelAccessConfig.build() : null;
        }

        @Override
        public final Builder modelAccessConfig(OptimizationModelAccessConfig modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig;
            return this;
        }

        public OptimizationJobModelSourceS3 build() {
            return new OptimizationJobModelSourceS3(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationJobModelSourceS3> {
        public Builder s3Uri(String var1);

        public Builder modelAccessConfig(OptimizationModelAccessConfig var1);

        default public Builder modelAccessConfig(Consumer<OptimizationModelAccessConfig.Builder> modelAccessConfig) {
            return this.modelAccessConfig((OptimizationModelAccessConfig)((OptimizationModelAccessConfig.Builder)OptimizationModelAccessConfig.builder().applyMutation(modelAccessConfig)).build());
        }
    }
}

