/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.GroupingAttributeNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesConfig> {
    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAttributeName").getter(TimeSeriesConfig.getter(TimeSeriesConfig::targetAttributeName)).setter(TimeSeriesConfig.setter(Builder::targetAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build()}).build();
    private static final SdkField<String> TIMESTAMP_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampAttributeName").getter(TimeSeriesConfig.getter(TimeSeriesConfig::timestampAttributeName)).setter(TimeSeriesConfig.setter(Builder::timestampAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampAttributeName").build()}).build();
    private static final SdkField<String> ITEM_IDENTIFIER_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ItemIdentifierAttributeName").getter(TimeSeriesConfig.getter(TimeSeriesConfig::itemIdentifierAttributeName)).setter(TimeSeriesConfig.setter(Builder::itemIdentifierAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemIdentifierAttributeName").build()}).build();
    private static final SdkField<List<String>> GROUPING_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupingAttributeNames").getter(TimeSeriesConfig.getter(TimeSeriesConfig::groupingAttributeNames)).setter(TimeSeriesConfig.setter(Builder::groupingAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ATTRIBUTE_NAME_FIELD, TIMESTAMP_ATTRIBUTE_NAME_FIELD, ITEM_IDENTIFIER_ATTRIBUTE_NAME_FIELD, GROUPING_ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeSeriesConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetAttributeName;
    private final String timestampAttributeName;
    private final String itemIdentifierAttributeName;
    private final List<String> groupingAttributeNames;

    private TimeSeriesConfig(BuilderImpl builder) {
        this.targetAttributeName = builder.targetAttributeName;
        this.timestampAttributeName = builder.timestampAttributeName;
        this.itemIdentifierAttributeName = builder.itemIdentifierAttributeName;
        this.groupingAttributeNames = builder.groupingAttributeNames;
    }

    public final String targetAttributeName() {
        return this.targetAttributeName;
    }

    public final String timestampAttributeName() {
        return this.timestampAttributeName;
    }

    public final String itemIdentifierAttributeName() {
        return this.itemIdentifierAttributeName;
    }

    public final boolean hasGroupingAttributeNames() {
        return this.groupingAttributeNames != null && !(this.groupingAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> groupingAttributeNames() {
        return this.groupingAttributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemIdentifierAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupingAttributeNames() ? this.groupingAttributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesConfig)) {
            return false;
        }
        TimeSeriesConfig other = (TimeSeriesConfig)obj;
        return Objects.equals(this.targetAttributeName(), other.targetAttributeName()) && Objects.equals(this.timestampAttributeName(), other.timestampAttributeName()) && Objects.equals(this.itemIdentifierAttributeName(), other.itemIdentifierAttributeName()) && this.hasGroupingAttributeNames() == other.hasGroupingAttributeNames() && Objects.equals(this.groupingAttributeNames(), other.groupingAttributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesConfig").add("TargetAttributeName", (Object)this.targetAttributeName()).add("TimestampAttributeName", (Object)this.timestampAttributeName()).add("ItemIdentifierAttributeName", (Object)this.itemIdentifierAttributeName()).add("GroupingAttributeNames", this.hasGroupingAttributeNames() ? this.groupingAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetAttributeName": {
                return Optional.ofNullable(clazz.cast(this.targetAttributeName()));
            }
            case "TimestampAttributeName": {
                return Optional.ofNullable(clazz.cast(this.timestampAttributeName()));
            }
            case "ItemIdentifierAttributeName": {
                return Optional.ofNullable(clazz.cast(this.itemIdentifierAttributeName()));
            }
            case "GroupingAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.groupingAttributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetAttributeName", TARGET_ATTRIBUTE_NAME_FIELD);
        map.put("TimestampAttributeName", TIMESTAMP_ATTRIBUTE_NAME_FIELD);
        map.put("ItemIdentifierAttributeName", ITEM_IDENTIFIER_ATTRIBUTE_NAME_FIELD);
        map.put("GroupingAttributeNames", GROUPING_ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesConfig, T> g) {
        return obj -> g.apply((TimeSeriesConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetAttributeName;
        private String timestampAttributeName;
        private String itemIdentifierAttributeName;
        private List<String> groupingAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesConfig model) {
            this.targetAttributeName(model.targetAttributeName);
            this.timestampAttributeName(model.timestampAttributeName);
            this.itemIdentifierAttributeName(model.itemIdentifierAttributeName);
            this.groupingAttributeNames(model.groupingAttributeNames);
        }

        public final String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final String getTimestampAttributeName() {
            return this.timestampAttributeName;
        }

        public final void setTimestampAttributeName(String timestampAttributeName) {
            this.timestampAttributeName = timestampAttributeName;
        }

        @Override
        public final Builder timestampAttributeName(String timestampAttributeName) {
            this.timestampAttributeName = timestampAttributeName;
            return this;
        }

        public final String getItemIdentifierAttributeName() {
            return this.itemIdentifierAttributeName;
        }

        public final void setItemIdentifierAttributeName(String itemIdentifierAttributeName) {
            this.itemIdentifierAttributeName = itemIdentifierAttributeName;
        }

        @Override
        public final Builder itemIdentifierAttributeName(String itemIdentifierAttributeName) {
            this.itemIdentifierAttributeName = itemIdentifierAttributeName;
            return this;
        }

        public final Collection<String> getGroupingAttributeNames() {
            if (this.groupingAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupingAttributeNames;
        }

        public final void setGroupingAttributeNames(Collection<String> groupingAttributeNames) {
            this.groupingAttributeNames = GroupingAttributeNamesCopier.copy(groupingAttributeNames);
        }

        @Override
        public final Builder groupingAttributeNames(Collection<String> groupingAttributeNames) {
            this.groupingAttributeNames = GroupingAttributeNamesCopier.copy(groupingAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeNames(String ... groupingAttributeNames) {
            this.groupingAttributeNames(Arrays.asList(groupingAttributeNames));
            return this;
        }

        public TimeSeriesConfig build() {
            return new TimeSeriesConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesConfig> {
        public Builder targetAttributeName(String var1);

        public Builder timestampAttributeName(String var1);

        public Builder itemIdentifierAttributeName(String var1);

        public Builder groupingAttributeNames(Collection<String> var1);

        public Builder groupingAttributeNames(String ... var1);
    }
}

