/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RetentionPolicy;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDomainRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DeleteDomainRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DeleteDomainRequest.getter(DeleteDomainRequest::domainId)).setter(DeleteDomainRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<RetentionPolicy> RETENTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionPolicy").getter(DeleteDomainRequest.getter(DeleteDomainRequest::retentionPolicy)).setter(DeleteDomainRequest.setter(Builder::retentionPolicy)).constructor(RetentionPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, RETENTION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDomainRequest.memberNameToFieldInitializer();
    private final String domainId;
    private final RetentionPolicy retentionPolicy;

    private DeleteDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.retentionPolicy = builder.retentionPolicy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDomainRequest)) {
            return false;
        }
        DeleteDomainRequest other = (DeleteDomainRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.retentionPolicy(), other.retentionPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDomainRequest").add("DomainId", (Object)this.domainId()).add("RetentionPolicy", (Object)this.retentionPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "RetentionPolicy": {
                return Optional.ofNullable(clazz.cast(this.retentionPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("RetentionPolicy", RETENTION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDomainRequest, T> g) {
        return obj -> g.apply((DeleteDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private RetentionPolicy retentionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDomainRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.retentionPolicy(model.retentionPolicy);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final RetentionPolicy.Builder getRetentionPolicy() {
            return this.retentionPolicy != null ? this.retentionPolicy.toBuilder() : null;
        }

        public final void setRetentionPolicy(RetentionPolicy.BuilderImpl retentionPolicy) {
            this.retentionPolicy = retentionPolicy != null ? retentionPolicy.build() : null;
        }

        @Override
        public final Builder retentionPolicy(RetentionPolicy retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDomainRequest build() {
            return new DeleteDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDomainRequest> {
        public Builder domainId(String var1);

        public Builder retentionPolicy(RetentionPolicy var1);

        default public Builder retentionPolicy(Consumer<RetentionPolicy.Builder> retentionPolicy) {
            return this.retentionPolicy((RetentionPolicy)((RetentionPolicy.Builder)RetentionPolicy.builder().applyMutation(retentionPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

