/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AdditionalModelDataSource;
import software.amazon.awssdk.services.sagemaker.model.AdditionalModelDataSourcesCopier;
import software.amazon.awssdk.services.sagemaker.model.ContainerMode;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.ImageConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelDataSource;
import software.amazon.awssdk.services.sagemaker.model.MultiModelConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDefinition> {
    private static final SdkField<String> CONTAINER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerHostname").getter(ContainerDefinition.getter(ContainerDefinition::containerHostname)).setter(ContainerDefinition.setter(Builder::containerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerHostname").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(ContainerDefinition.getter(ContainerDefinition::image)).setter(ContainerDefinition.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfig").getter(ContainerDefinition.getter(ContainerDefinition::imageConfig)).setter(ContainerDefinition.setter(Builder::imageConfig)).constructor(ImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ContainerDefinition.getter(ContainerDefinition::modeAsString)).setter(ContainerDefinition.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelDataUrl").getter(ContainerDefinition.getter(ContainerDefinition::modelDataUrl)).setter(ContainerDefinition.setter(Builder::modelDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDataSource").getter(ContainerDefinition.getter(ContainerDefinition::modelDataSource)).setter(ContainerDefinition.setter(Builder::modelDataSource)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataSource").build()}).build();
    private static final SdkField<List<AdditionalModelDataSource>> ADDITIONAL_MODEL_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalModelDataSources").getter(ContainerDefinition.getter(ContainerDefinition::additionalModelDataSources)).setter(ContainerDefinition.setter(Builder::additionalModelDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalModelDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(ContainerDefinition.getter(ContainerDefinition::environment)).setter(ContainerDefinition.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageName").getter(ContainerDefinition.getter(ContainerDefinition::modelPackageName)).setter(ContainerDefinition.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> INFERENCE_SPECIFICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSpecificationName").getter(ContainerDefinition.getter(ContainerDefinition::inferenceSpecificationName)).setter(ContainerDefinition.setter(Builder::inferenceSpecificationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecificationName").build()}).build();
    private static final SdkField<MultiModelConfig> MULTI_MODEL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiModelConfig").getter(ContainerDefinition.getter(ContainerDefinition::multiModelConfig)).setter(ContainerDefinition.setter(Builder::multiModelConfig)).constructor(MultiModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiModelConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_HOSTNAME_FIELD, IMAGE_FIELD, IMAGE_CONFIG_FIELD, MODE_FIELD, MODEL_DATA_URL_FIELD, MODEL_DATA_SOURCE_FIELD, ADDITIONAL_MODEL_DATA_SOURCES_FIELD, ENVIRONMENT_FIELD, MODEL_PACKAGE_NAME_FIELD, INFERENCE_SPECIFICATION_NAME_FIELD, MULTI_MODEL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerHostname;
    private final String image;
    private final ImageConfig imageConfig;
    private final String mode;
    private final String modelDataUrl;
    private final ModelDataSource modelDataSource;
    private final List<AdditionalModelDataSource> additionalModelDataSources;
    private final Map<String, String> environment;
    private final String modelPackageName;
    private final String inferenceSpecificationName;
    private final MultiModelConfig multiModelConfig;

    private ContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.imageConfig = builder.imageConfig;
        this.mode = builder.mode;
        this.modelDataUrl = builder.modelDataUrl;
        this.modelDataSource = builder.modelDataSource;
        this.additionalModelDataSources = builder.additionalModelDataSources;
        this.environment = builder.environment;
        this.modelPackageName = builder.modelPackageName;
        this.inferenceSpecificationName = builder.inferenceSpecificationName;
        this.multiModelConfig = builder.multiModelConfig;
    }

    public final String containerHostname() {
        return this.containerHostname;
    }

    public final String image() {
        return this.image;
    }

    public final ImageConfig imageConfig() {
        return this.imageConfig;
    }

    public final ContainerMode mode() {
        return ContainerMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String modelDataUrl() {
        return this.modelDataUrl;
    }

    public final ModelDataSource modelDataSource() {
        return this.modelDataSource;
    }

    public final boolean hasAdditionalModelDataSources() {
        return this.additionalModelDataSources != null && !(this.additionalModelDataSources instanceof SdkAutoConstructList);
    }

    public final List<AdditionalModelDataSource> additionalModelDataSources() {
        return this.additionalModelDataSources;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final String modelPackageName() {
        return this.modelPackageName;
    }

    public final String inferenceSpecificationName() {
        return this.inferenceSpecificationName;
    }

    public final MultiModelConfig multiModelConfig() {
        return this.multiModelConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelDataSources() ? this.additionalModelDataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecificationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiModelConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        return Objects.equals(this.containerHostname(), other.containerHostname()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.imageConfig(), other.imageConfig()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.modelDataSource(), other.modelDataSource()) && this.hasAdditionalModelDataSources() == other.hasAdditionalModelDataSources() && Objects.equals(this.additionalModelDataSources(), other.additionalModelDataSources()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.inferenceSpecificationName(), other.inferenceSpecificationName()) && Objects.equals(this.multiModelConfig(), other.multiModelConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDefinition").add("ContainerHostname", (Object)this.containerHostname()).add("Image", (Object)this.image()).add("ImageConfig", (Object)this.imageConfig()).add("Mode", (Object)this.modeAsString()).add("ModelDataUrl", (Object)this.modelDataUrl()).add("ModelDataSource", (Object)this.modelDataSource()).add("AdditionalModelDataSources", this.hasAdditionalModelDataSources() ? this.additionalModelDataSources() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("ModelPackageName", (Object)this.modelPackageName()).add("InferenceSpecificationName", (Object)this.inferenceSpecificationName()).add("MultiModelConfig", (Object)this.multiModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerHostname": {
                return Optional.ofNullable(clazz.cast(this.containerHostname()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ImageConfig": {
                return Optional.ofNullable(clazz.cast(this.imageConfig()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "ModelDataUrl": {
                return Optional.ofNullable(clazz.cast(this.modelDataUrl()));
            }
            case "ModelDataSource": {
                return Optional.ofNullable(clazz.cast(this.modelDataSource()));
            }
            case "AdditionalModelDataSources": {
                return Optional.ofNullable(clazz.cast(this.additionalModelDataSources()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "InferenceSpecificationName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecificationName()));
            }
            case "MultiModelConfig": {
                return Optional.ofNullable(clazz.cast(this.multiModelConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerHostname", CONTAINER_HOSTNAME_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("ImageConfig", IMAGE_CONFIG_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("ModelDataUrl", MODEL_DATA_URL_FIELD);
        map.put("ModelDataSource", MODEL_DATA_SOURCE_FIELD);
        map.put("AdditionalModelDataSources", ADDITIONAL_MODEL_DATA_SOURCES_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("ModelPackageName", MODEL_PACKAGE_NAME_FIELD);
        map.put("InferenceSpecificationName", INFERENCE_SPECIFICATION_NAME_FIELD);
        map.put("MultiModelConfig", MULTI_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerDefinition, T> g) {
        return obj -> g.apply((ContainerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerHostname;
        private String image;
        private ImageConfig imageConfig;
        private String mode;
        private String modelDataUrl;
        private ModelDataSource modelDataSource;
        private List<AdditionalModelDataSource> additionalModelDataSources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private String modelPackageName;
        private String inferenceSpecificationName;
        private MultiModelConfig multiModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinition model) {
            this.containerHostname(model.containerHostname);
            this.image(model.image);
            this.imageConfig(model.imageConfig);
            this.mode(model.mode);
            this.modelDataUrl(model.modelDataUrl);
            this.modelDataSource(model.modelDataSource);
            this.additionalModelDataSources(model.additionalModelDataSources);
            this.environment(model.environment);
            this.modelPackageName(model.modelPackageName);
            this.inferenceSpecificationName(model.inferenceSpecificationName);
            this.multiModelConfig(model.multiModelConfig);
        }

        public final String getContainerHostname() {
            return this.containerHostname;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final ImageConfig.Builder getImageConfig() {
            return this.imageConfig != null ? this.imageConfig.toBuilder() : null;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ContainerMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return this.modelDataSource != null ? this.modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final List<AdditionalModelDataSource.Builder> getAdditionalModelDataSources() {
            List<AdditionalModelDataSource.Builder> result = AdditionalModelDataSourcesCopier.copyToBuilder(this.additionalModelDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalModelDataSources(Collection<AdditionalModelDataSource.BuilderImpl> additionalModelDataSources) {
            this.additionalModelDataSources = AdditionalModelDataSourcesCopier.copyFromBuilder(additionalModelDataSources);
        }

        @Override
        public final Builder additionalModelDataSources(Collection<AdditionalModelDataSource> additionalModelDataSources) {
            this.additionalModelDataSources = AdditionalModelDataSourcesCopier.copy(additionalModelDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalModelDataSources(AdditionalModelDataSource ... additionalModelDataSources) {
            this.additionalModelDataSources(Arrays.asList(additionalModelDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalModelDataSources(Consumer<AdditionalModelDataSource.Builder> ... additionalModelDataSources) {
            this.additionalModelDataSources(Stream.of(additionalModelDataSources).map(c -> (AdditionalModelDataSource)((AdditionalModelDataSource.Builder)AdditionalModelDataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final String getInferenceSpecificationName() {
            return this.inferenceSpecificationName;
        }

        public final void setInferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
        }

        @Override
        public final Builder inferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
            return this;
        }

        public final MultiModelConfig.Builder getMultiModelConfig() {
            return this.multiModelConfig != null ? this.multiModelConfig.toBuilder() : null;
        }

        public final void setMultiModelConfig(MultiModelConfig.BuilderImpl multiModelConfig) {
            this.multiModelConfig = multiModelConfig != null ? multiModelConfig.build() : null;
        }

        @Override
        public final Builder multiModelConfig(MultiModelConfig multiModelConfig) {
            this.multiModelConfig = multiModelConfig;
            return this;
        }

        public ContainerDefinition build() {
            return new ContainerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDefinition> {
        public Builder containerHostname(String var1);

        public Builder image(String var1);

        public Builder imageConfig(ImageConfig var1);

        default public Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return this.imageConfig((ImageConfig)((ImageConfig.Builder)ImageConfig.builder().applyMutation(imageConfig)).build());
        }

        public Builder mode(String var1);

        public Builder mode(ContainerMode var1);

        public Builder modelDataUrl(String var1);

        public Builder modelDataSource(ModelDataSource var1);

        default public Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return this.modelDataSource((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelDataSource)).build());
        }

        public Builder additionalModelDataSources(Collection<AdditionalModelDataSource> var1);

        public Builder additionalModelDataSources(AdditionalModelDataSource ... var1);

        public Builder additionalModelDataSources(Consumer<AdditionalModelDataSource.Builder> ... var1);

        public Builder environment(Map<String, String> var1);

        public Builder modelPackageName(String var1);

        public Builder inferenceSpecificationName(String var1);

        public Builder multiModelConfig(MultiModelConfig var1);

        default public Builder multiModelConfig(Consumer<MultiModelConfig.Builder> multiModelConfig) {
            return this.multiModelConfig((MultiModelConfig)((MultiModelConfig.Builder)MultiModelConfig.builder().applyMutation(multiModelConfig)).build());
        }
    }
}

