/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerImageVersionAliasesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAliasesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListAliasesResponse> {
    private static final SdkField<List<String>> SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SageMakerImageVersionAliases").getter(ListAliasesResponse.getter(ListAliasesResponse::sageMakerImageVersionAliases)).setter(ListAliasesResponse.setter(Builder::sageMakerImageVersionAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageVersionAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAliasesResponse.getter(ListAliasesResponse::nextToken)).setter(ListAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAliasesResponse.memberNameToFieldInitializer();
    private final List<String> sageMakerImageVersionAliases;
    private final String nextToken;

    private ListAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.sageMakerImageVersionAliases = builder.sageMakerImageVersionAliases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSageMakerImageVersionAliases() {
        return this.sageMakerImageVersionAliases != null && !(this.sageMakerImageVersionAliases instanceof SdkAutoConstructList);
    }

    public final List<String> sageMakerImageVersionAliases() {
        return this.sageMakerImageVersionAliases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSageMakerImageVersionAliases() ? this.sageMakerImageVersionAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResponse)) {
            return false;
        }
        ListAliasesResponse other = (ListAliasesResponse)((Object)obj);
        return this.hasSageMakerImageVersionAliases() == other.hasSageMakerImageVersionAliases() && Objects.equals(this.sageMakerImageVersionAliases(), other.sageMakerImageVersionAliases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAliasesResponse").add("SageMakerImageVersionAliases", this.hasSageMakerImageVersionAliases() ? this.sageMakerImageVersionAliases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SageMakerImageVersionAliases": {
                return Optional.ofNullable(clazz.cast(this.sageMakerImageVersionAliases()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SageMakerImageVersionAliases", SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAliasesResponse, T> g) {
        return obj -> g.apply((ListAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<String> sageMakerImageVersionAliases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesResponse model) {
            super(model);
            this.sageMakerImageVersionAliases(model.sageMakerImageVersionAliases);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getSageMakerImageVersionAliases() {
            if (this.sageMakerImageVersionAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sageMakerImageVersionAliases;
        }

        public final void setSageMakerImageVersionAliases(Collection<String> sageMakerImageVersionAliases) {
            this.sageMakerImageVersionAliases = SageMakerImageVersionAliasesCopier.copy(sageMakerImageVersionAliases);
        }

        @Override
        public final Builder sageMakerImageVersionAliases(Collection<String> sageMakerImageVersionAliases) {
            this.sageMakerImageVersionAliases = SageMakerImageVersionAliasesCopier.copy(sageMakerImageVersionAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sageMakerImageVersionAliases(String ... sageMakerImageVersionAliases) {
            this.sageMakerImageVersionAliases(Arrays.asList(sageMakerImageVersionAliases));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAliasesResponse build() {
            return new ListAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAliasesResponse> {
        public Builder sageMakerImageVersionAliases(Collection<String> var1);

        public Builder sageMakerImageVersionAliases(String ... var1);

        public Builder nextToken(String var1);
    }
}

