/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MemberDefinition;
import software.amazon.awssdk.services.sagemaker.model.MemberDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.WorkerAccessConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkteamRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateWorkteamRequest> {
    private static final SdkField<String> WORKTEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamName").getter(UpdateWorkteamRequest.getter(UpdateWorkteamRequest::workteamName)).setter(UpdateWorkteamRequest.setter(Builder::workteamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamName").build()}).build();
    private static final SdkField<List<MemberDefinition>> MEMBER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberDefinitions").getter(UpdateWorkteamRequest.getter(UpdateWorkteamRequest::memberDefinitions)).setter(UpdateWorkteamRequest.setter(Builder::memberDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWorkteamRequest.getter(UpdateWorkteamRequest::description)).setter(UpdateWorkteamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(UpdateWorkteamRequest.getter(UpdateWorkteamRequest::notificationConfiguration)).setter(UpdateWorkteamRequest.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final SdkField<WorkerAccessConfiguration> WORKER_ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkerAccessConfiguration").getter(UpdateWorkteamRequest.getter(UpdateWorkteamRequest::workerAccessConfiguration)).setter(UpdateWorkteamRequest.setter(Builder::workerAccessConfiguration)).constructor(WorkerAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerAccessConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_NAME_FIELD, MEMBER_DEFINITIONS_FIELD, DESCRIPTION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, WORKER_ACCESS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkteamRequest.memberNameToFieldInitializer();
    private final String workteamName;
    private final List<MemberDefinition> memberDefinitions;
    private final String description;
    private final NotificationConfiguration notificationConfiguration;
    private final WorkerAccessConfiguration workerAccessConfiguration;

    private UpdateWorkteamRequest(BuilderImpl builder) {
        super(builder);
        this.workteamName = builder.workteamName;
        this.memberDefinitions = builder.memberDefinitions;
        this.description = builder.description;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.workerAccessConfiguration = builder.workerAccessConfiguration;
    }

    public final String workteamName() {
        return this.workteamName;
    }

    public final boolean hasMemberDefinitions() {
        return this.memberDefinitions != null && !(this.memberDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MemberDefinition> memberDefinitions() {
        return this.memberDefinitions;
    }

    public final String description() {
        return this.description;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final WorkerAccessConfiguration workerAccessConfiguration() {
        return this.workerAccessConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberDefinitions() ? this.memberDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerAccessConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkteamRequest)) {
            return false;
        }
        UpdateWorkteamRequest other = (UpdateWorkteamRequest)((Object)obj);
        return Objects.equals(this.workteamName(), other.workteamName()) && this.hasMemberDefinitions() == other.hasMemberDefinitions() && Objects.equals(this.memberDefinitions(), other.memberDefinitions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && Objects.equals(this.workerAccessConfiguration(), other.workerAccessConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkteamRequest").add("WorkteamName", (Object)this.workteamName()).add("MemberDefinitions", this.hasMemberDefinitions() ? this.memberDefinitions() : null).add("Description", (Object)this.description()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("WorkerAccessConfiguration", (Object)this.workerAccessConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkteamName": {
                return Optional.ofNullable(clazz.cast(this.workteamName()));
            }
            case "MemberDefinitions": {
                return Optional.ofNullable(clazz.cast(this.memberDefinitions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "WorkerAccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workerAccessConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkteamName", WORKTEAM_NAME_FIELD);
        map.put("MemberDefinitions", MEMBER_DEFINITIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("WorkerAccessConfiguration", WORKER_ACCESS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkteamRequest, T> g) {
        return obj -> g.apply((UpdateWorkteamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String workteamName;
        private List<MemberDefinition> memberDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private NotificationConfiguration notificationConfiguration;
        private WorkerAccessConfiguration workerAccessConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkteamRequest model) {
            super(model);
            this.workteamName(model.workteamName);
            this.memberDefinitions(model.memberDefinitions);
            this.description(model.description);
            this.notificationConfiguration(model.notificationConfiguration);
            this.workerAccessConfiguration(model.workerAccessConfiguration);
        }

        public final String getWorkteamName() {
            return this.workteamName;
        }

        public final void setWorkteamName(String workteamName) {
            this.workteamName = workteamName;
        }

        @Override
        public final Builder workteamName(String workteamName) {
            this.workteamName = workteamName;
            return this;
        }

        public final List<MemberDefinition.Builder> getMemberDefinitions() {
            List<MemberDefinition.Builder> result = MemberDefinitionsCopier.copyToBuilder(this.memberDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDefinitions(Collection<MemberDefinition.BuilderImpl> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copyFromBuilder(memberDefinitions);
        }

        @Override
        public final Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copy(memberDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(MemberDefinition ... memberDefinitions) {
            this.memberDefinitions(Arrays.asList(memberDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(Consumer<MemberDefinition.Builder> ... memberDefinitions) {
            this.memberDefinitions(Stream.of(memberDefinitions).map(c -> (MemberDefinition)((MemberDefinition.Builder)MemberDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final WorkerAccessConfiguration.Builder getWorkerAccessConfiguration() {
            return this.workerAccessConfiguration != null ? this.workerAccessConfiguration.toBuilder() : null;
        }

        public final void setWorkerAccessConfiguration(WorkerAccessConfiguration.BuilderImpl workerAccessConfiguration) {
            this.workerAccessConfiguration = workerAccessConfiguration != null ? workerAccessConfiguration.build() : null;
        }

        @Override
        public final Builder workerAccessConfiguration(WorkerAccessConfiguration workerAccessConfiguration) {
            this.workerAccessConfiguration = workerAccessConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkteamRequest build() {
            return new UpdateWorkteamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkteamRequest> {
        public Builder workteamName(String var1);

        public Builder memberDefinitions(Collection<MemberDefinition> var1);

        public Builder memberDefinitions(MemberDefinition ... var1);

        public Builder memberDefinitions(Consumer<MemberDefinition.Builder> ... var1);

        public Builder description(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder workerAccessConfiguration(WorkerAccessConfiguration var1);

        default public Builder workerAccessConfiguration(Consumer<WorkerAccessConfiguration.Builder> workerAccessConfiguration) {
            return this.workerAccessConfiguration((WorkerAccessConfiguration)((WorkerAccessConfiguration.Builder)WorkerAccessConfiguration.builder().applyMutation(workerAccessConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

