/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentRuntimeConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceComponentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateInferenceComponentRequest> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentName").getter(CreateInferenceComponentRequest.getter(CreateInferenceComponentRequest::inferenceComponentName)).setter(CreateInferenceComponentRequest.setter(Builder::inferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(CreateInferenceComponentRequest.getter(CreateInferenceComponentRequest::endpointName)).setter(CreateInferenceComponentRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(CreateInferenceComponentRequest.getter(CreateInferenceComponentRequest::variantName)).setter(CreateInferenceComponentRequest.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<InferenceComponentSpecification> SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Specification").getter(CreateInferenceComponentRequest.getter(CreateInferenceComponentRequest::specification)).setter(CreateInferenceComponentRequest.setter(Builder::specification)).constructor(InferenceComponentSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specification").build()}).build();
    private static final SdkField<InferenceComponentRuntimeConfig> RUNTIME_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeConfig").getter(CreateInferenceComponentRequest.getter(CreateInferenceComponentRequest::runtimeConfig)).setter(CreateInferenceComponentRequest.setter(Builder::runtimeConfig)).constructor(InferenceComponentRuntimeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateInferenceComponentRequest.getter(CreateInferenceComponentRequest::tags)).setter(CreateInferenceComponentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_COMPONENT_NAME_FIELD, ENDPOINT_NAME_FIELD, VARIANT_NAME_FIELD, SPECIFICATION_FIELD, RUNTIME_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInferenceComponentRequest.memberNameToFieldInitializer();
    private final String inferenceComponentName;
    private final String endpointName;
    private final String variantName;
    private final InferenceComponentSpecification specification;
    private final InferenceComponentRuntimeConfig runtimeConfig;
    private final List<Tag> tags;

    private CreateInferenceComponentRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.endpointName = builder.endpointName;
        this.variantName = builder.variantName;
        this.specification = builder.specification;
        this.runtimeConfig = builder.runtimeConfig;
        this.tags = builder.tags;
    }

    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final InferenceComponentSpecification specification() {
        return this.specification;
    }

    public final InferenceComponentRuntimeConfig runtimeConfig() {
        return this.runtimeConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.specification());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceComponentRequest)) {
            return false;
        }
        CreateInferenceComponentRequest other = (CreateInferenceComponentRequest)((Object)obj);
        return Objects.equals(this.inferenceComponentName(), other.inferenceComponentName()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.specification(), other.specification()) && Objects.equals(this.runtimeConfig(), other.runtimeConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceComponentRequest").add("InferenceComponentName", (Object)this.inferenceComponentName()).add("EndpointName", (Object)this.endpointName()).add("VariantName", (Object)this.variantName()).add("Specification", (Object)this.specification()).add("RuntimeConfig", (Object)this.runtimeConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentName()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "Specification": {
                return Optional.ofNullable(clazz.cast(this.specification()));
            }
            case "RuntimeConfig": {
                return Optional.ofNullable(clazz.cast(this.runtimeConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("Specification", SPECIFICATION_FIELD);
        map.put("RuntimeConfig", RUNTIME_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceComponentRequest, T> g) {
        return obj -> g.apply((CreateInferenceComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String inferenceComponentName;
        private String endpointName;
        private String variantName;
        private InferenceComponentSpecification specification;
        private InferenceComponentRuntimeConfig runtimeConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceComponentRequest model) {
            super(model);
            this.inferenceComponentName(model.inferenceComponentName);
            this.endpointName(model.endpointName);
            this.variantName(model.variantName);
            this.specification(model.specification);
            this.runtimeConfig(model.runtimeConfig);
            this.tags(model.tags);
        }

        public final String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final InferenceComponentSpecification.Builder getSpecification() {
            return this.specification != null ? this.specification.toBuilder() : null;
        }

        public final void setSpecification(InferenceComponentSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(InferenceComponentSpecification specification) {
            this.specification = specification;
            return this;
        }

        public final InferenceComponentRuntimeConfig.Builder getRuntimeConfig() {
            return this.runtimeConfig != null ? this.runtimeConfig.toBuilder() : null;
        }

        public final void setRuntimeConfig(InferenceComponentRuntimeConfig.BuilderImpl runtimeConfig) {
            this.runtimeConfig = runtimeConfig != null ? runtimeConfig.build() : null;
        }

        @Override
        public final Builder runtimeConfig(InferenceComponentRuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceComponentRequest build() {
            return new CreateInferenceComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceComponentRequest> {
        public Builder inferenceComponentName(String var1);

        public Builder endpointName(String var1);

        public Builder variantName(String var1);

        public Builder specification(InferenceComponentSpecification var1);

        default public Builder specification(Consumer<InferenceComponentSpecification.Builder> specification) {
            return this.specification((InferenceComponentSpecification)((InferenceComponentSpecification.Builder)InferenceComponentSpecification.builder().applyMutation(specification)).build());
        }

        public Builder runtimeConfig(InferenceComponentRuntimeConfig var1);

        default public Builder runtimeConfig(Consumer<InferenceComponentRuntimeConfig.Builder> runtimeConfig) {
            return this.runtimeConfig((InferenceComponentRuntimeConfig)((InferenceComponentRuntimeConfig.Builder)InferenceComponentRuntimeConfig.builder().applyMutation(runtimeConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

