/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelCardVersionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelCardVersionsResponse> {
    private static final SdkField<List<ModelCardVersionSummary>> MODEL_CARD_VERSION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelCardVersionSummaryList").getter(ListModelCardVersionsResponse.getter(ListModelCardVersionsResponse::modelCardVersionSummaryList)).setter(ListModelCardVersionsResponse.setter(Builder::modelCardVersionSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersionSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelCardVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelCardVersionsResponse.getter(ListModelCardVersionsResponse::nextToken)).setter(ListModelCardVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_VERSION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelCardVersionsResponse.memberNameToFieldInitializer();
    private final List<ModelCardVersionSummary> modelCardVersionSummaryList;
    private final String nextToken;

    private ListModelCardVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardVersionSummaryList = builder.modelCardVersionSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelCardVersionSummaryList() {
        return this.modelCardVersionSummaryList != null && !(this.modelCardVersionSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ModelCardVersionSummary> modelCardVersionSummaryList() {
        return this.modelCardVersionSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelCardVersionSummaryList() ? this.modelCardVersionSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardVersionsResponse)) {
            return false;
        }
        ListModelCardVersionsResponse other = (ListModelCardVersionsResponse)((Object)obj);
        return this.hasModelCardVersionSummaryList() == other.hasModelCardVersionSummaryList() && Objects.equals(this.modelCardVersionSummaryList(), other.modelCardVersionSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelCardVersionsResponse").add("ModelCardVersionSummaryList", this.hasModelCardVersionSummaryList() ? this.modelCardVersionSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardVersionSummaryList": {
                return Optional.ofNullable(clazz.cast(this.modelCardVersionSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelCardVersionSummaryList", MODEL_CARD_VERSION_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardVersionsResponse, T> g) {
        return obj -> g.apply((ListModelCardVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelCardVersionSummary> modelCardVersionSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardVersionsResponse model) {
            super(model);
            this.modelCardVersionSummaryList(model.modelCardVersionSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ModelCardVersionSummary.Builder> getModelCardVersionSummaryList() {
            List<ModelCardVersionSummary.Builder> result = ModelCardVersionSummaryListCopier.copyToBuilder(this.modelCardVersionSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCardVersionSummaryList(Collection<ModelCardVersionSummary.BuilderImpl> modelCardVersionSummaryList) {
            this.modelCardVersionSummaryList = ModelCardVersionSummaryListCopier.copyFromBuilder(modelCardVersionSummaryList);
        }

        @Override
        public final Builder modelCardVersionSummaryList(Collection<ModelCardVersionSummary> modelCardVersionSummaryList) {
            this.modelCardVersionSummaryList = ModelCardVersionSummaryListCopier.copy(modelCardVersionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardVersionSummaryList(ModelCardVersionSummary ... modelCardVersionSummaryList) {
            this.modelCardVersionSummaryList(Arrays.asList(modelCardVersionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardVersionSummaryList(Consumer<ModelCardVersionSummary.Builder> ... modelCardVersionSummaryList) {
            this.modelCardVersionSummaryList(Stream.of(modelCardVersionSummaryList).map(c -> (ModelCardVersionSummary)((ModelCardVersionSummary.Builder)ModelCardVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelCardVersionsResponse build() {
            return new ListModelCardVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelCardVersionsResponse> {
        public Builder modelCardVersionSummaryList(Collection<ModelCardVersionSummary> var1);

        public Builder modelCardVersionSummaryList(ModelCardVersionSummary ... var1);

        public Builder modelCardVersionSummaryList(Consumer<ModelCardVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

