/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeModelStat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeModelStat> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(EdgeModelStat.getter(EdgeModelStat::modelName)).setter(EdgeModelStat.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(EdgeModelStat.getter(EdgeModelStat::modelVersion)).setter(EdgeModelStat.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<Long> OFFLINE_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OfflineDeviceCount").getter(EdgeModelStat.getter(EdgeModelStat::offlineDeviceCount)).setter(EdgeModelStat.setter(Builder::offlineDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineDeviceCount").build()}).build();
    private static final SdkField<Long> CONNECTED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ConnectedDeviceCount").getter(EdgeModelStat.getter(EdgeModelStat::connectedDeviceCount)).setter(EdgeModelStat.setter(Builder::connectedDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDeviceCount").build()}).build();
    private static final SdkField<Long> ACTIVE_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ActiveDeviceCount").getter(EdgeModelStat.getter(EdgeModelStat::activeDeviceCount)).setter(EdgeModelStat.setter(Builder::activeDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDeviceCount").build()}).build();
    private static final SdkField<Long> SAMPLING_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SamplingDeviceCount").getter(EdgeModelStat.getter(EdgeModelStat::samplingDeviceCount)).setter(EdgeModelStat.setter(Builder::samplingDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingDeviceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_VERSION_FIELD, OFFLINE_DEVICE_COUNT_FIELD, CONNECTED_DEVICE_COUNT_FIELD, ACTIVE_DEVICE_COUNT_FIELD, SAMPLING_DEVICE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EdgeModelStat.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelVersion;
    private final Long offlineDeviceCount;
    private final Long connectedDeviceCount;
    private final Long activeDeviceCount;
    private final Long samplingDeviceCount;

    private EdgeModelStat(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.offlineDeviceCount = builder.offlineDeviceCount;
        this.connectedDeviceCount = builder.connectedDeviceCount;
        this.activeDeviceCount = builder.activeDeviceCount;
        this.samplingDeviceCount = builder.samplingDeviceCount;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final Long offlineDeviceCount() {
        return this.offlineDeviceCount;
    }

    public final Long connectedDeviceCount() {
        return this.connectedDeviceCount;
    }

    public final Long activeDeviceCount() {
        return this.activeDeviceCount;
    }

    public final Long samplingDeviceCount() {
        return this.samplingDeviceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingDeviceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeModelStat)) {
            return false;
        }
        EdgeModelStat other = (EdgeModelStat)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.offlineDeviceCount(), other.offlineDeviceCount()) && Objects.equals(this.connectedDeviceCount(), other.connectedDeviceCount()) && Objects.equals(this.activeDeviceCount(), other.activeDeviceCount()) && Objects.equals(this.samplingDeviceCount(), other.samplingDeviceCount());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeModelStat").add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("OfflineDeviceCount", (Object)this.offlineDeviceCount()).add("ConnectedDeviceCount", (Object)this.connectedDeviceCount()).add("ActiveDeviceCount", (Object)this.activeDeviceCount()).add("SamplingDeviceCount", (Object)this.samplingDeviceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "OfflineDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.offlineDeviceCount()));
            }
            case "ConnectedDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.connectedDeviceCount()));
            }
            case "ActiveDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.activeDeviceCount()));
            }
            case "SamplingDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.samplingDeviceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        map.put("OfflineDeviceCount", OFFLINE_DEVICE_COUNT_FIELD);
        map.put("ConnectedDeviceCount", CONNECTED_DEVICE_COUNT_FIELD);
        map.put("ActiveDeviceCount", ACTIVE_DEVICE_COUNT_FIELD);
        map.put("SamplingDeviceCount", SAMPLING_DEVICE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeModelStat, T> g) {
        return obj -> g.apply((EdgeModelStat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelVersion;
        private Long offlineDeviceCount;
        private Long connectedDeviceCount;
        private Long activeDeviceCount;
        private Long samplingDeviceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeModelStat model) {
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.offlineDeviceCount(model.offlineDeviceCount);
            this.connectedDeviceCount(model.connectedDeviceCount);
            this.activeDeviceCount(model.activeDeviceCount);
            this.samplingDeviceCount(model.samplingDeviceCount);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Long getOfflineDeviceCount() {
            return this.offlineDeviceCount;
        }

        public final void setOfflineDeviceCount(Long offlineDeviceCount) {
            this.offlineDeviceCount = offlineDeviceCount;
        }

        @Override
        public final Builder offlineDeviceCount(Long offlineDeviceCount) {
            this.offlineDeviceCount = offlineDeviceCount;
            return this;
        }

        public final Long getConnectedDeviceCount() {
            return this.connectedDeviceCount;
        }

        public final void setConnectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
        }

        @Override
        public final Builder connectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
            return this;
        }

        public final Long getActiveDeviceCount() {
            return this.activeDeviceCount;
        }

        public final void setActiveDeviceCount(Long activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
        }

        @Override
        public final Builder activeDeviceCount(Long activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
            return this;
        }

        public final Long getSamplingDeviceCount() {
            return this.samplingDeviceCount;
        }

        public final void setSamplingDeviceCount(Long samplingDeviceCount) {
            this.samplingDeviceCount = samplingDeviceCount;
        }

        @Override
        public final Builder samplingDeviceCount(Long samplingDeviceCount) {
            this.samplingDeviceCount = samplingDeviceCount;
            return this;
        }

        public EdgeModelStat build() {
            return new EdgeModelStat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeModelStat> {
        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder offlineDeviceCount(Long var1);

        public Builder connectedDeviceCount(Long var1);

        public Builder activeDeviceCount(Long var1);

        public Builder samplingDeviceCount(Long var1);
    }
}

