/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceHubAccessConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelAccessConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelCompressionType;
import software.amazon.awssdk.services.sagemaker.model.S3ModelDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ModelDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ModelDataSource> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(S3ModelDataSource.getter(S3ModelDataSource::s3Uri)).setter(S3ModelDataSource.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataType").getter(S3ModelDataSource.getter(S3ModelDataSource::s3DataTypeAsString)).setter(S3ModelDataSource.setter(Builder::s3DataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(S3ModelDataSource.getter(S3ModelDataSource::compressionTypeAsString)).setter(S3ModelDataSource.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<ModelAccessConfig> MODEL_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelAccessConfig").getter(S3ModelDataSource.getter(S3ModelDataSource::modelAccessConfig)).setter(S3ModelDataSource.setter(Builder::modelAccessConfig)).constructor(ModelAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelAccessConfig").build()}).build();
    private static final SdkField<InferenceHubAccessConfig> HUB_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HubAccessConfig").getter(S3ModelDataSource.getter(S3ModelDataSource::hubAccessConfig)).setter(S3ModelDataSource.setter(Builder::hubAccessConfig)).constructor(InferenceHubAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubAccessConfig").build()}).build();
    private static final SdkField<String> MANIFEST_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestS3Uri").getter(S3ModelDataSource.getter(S3ModelDataSource::manifestS3Uri)).setter(S3ModelDataSource.setter(Builder::manifestS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestS3Uri").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(S3ModelDataSource.getter(S3ModelDataSource::eTag)).setter(S3ModelDataSource.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<String> MANIFEST_ETAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestEtag").getter(S3ModelDataSource.getter(S3ModelDataSource::manifestEtag)).setter(S3ModelDataSource.setter(Builder::manifestEtag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestEtag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, S3_DATA_TYPE_FIELD, COMPRESSION_TYPE_FIELD, MODEL_ACCESS_CONFIG_FIELD, HUB_ACCESS_CONFIG_FIELD, MANIFEST_S3_URI_FIELD, E_TAG_FIELD, MANIFEST_ETAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ModelDataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String s3DataType;
    private final String compressionType;
    private final ModelAccessConfig modelAccessConfig;
    private final InferenceHubAccessConfig hubAccessConfig;
    private final String manifestS3Uri;
    private final String eTag;
    private final String manifestEtag;

    private S3ModelDataSource(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.s3DataType = builder.s3DataType;
        this.compressionType = builder.compressionType;
        this.modelAccessConfig = builder.modelAccessConfig;
        this.hubAccessConfig = builder.hubAccessConfig;
        this.manifestS3Uri = builder.manifestS3Uri;
        this.eTag = builder.eTag;
        this.manifestEtag = builder.manifestEtag;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final S3ModelDataType s3DataType() {
        return S3ModelDataType.fromValue(this.s3DataType);
    }

    public final String s3DataTypeAsString() {
        return this.s3DataType;
    }

    public final ModelCompressionType compressionType() {
        return ModelCompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public final ModelAccessConfig modelAccessConfig() {
        return this.modelAccessConfig;
    }

    public final InferenceHubAccessConfig hubAccessConfig() {
        return this.hubAccessConfig;
    }

    public final String manifestS3Uri() {
        return this.manifestS3Uri;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String manifestEtag() {
        return this.manifestEtag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelAccessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubAccessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestEtag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ModelDataSource)) {
            return false;
        }
        S3ModelDataSource other = (S3ModelDataSource)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.modelAccessConfig(), other.modelAccessConfig()) && Objects.equals(this.hubAccessConfig(), other.hubAccessConfig()) && Objects.equals(this.manifestS3Uri(), other.manifestS3Uri()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.manifestEtag(), other.manifestEtag());
    }

    public final String toString() {
        return ToString.builder((String)"S3ModelDataSource").add("S3Uri", (Object)this.s3Uri()).add("S3DataType", (Object)this.s3DataTypeAsString()).add("CompressionType", (Object)this.compressionTypeAsString()).add("ModelAccessConfig", (Object)this.modelAccessConfig()).add("HubAccessConfig", (Object)this.hubAccessConfig()).add("ManifestS3Uri", (Object)this.manifestS3Uri()).add("ETag", (Object)this.eTag()).add("ManifestEtag", (Object)this.manifestEtag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "S3DataType": {
                return Optional.ofNullable(clazz.cast(this.s3DataTypeAsString()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "ModelAccessConfig": {
                return Optional.ofNullable(clazz.cast(this.modelAccessConfig()));
            }
            case "HubAccessConfig": {
                return Optional.ofNullable(clazz.cast(this.hubAccessConfig()));
            }
            case "ManifestS3Uri": {
                return Optional.ofNullable(clazz.cast(this.manifestS3Uri()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "ManifestEtag": {
                return Optional.ofNullable(clazz.cast(this.manifestEtag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3Uri", S3_URI_FIELD);
        map.put("S3DataType", S3_DATA_TYPE_FIELD);
        map.put("CompressionType", COMPRESSION_TYPE_FIELD);
        map.put("ModelAccessConfig", MODEL_ACCESS_CONFIG_FIELD);
        map.put("HubAccessConfig", HUB_ACCESS_CONFIG_FIELD);
        map.put("ManifestS3Uri", MANIFEST_S3_URI_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("ManifestEtag", MANIFEST_ETAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ModelDataSource, T> g) {
        return obj -> g.apply((S3ModelDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String s3DataType;
        private String compressionType;
        private ModelAccessConfig modelAccessConfig;
        private InferenceHubAccessConfig hubAccessConfig;
        private String manifestS3Uri;
        private String eTag;
        private String manifestEtag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ModelDataSource model) {
            this.s3Uri(model.s3Uri);
            this.s3DataType(model.s3DataType);
            this.compressionType(model.compressionType);
            this.modelAccessConfig(model.modelAccessConfig);
            this.hubAccessConfig(model.hubAccessConfig);
            this.manifestS3Uri(model.manifestS3Uri);
            this.eTag(model.eTag);
            this.manifestEtag(model.manifestEtag);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3DataType() {
            return this.s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(S3ModelDataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(ModelCompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final ModelAccessConfig.Builder getModelAccessConfig() {
            return this.modelAccessConfig != null ? this.modelAccessConfig.toBuilder() : null;
        }

        public final void setModelAccessConfig(ModelAccessConfig.BuilderImpl modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig != null ? modelAccessConfig.build() : null;
        }

        @Override
        public final Builder modelAccessConfig(ModelAccessConfig modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig;
            return this;
        }

        public final InferenceHubAccessConfig.Builder getHubAccessConfig() {
            return this.hubAccessConfig != null ? this.hubAccessConfig.toBuilder() : null;
        }

        public final void setHubAccessConfig(InferenceHubAccessConfig.BuilderImpl hubAccessConfig) {
            this.hubAccessConfig = hubAccessConfig != null ? hubAccessConfig.build() : null;
        }

        @Override
        public final Builder hubAccessConfig(InferenceHubAccessConfig hubAccessConfig) {
            this.hubAccessConfig = hubAccessConfig;
            return this;
        }

        public final String getManifestS3Uri() {
            return this.manifestS3Uri;
        }

        public final void setManifestS3Uri(String manifestS3Uri) {
            this.manifestS3Uri = manifestS3Uri;
        }

        @Override
        public final Builder manifestS3Uri(String manifestS3Uri) {
            this.manifestS3Uri = manifestS3Uri;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getManifestEtag() {
            return this.manifestEtag;
        }

        public final void setManifestEtag(String manifestEtag) {
            this.manifestEtag = manifestEtag;
        }

        @Override
        public final Builder manifestEtag(String manifestEtag) {
            this.manifestEtag = manifestEtag;
            return this;
        }

        public S3ModelDataSource build() {
            return new S3ModelDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ModelDataSource> {
        public Builder s3Uri(String var1);

        public Builder s3DataType(String var1);

        public Builder s3DataType(S3ModelDataType var1);

        public Builder compressionType(String var1);

        public Builder compressionType(ModelCompressionType var1);

        public Builder modelAccessConfig(ModelAccessConfig var1);

        default public Builder modelAccessConfig(Consumer<ModelAccessConfig.Builder> modelAccessConfig) {
            return this.modelAccessConfig((ModelAccessConfig)((ModelAccessConfig.Builder)ModelAccessConfig.builder().applyMutation(modelAccessConfig)).build());
        }

        public Builder hubAccessConfig(InferenceHubAccessConfig var1);

        default public Builder hubAccessConfig(Consumer<InferenceHubAccessConfig.Builder> hubAccessConfig) {
            return this.hubAccessConfig((InferenceHubAccessConfig)((InferenceHubAccessConfig.Builder)InferenceHubAccessConfig.builder().applyMutation(hubAccessConfig)).build());
        }

        public Builder manifestS3Uri(String var1);

        public Builder eTag(String var1);

        public Builder manifestEtag(String var1);
    }
}

