/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ResourceCatalog;
import software.amazon.awssdk.services.sagemaker.model.ResourceCatalogListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceCatalogsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListResourceCatalogsResponse> {
    private static final SdkField<List<ResourceCatalog>> RESOURCE_CATALOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceCatalogs").getter(ListResourceCatalogsResponse.getter(ListResourceCatalogsResponse::resourceCatalogs)).setter(ListResourceCatalogsResponse.setter(Builder::resourceCatalogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCatalogs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceCatalog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceCatalogsResponse.getter(ListResourceCatalogsResponse::nextToken)).setter(ListResourceCatalogsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_CATALOGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceCatalogsResponse.memberNameToFieldInitializer();
    private final List<ResourceCatalog> resourceCatalogs;
    private final String nextToken;

    private ListResourceCatalogsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceCatalogs = builder.resourceCatalogs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceCatalogs() {
        return this.resourceCatalogs != null && !(this.resourceCatalogs instanceof SdkAutoConstructList);
    }

    public final List<ResourceCatalog> resourceCatalogs() {
        return this.resourceCatalogs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceCatalogs() ? this.resourceCatalogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceCatalogsResponse)) {
            return false;
        }
        ListResourceCatalogsResponse other = (ListResourceCatalogsResponse)((Object)obj);
        return this.hasResourceCatalogs() == other.hasResourceCatalogs() && Objects.equals(this.resourceCatalogs(), other.resourceCatalogs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceCatalogsResponse").add("ResourceCatalogs", this.hasResourceCatalogs() ? this.resourceCatalogs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceCatalogs": {
                return Optional.ofNullable(clazz.cast(this.resourceCatalogs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceCatalogs", RESOURCE_CATALOGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceCatalogsResponse, T> g) {
        return obj -> g.apply((ListResourceCatalogsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ResourceCatalog> resourceCatalogs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceCatalogsResponse model) {
            super(model);
            this.resourceCatalogs(model.resourceCatalogs);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceCatalog.Builder> getResourceCatalogs() {
            List<ResourceCatalog.Builder> result = ResourceCatalogListCopier.copyToBuilder(this.resourceCatalogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceCatalogs(Collection<ResourceCatalog.BuilderImpl> resourceCatalogs) {
            this.resourceCatalogs = ResourceCatalogListCopier.copyFromBuilder(resourceCatalogs);
        }

        @Override
        public final Builder resourceCatalogs(Collection<ResourceCatalog> resourceCatalogs) {
            this.resourceCatalogs = ResourceCatalogListCopier.copy(resourceCatalogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCatalogs(ResourceCatalog ... resourceCatalogs) {
            this.resourceCatalogs(Arrays.asList(resourceCatalogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCatalogs(Consumer<ResourceCatalog.Builder> ... resourceCatalogs) {
            this.resourceCatalogs(Stream.of(resourceCatalogs).map(c -> (ResourceCatalog)((ResourceCatalog.Builder)ResourceCatalog.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceCatalogsResponse build() {
            return new ListResourceCatalogsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceCatalogsResponse> {
        public Builder resourceCatalogs(Collection<ResourceCatalog> var1);

        public Builder resourceCatalogs(ResourceCatalog ... var1);

        public Builder resourceCatalogs(Consumer<ResourceCatalog.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

