/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ContextSource;
import software.amazon.awssdk.services.sagemaker.model.LineageEntityParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContextResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeContextResponse> {
    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextName").getter(DescribeContextResponse.getter(DescribeContextResponse::contextName)).setter(DescribeContextResponse.setter(Builder::contextName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()}).build();
    private static final SdkField<String> CONTEXT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextArn").getter(DescribeContextResponse.getter(DescribeContextResponse::contextArn)).setter(DescribeContextResponse.setter(Builder::contextArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextArn").build()}).build();
    private static final SdkField<ContextSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(DescribeContextResponse.getter(DescribeContextResponse::source)).setter(DescribeContextResponse.setter(Builder::source)).constructor(ContextSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> CONTEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextType").getter(DescribeContextResponse.getter(DescribeContextResponse::contextType)).setter(DescribeContextResponse.setter(Builder::contextType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeContextResponse.getter(DescribeContextResponse::description)).setter(DescribeContextResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(DescribeContextResponse.getter(DescribeContextResponse::properties)).setter(DescribeContextResponse.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeContextResponse.getter(DescribeContextResponse::creationTime)).setter(DescribeContextResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeContextResponse.getter(DescribeContextResponse::createdBy)).setter(DescribeContextResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeContextResponse.getter(DescribeContextResponse::lastModifiedTime)).setter(DescribeContextResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(DescribeContextResponse.getter(DescribeContextResponse::lastModifiedBy)).setter(DescribeContextResponse.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineageGroupArn").getter(DescribeContextResponse.getter(DescribeContextResponse::lineageGroupArn)).setter(DescribeContextResponse.setter(Builder::lineageGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_NAME_FIELD, CONTEXT_ARN_FIELD, SOURCE_FIELD, CONTEXT_TYPE_FIELD, DESCRIPTION_FIELD, PROPERTIES_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LINEAGE_GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeContextResponse.memberNameToFieldInitializer();
    private final String contextName;
    private final String contextArn;
    private final ContextSource source;
    private final String contextType;
    private final String description;
    private final Map<String, String> properties;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final String lineageGroupArn;

    private DescribeContextResponse(BuilderImpl builder) {
        super(builder);
        this.contextName = builder.contextName;
        this.contextArn = builder.contextArn;
        this.source = builder.source;
        this.contextType = builder.contextType;
        this.description = builder.description;
        this.properties = builder.properties;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lineageGroupArn = builder.lineageGroupArn;
    }

    public final String contextName() {
        return this.contextName;
    }

    public final String contextArn() {
        return this.contextArn;
    }

    public final ContextSource source() {
        return this.source;
    }

    public final String contextType() {
        return this.contextType;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final String lineageGroupArn() {
        return this.lineageGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contextName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContextResponse)) {
            return false;
        }
        DescribeContextResponse other = (DescribeContextResponse)((Object)obj);
        return Objects.equals(this.contextName(), other.contextName()) && Objects.equals(this.contextArn(), other.contextArn()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.contextType(), other.contextType()) && Objects.equals(this.description(), other.description()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lineageGroupArn(), other.lineageGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeContextResponse").add("ContextName", (Object)this.contextName()).add("ContextArn", (Object)this.contextArn()).add("Source", (Object)this.source()).add("ContextType", (Object)this.contextType()).add("Description", (Object)this.description()).add("Properties", this.hasProperties() ? this.properties() : null).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LineageGroupArn", (Object)this.lineageGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextName": {
                return Optional.ofNullable(clazz.cast(this.contextName()));
            }
            case "ContextArn": {
                return Optional.ofNullable(clazz.cast(this.contextArn()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ContextType": {
                return Optional.ofNullable(clazz.cast(this.contextType()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LineageGroupArn": {
                return Optional.ofNullable(clazz.cast(this.lineageGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContextName", CONTEXT_NAME_FIELD);
        map.put("ContextArn", CONTEXT_ARN_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ContextType", CONTEXT_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LineageGroupArn", LINEAGE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContextResponse, T> g) {
        return obj -> g.apply((DescribeContextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String contextName;
        private String contextArn;
        private ContextSource source;
        private String contextType;
        private String description;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private String lineageGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContextResponse model) {
            super(model);
            this.contextName(model.contextName);
            this.contextArn(model.contextArn);
            this.source(model.source);
            this.contextType(model.contextType);
            this.description(model.description);
            this.properties(model.properties);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lineageGroupArn(model.lineageGroupArn);
        }

        public final String getContextName() {
            return this.contextName;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        @Override
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final String getContextArn() {
            return this.contextArn;
        }

        public final void setContextArn(String contextArn) {
            this.contextArn = contextArn;
        }

        @Override
        public final Builder contextArn(String contextArn) {
            this.contextArn = contextArn;
            return this;
        }

        public final ContextSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ContextSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ContextSource source) {
            this.source = source;
            return this;
        }

        public final String getContextType() {
            return this.contextType;
        }

        public final void setContextType(String contextType) {
            this.contextType = contextType;
        }

        @Override
        public final Builder contextType(String contextType) {
            this.contextType = contextType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getLineageGroupArn() {
            return this.lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        @Override
        public DescribeContextResponse build() {
            return new DescribeContextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeContextResponse> {
        public Builder contextName(String var1);

        public Builder contextArn(String var1);

        public Builder source(ContextSource var1);

        default public Builder source(Consumer<ContextSource.Builder> source) {
            return this.source((ContextSource)((ContextSource.Builder)ContextSource.builder().applyMutation(source)).build());
        }

        public Builder contextType(String var1);

        public Builder description(String var1);

        public Builder properties(Map<String, String> var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder lineageGroupArn(String var1);
    }
}

