/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CapacitySizeConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RollingDeploymentPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RollingDeploymentPolicy> {
    private static final SdkField<CapacitySizeConfig> MAXIMUM_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaximumBatchSize").getter(RollingDeploymentPolicy.getter(RollingDeploymentPolicy::maximumBatchSize)).setter(RollingDeploymentPolicy.setter(Builder::maximumBatchSize)).constructor(CapacitySizeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchSize").build()}).build();
    private static final SdkField<CapacitySizeConfig> ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollbackMaximumBatchSize").getter(RollingDeploymentPolicy.getter(RollingDeploymentPolicy::rollbackMaximumBatchSize)).setter(RollingDeploymentPolicy.setter(Builder::rollbackMaximumBatchSize)).constructor(CapacitySizeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackMaximumBatchSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BATCH_SIZE_FIELD, ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RollingDeploymentPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CapacitySizeConfig maximumBatchSize;
    private final CapacitySizeConfig rollbackMaximumBatchSize;

    private RollingDeploymentPolicy(BuilderImpl builder) {
        this.maximumBatchSize = builder.maximumBatchSize;
        this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
    }

    public final CapacitySizeConfig maximumBatchSize() {
        return this.maximumBatchSize;
    }

    public final CapacitySizeConfig rollbackMaximumBatchSize() {
        return this.rollbackMaximumBatchSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackMaximumBatchSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollingDeploymentPolicy)) {
            return false;
        }
        RollingDeploymentPolicy other = (RollingDeploymentPolicy)obj;
        return Objects.equals(this.maximumBatchSize(), other.maximumBatchSize()) && Objects.equals(this.rollbackMaximumBatchSize(), other.rollbackMaximumBatchSize());
    }

    public final String toString() {
        return ToString.builder((String)"RollingDeploymentPolicy").add("MaximumBatchSize", (Object)this.maximumBatchSize()).add("RollbackMaximumBatchSize", (Object)this.rollbackMaximumBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchSize()));
            }
            case "RollbackMaximumBatchSize": {
                return Optional.ofNullable(clazz.cast(this.rollbackMaximumBatchSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<CapacitySizeConfig>> map = new HashMap<String, SdkField<CapacitySizeConfig>>();
        map.put("MaximumBatchSize", MAXIMUM_BATCH_SIZE_FIELD);
        map.put("RollbackMaximumBatchSize", ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollingDeploymentPolicy, T> g) {
        return obj -> g.apply((RollingDeploymentPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CapacitySizeConfig maximumBatchSize;
        private CapacitySizeConfig rollbackMaximumBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(RollingDeploymentPolicy model) {
            this.maximumBatchSize(model.maximumBatchSize);
            this.rollbackMaximumBatchSize(model.rollbackMaximumBatchSize);
        }

        public final CapacitySizeConfig.Builder getMaximumBatchSize() {
            return this.maximumBatchSize != null ? this.maximumBatchSize.toBuilder() : null;
        }

        public final void setMaximumBatchSize(CapacitySizeConfig.BuilderImpl maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize != null ? maximumBatchSize.build() : null;
        }

        @Override
        public final Builder maximumBatchSize(CapacitySizeConfig maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize;
            return this;
        }

        public final CapacitySizeConfig.Builder getRollbackMaximumBatchSize() {
            return this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.toBuilder() : null;
        }

        public final void setRollbackMaximumBatchSize(CapacitySizeConfig.BuilderImpl rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.build() : null;
        }

        @Override
        public final Builder rollbackMaximumBatchSize(CapacitySizeConfig rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
            return this;
        }

        public RollingDeploymentPolicy build() {
            return new RollingDeploymentPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RollingDeploymentPolicy> {
        public Builder maximumBatchSize(CapacitySizeConfig var1);

        default public Builder maximumBatchSize(Consumer<CapacitySizeConfig.Builder> maximumBatchSize) {
            return this.maximumBatchSize((CapacitySizeConfig)((CapacitySizeConfig.Builder)CapacitySizeConfig.builder().applyMutation(maximumBatchSize)).build());
        }

        public Builder rollbackMaximumBatchSize(CapacitySizeConfig var1);

        default public Builder rollbackMaximumBatchSize(Consumer<CapacitySizeConfig.Builder> rollbackMaximumBatchSize) {
            return this.rollbackMaximumBatchSize((CapacitySizeConfig)((CapacitySizeConfig.Builder)CapacitySizeConfig.builder().applyMutation(rollbackMaximumBatchSize)).build());
        }
    }
}

