/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentDeploymentConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentRuntimeConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInferenceComponentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateInferenceComponentRequest> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentName").getter(UpdateInferenceComponentRequest.getter(UpdateInferenceComponentRequest::inferenceComponentName)).setter(UpdateInferenceComponentRequest.setter(Builder::inferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build()}).build();
    private static final SdkField<InferenceComponentSpecification> SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Specification").getter(UpdateInferenceComponentRequest.getter(UpdateInferenceComponentRequest::specification)).setter(UpdateInferenceComponentRequest.setter(Builder::specification)).constructor(InferenceComponentSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specification").build()}).build();
    private static final SdkField<InferenceComponentRuntimeConfig> RUNTIME_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeConfig").getter(UpdateInferenceComponentRequest.getter(UpdateInferenceComponentRequest::runtimeConfig)).setter(UpdateInferenceComponentRequest.setter(Builder::runtimeConfig)).constructor(InferenceComponentRuntimeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfig").build()}).build();
    private static final SdkField<InferenceComponentDeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfig").getter(UpdateInferenceComponentRequest.getter(UpdateInferenceComponentRequest::deploymentConfig)).setter(UpdateInferenceComponentRequest.setter(Builder::deploymentConfig)).constructor(InferenceComponentDeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_COMPONENT_NAME_FIELD, SPECIFICATION_FIELD, RUNTIME_CONFIG_FIELD, DEPLOYMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInferenceComponentRequest.memberNameToFieldInitializer();
    private final String inferenceComponentName;
    private final InferenceComponentSpecification specification;
    private final InferenceComponentRuntimeConfig runtimeConfig;
    private final InferenceComponentDeploymentConfig deploymentConfig;

    private UpdateInferenceComponentRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.specification = builder.specification;
        this.runtimeConfig = builder.runtimeConfig;
        this.deploymentConfig = builder.deploymentConfig;
    }

    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    public final InferenceComponentSpecification specification() {
        return this.specification;
    }

    public final InferenceComponentRuntimeConfig runtimeConfig() {
        return this.runtimeConfig;
    }

    public final InferenceComponentDeploymentConfig deploymentConfig() {
        return this.deploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.specification());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceComponentRequest)) {
            return false;
        }
        UpdateInferenceComponentRequest other = (UpdateInferenceComponentRequest)((Object)obj);
        return Objects.equals(this.inferenceComponentName(), other.inferenceComponentName()) && Objects.equals(this.specification(), other.specification()) && Objects.equals(this.runtimeConfig(), other.runtimeConfig()) && Objects.equals(this.deploymentConfig(), other.deploymentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInferenceComponentRequest").add("InferenceComponentName", (Object)this.inferenceComponentName()).add("Specification", (Object)this.specification()).add("RuntimeConfig", (Object)this.runtimeConfig()).add("DeploymentConfig", (Object)this.deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentName()));
            }
            case "Specification": {
                return Optional.ofNullable(clazz.cast(this.specification()));
            }
            case "RuntimeConfig": {
                return Optional.ofNullable(clazz.cast(this.runtimeConfig()));
            }
            case "DeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("Specification", SPECIFICATION_FIELD);
        map.put("RuntimeConfig", RUNTIME_CONFIG_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceComponentRequest, T> g) {
        return obj -> g.apply((UpdateInferenceComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String inferenceComponentName;
        private InferenceComponentSpecification specification;
        private InferenceComponentRuntimeConfig runtimeConfig;
        private InferenceComponentDeploymentConfig deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceComponentRequest model) {
            super(model);
            this.inferenceComponentName(model.inferenceComponentName);
            this.specification(model.specification);
            this.runtimeConfig(model.runtimeConfig);
            this.deploymentConfig(model.deploymentConfig);
        }

        public final String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final InferenceComponentSpecification.Builder getSpecification() {
            return this.specification != null ? this.specification.toBuilder() : null;
        }

        public final void setSpecification(InferenceComponentSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(InferenceComponentSpecification specification) {
            this.specification = specification;
            return this;
        }

        public final InferenceComponentRuntimeConfig.Builder getRuntimeConfig() {
            return this.runtimeConfig != null ? this.runtimeConfig.toBuilder() : null;
        }

        public final void setRuntimeConfig(InferenceComponentRuntimeConfig.BuilderImpl runtimeConfig) {
            this.runtimeConfig = runtimeConfig != null ? runtimeConfig.build() : null;
        }

        @Override
        public final Builder runtimeConfig(InferenceComponentRuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public final InferenceComponentDeploymentConfig.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(InferenceComponentDeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(InferenceComponentDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceComponentRequest build() {
            return new UpdateInferenceComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInferenceComponentRequest> {
        public Builder inferenceComponentName(String var1);

        public Builder specification(InferenceComponentSpecification var1);

        default public Builder specification(Consumer<InferenceComponentSpecification.Builder> specification) {
            return this.specification((InferenceComponentSpecification)((InferenceComponentSpecification.Builder)InferenceComponentSpecification.builder().applyMutation(specification)).build());
        }

        public Builder runtimeConfig(InferenceComponentRuntimeConfig var1);

        default public Builder runtimeConfig(Consumer<InferenceComponentRuntimeConfig.Builder> runtimeConfig) {
            return this.runtimeConfig((InferenceComponentRuntimeConfig)((InferenceComponentRuntimeConfig.Builder)InferenceComponentRuntimeConfig.builder().applyMutation(runtimeConfig)).build());
        }

        public Builder deploymentConfig(InferenceComponentDeploymentConfig var1);

        default public Builder deploymentConfig(Consumer<InferenceComponentDeploymentConfig.Builder> deploymentConfig) {
            return this.deploymentConfig((InferenceComponentDeploymentConfig)((InferenceComponentDeploymentConfig.Builder)InferenceComponentDeploymentConfig.builder().applyMutation(deploymentConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

