/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportArtifacts;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelCardExportJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelCardExportJobResponse> {
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardExportJobName").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::modelCardExportJobName)).setter(DescribeModelCardExportJobResponse.setter(Builder::modelCardExportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobName").build()}).build();
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardExportJobArn").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::modelCardExportJobArn)).setter(DescribeModelCardExportJobResponse.setter(Builder::modelCardExportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::statusAsString)).setter(DescribeModelCardExportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardName").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::modelCardName)).setter(DescribeModelCardExportJobResponse.setter(Builder::modelCardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()}).build();
    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelCardVersion").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::modelCardVersion)).setter(DescribeModelCardExportJobResponse.setter(Builder::modelCardVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()}).build();
    private static final SdkField<ModelCardExportOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::outputConfig)).setter(DescribeModelCardExportJobResponse.setter(Builder::outputConfig)).constructor(ModelCardExportOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::createdAt)).setter(DescribeModelCardExportJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedAt").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::lastModifiedAt)).setter(DescribeModelCardExportJobResponse.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::failureReason)).setter(DescribeModelCardExportJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<ModelCardExportArtifacts> EXPORT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportArtifacts").getter(DescribeModelCardExportJobResponse.getter(DescribeModelCardExportJobResponse::exportArtifacts)).setter(DescribeModelCardExportJobResponse.setter(Builder::exportArtifacts)).constructor(ModelCardExportArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArtifacts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_EXPORT_JOB_NAME_FIELD, MODEL_CARD_EXPORT_JOB_ARN_FIELD, STATUS_FIELD, MODEL_CARD_NAME_FIELD, MODEL_CARD_VERSION_FIELD, OUTPUT_CONFIG_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, FAILURE_REASON_FIELD, EXPORT_ARTIFACTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeModelCardExportJobResponse.memberNameToFieldInitializer();
    private final String modelCardExportJobName;
    private final String modelCardExportJobArn;
    private final String status;
    private final String modelCardName;
    private final Integer modelCardVersion;
    private final ModelCardExportOutputConfig outputConfig;
    private final Instant createdAt;
    private final Instant lastModifiedAt;
    private final String failureReason;
    private final ModelCardExportArtifacts exportArtifacts;

    private DescribeModelCardExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardExportJobName = builder.modelCardExportJobName;
        this.modelCardExportJobArn = builder.modelCardExportJobArn;
        this.status = builder.status;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.outputConfig = builder.outputConfig;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.failureReason = builder.failureReason;
        this.exportArtifacts = builder.exportArtifacts;
    }

    public final String modelCardExportJobName() {
        return this.modelCardExportJobName;
    }

    public final String modelCardExportJobArn() {
        return this.modelCardExportJobArn;
    }

    public final ModelCardExportJobStatus status() {
        return ModelCardExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String modelCardName() {
        return this.modelCardName;
    }

    public final Integer modelCardVersion() {
        return this.modelCardVersion;
    }

    public final ModelCardExportOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final ModelCardExportArtifacts exportArtifacts() {
        return this.exportArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportArtifacts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelCardExportJobResponse)) {
            return false;
        }
        DescribeModelCardExportJobResponse other = (DescribeModelCardExportJobResponse)((Object)obj);
        return Objects.equals(this.modelCardExportJobName(), other.modelCardExportJobName()) && Objects.equals(this.modelCardExportJobArn(), other.modelCardExportJobArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelCardName(), other.modelCardName()) && Objects.equals(this.modelCardVersion(), other.modelCardVersion()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.exportArtifacts(), other.exportArtifacts());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelCardExportJobResponse").add("ModelCardExportJobName", (Object)this.modelCardExportJobName()).add("ModelCardExportJobArn", (Object)this.modelCardExportJobArn()).add("Status", (Object)this.statusAsString()).add("ModelCardName", (Object)this.modelCardName()).add("ModelCardVersion", (Object)this.modelCardVersion()).add("OutputConfig", (Object)this.outputConfig()).add("CreatedAt", (Object)this.createdAt()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("FailureReason", (Object)this.failureReason()).add("ExportArtifacts", (Object)this.exportArtifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardExportJobName": {
                return Optional.ofNullable(clazz.cast(this.modelCardExportJobName()));
            }
            case "ModelCardExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.modelCardExportJobArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelCardName": {
                return Optional.ofNullable(clazz.cast(this.modelCardName()));
            }
            case "ModelCardVersion": {
                return Optional.ofNullable(clazz.cast(this.modelCardVersion()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ExportArtifacts": {
                return Optional.ofNullable(clazz.cast(this.exportArtifacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelCardExportJobName", MODEL_CARD_EXPORT_JOB_NAME_FIELD);
        map.put("ModelCardExportJobArn", MODEL_CARD_EXPORT_JOB_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ModelCardName", MODEL_CARD_NAME_FIELD);
        map.put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("ExportArtifacts", EXPORT_ARTIFACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelCardExportJobResponse, T> g) {
        return obj -> g.apply((DescribeModelCardExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String modelCardExportJobName;
        private String modelCardExportJobArn;
        private String status;
        private String modelCardName;
        private Integer modelCardVersion;
        private ModelCardExportOutputConfig outputConfig;
        private Instant createdAt;
        private Instant lastModifiedAt;
        private String failureReason;
        private ModelCardExportArtifacts exportArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelCardExportJobResponse model) {
            super(model);
            this.modelCardExportJobName(model.modelCardExportJobName);
            this.modelCardExportJobArn(model.modelCardExportJobArn);
            this.status(model.status);
            this.modelCardName(model.modelCardName);
            this.modelCardVersion(model.modelCardVersion);
            this.outputConfig(model.outputConfig);
            this.createdAt(model.createdAt);
            this.lastModifiedAt(model.lastModifiedAt);
            this.failureReason(model.failureReason);
            this.exportArtifacts(model.exportArtifacts);
        }

        public final String getModelCardExportJobName() {
            return this.modelCardExportJobName;
        }

        public final void setModelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
        }

        @Override
        public final Builder modelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
            return this;
        }

        public final String getModelCardExportJobArn() {
            return this.modelCardExportJobArn;
        }

        public final void setModelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
        }

        @Override
        public final Builder modelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCardExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelCardName() {
            return this.modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return this.modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final ModelCardExportOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ModelCardExportOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ModelCardExportOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final ModelCardExportArtifacts.Builder getExportArtifacts() {
            return this.exportArtifacts != null ? this.exportArtifacts.toBuilder() : null;
        }

        public final void setExportArtifacts(ModelCardExportArtifacts.BuilderImpl exportArtifacts) {
            this.exportArtifacts = exportArtifacts != null ? exportArtifacts.build() : null;
        }

        @Override
        public final Builder exportArtifacts(ModelCardExportArtifacts exportArtifacts) {
            this.exportArtifacts = exportArtifacts;
            return this;
        }

        @Override
        public DescribeModelCardExportJobResponse build() {
            return new DescribeModelCardExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelCardExportJobResponse> {
        public Builder modelCardExportJobName(String var1);

        public Builder modelCardExportJobArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelCardExportJobStatus var1);

        public Builder modelCardName(String var1);

        public Builder modelCardVersion(Integer var1);

        public Builder outputConfig(ModelCardExportOutputConfig var1);

        default public Builder outputConfig(Consumer<ModelCardExportOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ModelCardExportOutputConfig)((ModelCardExportOutputConfig.Builder)ModelCardExportOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder failureReason(String var1);

        public Builder exportArtifacts(ModelCardExportArtifacts var1);

        default public Builder exportArtifacts(Consumer<ModelCardExportArtifacts.Builder> exportArtifacts) {
            return this.exportArtifacts((ModelCardExportArtifacts)((ModelCardExportArtifacts.Builder)ModelCardExportArtifacts.builder().applyMutation(exportArtifacts)).build());
        }
    }
}

