/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLJobArtifacts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLJobArtifacts> {
    private static final SdkField<String> CANDIDATE_DEFINITION_NOTEBOOK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateDefinitionNotebookLocation").getter(AutoMLJobArtifacts.getter(AutoMLJobArtifacts::candidateDefinitionNotebookLocation)).setter(AutoMLJobArtifacts.setter(Builder::candidateDefinitionNotebookLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateDefinitionNotebookLocation").build()}).build();
    private static final SdkField<String> DATA_EXPLORATION_NOTEBOOK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataExplorationNotebookLocation").getter(AutoMLJobArtifacts.getter(AutoMLJobArtifacts::dataExplorationNotebookLocation)).setter(AutoMLJobArtifacts.setter(Builder::dataExplorationNotebookLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExplorationNotebookLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_DEFINITION_NOTEBOOK_LOCATION_FIELD, DATA_EXPLORATION_NOTEBOOK_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoMLJobArtifacts.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String candidateDefinitionNotebookLocation;
    private final String dataExplorationNotebookLocation;

    private AutoMLJobArtifacts(BuilderImpl builder) {
        this.candidateDefinitionNotebookLocation = builder.candidateDefinitionNotebookLocation;
        this.dataExplorationNotebookLocation = builder.dataExplorationNotebookLocation;
    }

    public final String candidateDefinitionNotebookLocation() {
        return this.candidateDefinitionNotebookLocation;
    }

    public final String dataExplorationNotebookLocation() {
        return this.dataExplorationNotebookLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateDefinitionNotebookLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataExplorationNotebookLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobArtifacts)) {
            return false;
        }
        AutoMLJobArtifacts other = (AutoMLJobArtifacts)obj;
        return Objects.equals(this.candidateDefinitionNotebookLocation(), other.candidateDefinitionNotebookLocation()) && Objects.equals(this.dataExplorationNotebookLocation(), other.dataExplorationNotebookLocation());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLJobArtifacts").add("CandidateDefinitionNotebookLocation", (Object)this.candidateDefinitionNotebookLocation()).add("DataExplorationNotebookLocation", (Object)this.dataExplorationNotebookLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CandidateDefinitionNotebookLocation": {
                return Optional.ofNullable(clazz.cast(this.candidateDefinitionNotebookLocation()));
            }
            case "DataExplorationNotebookLocation": {
                return Optional.ofNullable(clazz.cast(this.dataExplorationNotebookLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CandidateDefinitionNotebookLocation", CANDIDATE_DEFINITION_NOTEBOOK_LOCATION_FIELD);
        map.put("DataExplorationNotebookLocation", DATA_EXPLORATION_NOTEBOOK_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobArtifacts, T> g) {
        return obj -> g.apply((AutoMLJobArtifacts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String candidateDefinitionNotebookLocation;
        private String dataExplorationNotebookLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobArtifacts model) {
            this.candidateDefinitionNotebookLocation(model.candidateDefinitionNotebookLocation);
            this.dataExplorationNotebookLocation(model.dataExplorationNotebookLocation);
        }

        public final String getCandidateDefinitionNotebookLocation() {
            return this.candidateDefinitionNotebookLocation;
        }

        public final void setCandidateDefinitionNotebookLocation(String candidateDefinitionNotebookLocation) {
            this.candidateDefinitionNotebookLocation = candidateDefinitionNotebookLocation;
        }

        @Override
        public final Builder candidateDefinitionNotebookLocation(String candidateDefinitionNotebookLocation) {
            this.candidateDefinitionNotebookLocation = candidateDefinitionNotebookLocation;
            return this;
        }

        public final String getDataExplorationNotebookLocation() {
            return this.dataExplorationNotebookLocation;
        }

        public final void setDataExplorationNotebookLocation(String dataExplorationNotebookLocation) {
            this.dataExplorationNotebookLocation = dataExplorationNotebookLocation;
        }

        @Override
        public final Builder dataExplorationNotebookLocation(String dataExplorationNotebookLocation) {
            this.dataExplorationNotebookLocation = dataExplorationNotebookLocation;
            return this;
        }

        public AutoMLJobArtifacts build() {
            return new AutoMLJobArtifacts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLJobArtifacts> {
        public Builder candidateDefinitionNotebookLocation(String var1);

        public Builder dataExplorationNotebookLocation(String var1);
    }
}

