/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Model;
import software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint;
import software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpointsCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelDashboardModelCard;
import software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule;
import software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedulesCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformJob;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelDashboardModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelDashboardModel> {
    private static final SdkField<Model> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Model").getter(ModelDashboardModel.getter(ModelDashboardModel::model)).setter(ModelDashboardModel.setter(Builder::model)).constructor(Model::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<List<ModelDashboardEndpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(ModelDashboardModel.getter(ModelDashboardModel::endpoints)).setter(ModelDashboardModel.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelDashboardEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TransformJob> LAST_BATCH_TRANSFORM_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastBatchTransformJob").getter(ModelDashboardModel.getter(ModelDashboardModel::lastBatchTransformJob)).setter(ModelDashboardModel.setter(Builder::lastBatchTransformJob)).constructor(TransformJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBatchTransformJob").build()}).build();
    private static final SdkField<List<ModelDashboardMonitoringSchedule>> MONITORING_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoringSchedules").getter(ModelDashboardModel.getter(ModelDashboardModel::monitoringSchedules)).setter(ModelDashboardModel.setter(Builder::monitoringSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringSchedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelDashboardMonitoringSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ModelDashboardModelCard> MODEL_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelCard").getter(ModelDashboardModel.getter(ModelDashboardModel::modelCard)).setter(ModelDashboardModel.setter(Builder::modelCard)).constructor(ModelDashboardModelCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_FIELD, ENDPOINTS_FIELD, LAST_BATCH_TRANSFORM_JOB_FIELD, MONITORING_SCHEDULES_FIELD, MODEL_CARD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelDashboardModel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Model model;
    private final List<ModelDashboardEndpoint> endpoints;
    private final TransformJob lastBatchTransformJob;
    private final List<ModelDashboardMonitoringSchedule> monitoringSchedules;
    private final ModelDashboardModelCard modelCard;

    private ModelDashboardModel(BuilderImpl builder) {
        this.model = builder.model;
        this.endpoints = builder.endpoints;
        this.lastBatchTransformJob = builder.lastBatchTransformJob;
        this.monitoringSchedules = builder.monitoringSchedules;
        this.modelCard = builder.modelCard;
    }

    public final Model model() {
        return this.model;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<ModelDashboardEndpoint> endpoints() {
        return this.endpoints;
    }

    public final TransformJob lastBatchTransformJob() {
        return this.lastBatchTransformJob;
    }

    public final boolean hasMonitoringSchedules() {
        return this.monitoringSchedules != null && !(this.monitoringSchedules instanceof SdkAutoConstructList);
    }

    public final List<ModelDashboardMonitoringSchedule> monitoringSchedules() {
        return this.monitoringSchedules;
    }

    public final ModelDashboardModelCard modelCard() {
        return this.modelCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBatchTransformJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoringSchedules() ? this.monitoringSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCard());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDashboardModel)) {
            return false;
        }
        ModelDashboardModel other = (ModelDashboardModel)obj;
        return Objects.equals(this.model(), other.model()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.lastBatchTransformJob(), other.lastBatchTransformJob()) && this.hasMonitoringSchedules() == other.hasMonitoringSchedules() && Objects.equals(this.monitoringSchedules(), other.monitoringSchedules()) && Objects.equals(this.modelCard(), other.modelCard());
    }

    public final String toString() {
        return ToString.builder((String)"ModelDashboardModel").add("Model", (Object)this.model()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("LastBatchTransformJob", (Object)this.lastBatchTransformJob()).add("MonitoringSchedules", this.hasMonitoringSchedules() ? this.monitoringSchedules() : null).add("ModelCard", (Object)this.modelCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "LastBatchTransformJob": {
                return Optional.ofNullable(clazz.cast(this.lastBatchTransformJob()));
            }
            case "MonitoringSchedules": {
                return Optional.ofNullable(clazz.cast(this.monitoringSchedules()));
            }
            case "ModelCard": {
                return Optional.ofNullable(clazz.cast(this.modelCard()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Model", MODEL_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("LastBatchTransformJob", LAST_BATCH_TRANSFORM_JOB_FIELD);
        map.put("MonitoringSchedules", MONITORING_SCHEDULES_FIELD);
        map.put("ModelCard", MODEL_CARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelDashboardModel, T> g) {
        return obj -> g.apply((ModelDashboardModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Model model;
        private List<ModelDashboardEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();
        private TransformJob lastBatchTransformJob;
        private List<ModelDashboardMonitoringSchedule> monitoringSchedules = DefaultSdkAutoConstructList.getInstance();
        private ModelDashboardModelCard modelCard;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDashboardModel model) {
            this.model(model.model);
            this.endpoints(model.endpoints);
            this.lastBatchTransformJob(model.lastBatchTransformJob);
            this.monitoringSchedules(model.monitoringSchedules);
            this.modelCard(model.modelCard);
        }

        public final Model.Builder getModel() {
            return this.model != null ? this.model.toBuilder() : null;
        }

        public final void setModel(Model.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(Model model) {
            this.model = model;
            return this;
        }

        public final List<ModelDashboardEndpoint.Builder> getEndpoints() {
            List<ModelDashboardEndpoint.Builder> result = ModelDashboardEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<ModelDashboardEndpoint.BuilderImpl> endpoints) {
            this.endpoints = ModelDashboardEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<ModelDashboardEndpoint> endpoints) {
            this.endpoints = ModelDashboardEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(ModelDashboardEndpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<ModelDashboardEndpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (ModelDashboardEndpoint)((ModelDashboardEndpoint.Builder)ModelDashboardEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TransformJob.Builder getLastBatchTransformJob() {
            return this.lastBatchTransformJob != null ? this.lastBatchTransformJob.toBuilder() : null;
        }

        public final void setLastBatchTransformJob(TransformJob.BuilderImpl lastBatchTransformJob) {
            this.lastBatchTransformJob = lastBatchTransformJob != null ? lastBatchTransformJob.build() : null;
        }

        @Override
        public final Builder lastBatchTransformJob(TransformJob lastBatchTransformJob) {
            this.lastBatchTransformJob = lastBatchTransformJob;
            return this;
        }

        public final List<ModelDashboardMonitoringSchedule.Builder> getMonitoringSchedules() {
            List<ModelDashboardMonitoringSchedule.Builder> result = ModelDashboardMonitoringSchedulesCopier.copyToBuilder(this.monitoringSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringSchedules(Collection<ModelDashboardMonitoringSchedule.BuilderImpl> monitoringSchedules) {
            this.monitoringSchedules = ModelDashboardMonitoringSchedulesCopier.copyFromBuilder(monitoringSchedules);
        }

        @Override
        public final Builder monitoringSchedules(Collection<ModelDashboardMonitoringSchedule> monitoringSchedules) {
            this.monitoringSchedules = ModelDashboardMonitoringSchedulesCopier.copy(monitoringSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringSchedules(ModelDashboardMonitoringSchedule ... monitoringSchedules) {
            this.monitoringSchedules(Arrays.asList(monitoringSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringSchedules(Consumer<ModelDashboardMonitoringSchedule.Builder> ... monitoringSchedules) {
            this.monitoringSchedules(Stream.of(monitoringSchedules).map(c -> (ModelDashboardMonitoringSchedule)((ModelDashboardMonitoringSchedule.Builder)ModelDashboardMonitoringSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ModelDashboardModelCard.Builder getModelCard() {
            return this.modelCard != null ? this.modelCard.toBuilder() : null;
        }

        public final void setModelCard(ModelDashboardModelCard.BuilderImpl modelCard) {
            this.modelCard = modelCard != null ? modelCard.build() : null;
        }

        @Override
        public final Builder modelCard(ModelDashboardModelCard modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        public ModelDashboardModel build() {
            return new ModelDashboardModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelDashboardModel> {
        public Builder model(Model var1);

        default public Builder model(Consumer<Model.Builder> model) {
            return this.model((Model)((Model.Builder)Model.builder().applyMutation(model)).build());
        }

        public Builder endpoints(Collection<ModelDashboardEndpoint> var1);

        public Builder endpoints(ModelDashboardEndpoint ... var1);

        public Builder endpoints(Consumer<ModelDashboardEndpoint.Builder> ... var1);

        public Builder lastBatchTransformJob(TransformJob var1);

        default public Builder lastBatchTransformJob(Consumer<TransformJob.Builder> lastBatchTransformJob) {
            return this.lastBatchTransformJob((TransformJob)((TransformJob.Builder)TransformJob.builder().applyMutation(lastBatchTransformJob)).build());
        }

        public Builder monitoringSchedules(Collection<ModelDashboardMonitoringSchedule> var1);

        public Builder monitoringSchedules(ModelDashboardMonitoringSchedule ... var1);

        public Builder monitoringSchedules(Consumer<ModelDashboardMonitoringSchedule.Builder> ... var1);

        public Builder modelCard(ModelDashboardModelCard var1);

        default public Builder modelCard(Consumer<ModelDashboardModelCard.Builder> modelCard) {
            return this.modelCard((ModelDashboardModelCard)((ModelDashboardModelCard.Builder)ModelDashboardModelCard.builder().applyMutation(modelCard)).build());
        }
    }
}

