/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentDeploymentConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentRuntimeConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentSpecificationSummary;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInferenceComponentResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeInferenceComponentResponse> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentName").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::inferenceComponentName)).setter(DescribeInferenceComponentResponse.setter(Builder::inferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build()}).build();
    private static final SdkField<String> INFERENCE_COMPONENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentArn").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::inferenceComponentArn)).setter(DescribeInferenceComponentResponse.setter(Builder::inferenceComponentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentArn").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::endpointName)).setter(DescribeInferenceComponentResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::endpointArn)).setter(DescribeInferenceComponentResponse.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::variantName)).setter(DescribeInferenceComponentResponse.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::failureReason)).setter(DescribeInferenceComponentResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<InferenceComponentSpecificationSummary> SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Specification").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::specification)).setter(DescribeInferenceComponentResponse.setter(Builder::specification)).constructor(InferenceComponentSpecificationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specification").build()}).build();
    private static final SdkField<InferenceComponentRuntimeConfigSummary> RUNTIME_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeConfig").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::runtimeConfig)).setter(DescribeInferenceComponentResponse.setter(Builder::runtimeConfig)).constructor(InferenceComponentRuntimeConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::creationTime)).setter(DescribeInferenceComponentResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::lastModifiedTime)).setter(DescribeInferenceComponentResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> INFERENCE_COMPONENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentStatus").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::inferenceComponentStatusAsString)).setter(DescribeInferenceComponentResponse.setter(Builder::inferenceComponentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentStatus").build()}).build();
    private static final SdkField<InferenceComponentDeploymentConfig> LAST_DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastDeploymentConfig").getter(DescribeInferenceComponentResponse.getter(DescribeInferenceComponentResponse::lastDeploymentConfig)).setter(DescribeInferenceComponentResponse.setter(Builder::lastDeploymentConfig)).constructor(InferenceComponentDeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeploymentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_COMPONENT_NAME_FIELD, INFERENCE_COMPONENT_ARN_FIELD, ENDPOINT_NAME_FIELD, ENDPOINT_ARN_FIELD, VARIANT_NAME_FIELD, FAILURE_REASON_FIELD, SPECIFICATION_FIELD, RUNTIME_CONFIG_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, INFERENCE_COMPONENT_STATUS_FIELD, LAST_DEPLOYMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInferenceComponentResponse.memberNameToFieldInitializer();
    private final String inferenceComponentName;
    private final String inferenceComponentArn;
    private final String endpointName;
    private final String endpointArn;
    private final String variantName;
    private final String failureReason;
    private final InferenceComponentSpecificationSummary specification;
    private final InferenceComponentRuntimeConfigSummary runtimeConfig;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String inferenceComponentStatus;
    private final InferenceComponentDeploymentConfig lastDeploymentConfig;

    private DescribeInferenceComponentResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.inferenceComponentArn = builder.inferenceComponentArn;
        this.endpointName = builder.endpointName;
        this.endpointArn = builder.endpointArn;
        this.variantName = builder.variantName;
        this.failureReason = builder.failureReason;
        this.specification = builder.specification;
        this.runtimeConfig = builder.runtimeConfig;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.inferenceComponentStatus = builder.inferenceComponentStatus;
        this.lastDeploymentConfig = builder.lastDeploymentConfig;
    }

    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    public final String inferenceComponentArn() {
        return this.inferenceComponentArn;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final InferenceComponentSpecificationSummary specification() {
        return this.specification;
    }

    public final InferenceComponentRuntimeConfigSummary runtimeConfig() {
        return this.runtimeConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final InferenceComponentStatus inferenceComponentStatus() {
        return InferenceComponentStatus.fromValue(this.inferenceComponentStatus);
    }

    public final String inferenceComponentStatusAsString() {
        return this.inferenceComponentStatus;
    }

    public final InferenceComponentDeploymentConfig lastDeploymentConfig() {
        return this.lastDeploymentConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.specification());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceComponentResponse)) {
            return false;
        }
        DescribeInferenceComponentResponse other = (DescribeInferenceComponentResponse)((Object)obj);
        return Objects.equals(this.inferenceComponentName(), other.inferenceComponentName()) && Objects.equals(this.inferenceComponentArn(), other.inferenceComponentArn()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.specification(), other.specification()) && Objects.equals(this.runtimeConfig(), other.runtimeConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.inferenceComponentStatusAsString(), other.inferenceComponentStatusAsString()) && Objects.equals(this.lastDeploymentConfig(), other.lastDeploymentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInferenceComponentResponse").add("InferenceComponentName", (Object)this.inferenceComponentName()).add("InferenceComponentArn", (Object)this.inferenceComponentArn()).add("EndpointName", (Object)this.endpointName()).add("EndpointArn", (Object)this.endpointArn()).add("VariantName", (Object)this.variantName()).add("FailureReason", (Object)this.failureReason()).add("Specification", (Object)this.specification()).add("RuntimeConfig", (Object)this.runtimeConfig()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("InferenceComponentStatus", (Object)this.inferenceComponentStatusAsString()).add("LastDeploymentConfig", (Object)this.lastDeploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentName()));
            }
            case "InferenceComponentArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentArn()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Specification": {
                return Optional.ofNullable(clazz.cast(this.specification()));
            }
            case "RuntimeConfig": {
                return Optional.ofNullable(clazz.cast(this.runtimeConfig()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "InferenceComponentStatus": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentStatusAsString()));
            }
            case "LastDeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("InferenceComponentArn", INFERENCE_COMPONENT_ARN_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("Specification", SPECIFICATION_FIELD);
        map.put("RuntimeConfig", RUNTIME_CONFIG_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("InferenceComponentStatus", INFERENCE_COMPONENT_STATUS_FIELD);
        map.put("LastDeploymentConfig", LAST_DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceComponentResponse, T> g) {
        return obj -> g.apply((DescribeInferenceComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String inferenceComponentName;
        private String inferenceComponentArn;
        private String endpointName;
        private String endpointArn;
        private String variantName;
        private String failureReason;
        private InferenceComponentSpecificationSummary specification;
        private InferenceComponentRuntimeConfigSummary runtimeConfig;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String inferenceComponentStatus;
        private InferenceComponentDeploymentConfig lastDeploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceComponentResponse model) {
            super(model);
            this.inferenceComponentName(model.inferenceComponentName);
            this.inferenceComponentArn(model.inferenceComponentArn);
            this.endpointName(model.endpointName);
            this.endpointArn(model.endpointArn);
            this.variantName(model.variantName);
            this.failureReason(model.failureReason);
            this.specification(model.specification);
            this.runtimeConfig(model.runtimeConfig);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.inferenceComponentStatus(model.inferenceComponentStatus);
            this.lastDeploymentConfig(model.lastDeploymentConfig);
        }

        public final String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getInferenceComponentArn() {
            return this.inferenceComponentArn;
        }

        public final void setInferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
        }

        @Override
        public final Builder inferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final InferenceComponentSpecificationSummary.Builder getSpecification() {
            return this.specification != null ? this.specification.toBuilder() : null;
        }

        public final void setSpecification(InferenceComponentSpecificationSummary.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(InferenceComponentSpecificationSummary specification) {
            this.specification = specification;
            return this;
        }

        public final InferenceComponentRuntimeConfigSummary.Builder getRuntimeConfig() {
            return this.runtimeConfig != null ? this.runtimeConfig.toBuilder() : null;
        }

        public final void setRuntimeConfig(InferenceComponentRuntimeConfigSummary.BuilderImpl runtimeConfig) {
            this.runtimeConfig = runtimeConfig != null ? runtimeConfig.build() : null;
        }

        @Override
        public final Builder runtimeConfig(InferenceComponentRuntimeConfigSummary runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getInferenceComponentStatus() {
            return this.inferenceComponentStatus;
        }

        public final void setInferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
        }

        @Override
        public final Builder inferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
            return this;
        }

        @Override
        public final Builder inferenceComponentStatus(InferenceComponentStatus inferenceComponentStatus) {
            this.inferenceComponentStatus(inferenceComponentStatus == null ? null : inferenceComponentStatus.toString());
            return this;
        }

        public final InferenceComponentDeploymentConfig.Builder getLastDeploymentConfig() {
            return this.lastDeploymentConfig != null ? this.lastDeploymentConfig.toBuilder() : null;
        }

        public final void setLastDeploymentConfig(InferenceComponentDeploymentConfig.BuilderImpl lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig != null ? lastDeploymentConfig.build() : null;
        }

        @Override
        public final Builder lastDeploymentConfig(InferenceComponentDeploymentConfig lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig;
            return this;
        }

        @Override
        public DescribeInferenceComponentResponse build() {
            return new DescribeInferenceComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInferenceComponentResponse> {
        public Builder inferenceComponentName(String var1);

        public Builder inferenceComponentArn(String var1);

        public Builder endpointName(String var1);

        public Builder endpointArn(String var1);

        public Builder variantName(String var1);

        public Builder failureReason(String var1);

        public Builder specification(InferenceComponentSpecificationSummary var1);

        default public Builder specification(Consumer<InferenceComponentSpecificationSummary.Builder> specification) {
            return this.specification((InferenceComponentSpecificationSummary)((InferenceComponentSpecificationSummary.Builder)InferenceComponentSpecificationSummary.builder().applyMutation(specification)).build());
        }

        public Builder runtimeConfig(InferenceComponentRuntimeConfigSummary var1);

        default public Builder runtimeConfig(Consumer<InferenceComponentRuntimeConfigSummary.Builder> runtimeConfig) {
            return this.runtimeConfig((InferenceComponentRuntimeConfigSummary)((InferenceComponentRuntimeConfigSummary.Builder)InferenceComponentRuntimeConfigSummary.builder().applyMutation(runtimeConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder inferenceComponentStatus(String var1);

        public Builder inferenceComponentStatus(InferenceComponentStatus var1);

        public Builder lastDeploymentConfig(InferenceComponentDeploymentConfig var1);

        default public Builder lastDeploymentConfig(Consumer<InferenceComponentDeploymentConfig.Builder> lastDeploymentConfig) {
            return this.lastDeploymentConfig((InferenceComponentDeploymentConfig)((InferenceComponentDeploymentConfig.Builder)InferenceComponentDeploymentConfig.builder().applyMutation(lastDeploymentConfig)).build());
        }
    }
}

