/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubContentDependency;
import software.amazon.awssdk.services.sagemaker.model.HubContentDependencyListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubContentSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubContentStatus;
import software.amazon.awssdk.services.sagemaker.model.HubContentSupportStatus;
import software.amazon.awssdk.services.sagemaker.model.HubContentType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHubContentResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeHubContentResponse> {
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentName)).setter(DescribeHubContentResponse.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentArn").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentArn)).setter(DescribeHubContentResponse.setter(Builder::hubContentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentArn").build()}).build();
    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentVersion").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentVersion)).setter(DescribeHubContentResponse.setter(Builder::hubContentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()}).build();
    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentType").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentTypeAsString)).setter(DescribeHubContentResponse.setter(Builder::hubContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()}).build();
    private static final SdkField<String> DOCUMENT_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentSchemaVersion").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::documentSchemaVersion)).setter(DescribeHubContentResponse.setter(Builder::documentSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSchemaVersion").build()}).build();
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubName)).setter(DescribeHubContentResponse.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubArn").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubArn)).setter(DescribeHubContentResponse.setter(Builder::hubArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDisplayName").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentDisplayName)).setter(DescribeHubContentResponse.setter(Builder::hubContentDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDescription").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentDescription)).setter(DescribeHubContentResponse.setter(Builder::hubContentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build()}).build();
    private static final SdkField<String> HUB_CONTENT_MARKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentMarkdown").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentMarkdown)).setter(DescribeHubContentResponse.setter(Builder::hubContentMarkdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentMarkdown").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDocument").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentDocument)).setter(DescribeHubContentResponse.setter(Builder::hubContentDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDocument").build()}).build();
    private static final SdkField<String> SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SageMakerPublicHubContentArn").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::sageMakerPublicHubContentArn)).setter(DescribeHubContentResponse.setter(Builder::sageMakerPublicHubContentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPublicHubContentArn").build()}).build();
    private static final SdkField<String> REFERENCE_MIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferenceMinVersion").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::referenceMinVersion)).setter(DescribeHubContentResponse.setter(Builder::referenceMinVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceMinVersion").build()}).build();
    private static final SdkField<String> SUPPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportStatus").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::supportStatusAsString)).setter(DescribeHubContentResponse.setter(Builder::supportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportStatus").build()}).build();
    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubContentSearchKeywords").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentSearchKeywords)).setter(DescribeHubContentResponse.setter(Builder::hubContentSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HubContentDependency>> HUB_CONTENT_DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubContentDependencies").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentDependencies)).setter(DescribeHubContentResponse.setter(Builder::hubContentDependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HubContentDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HUB_CONTENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentStatus").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::hubContentStatusAsString)).setter(DescribeHubContentResponse.setter(Builder::hubContentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::failureReason)).setter(DescribeHubContentResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeHubContentResponse.getter(DescribeHubContentResponse::creationTime)).setter(DescribeHubContentResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_NAME_FIELD, HUB_CONTENT_ARN_FIELD, HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_TYPE_FIELD, DOCUMENT_SCHEMA_VERSION_FIELD, HUB_NAME_FIELD, HUB_ARN_FIELD, HUB_CONTENT_DISPLAY_NAME_FIELD, HUB_CONTENT_DESCRIPTION_FIELD, HUB_CONTENT_MARKDOWN_FIELD, HUB_CONTENT_DOCUMENT_FIELD, SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD, REFERENCE_MIN_VERSION_FIELD, SUPPORT_STATUS_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD, HUB_CONTENT_DEPENDENCIES_FIELD, HUB_CONTENT_STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHubContentResponse.memberNameToFieldInitializer();
    private final String hubContentName;
    private final String hubContentArn;
    private final String hubContentVersion;
    private final String hubContentType;
    private final String documentSchemaVersion;
    private final String hubName;
    private final String hubArn;
    private final String hubContentDisplayName;
    private final String hubContentDescription;
    private final String hubContentMarkdown;
    private final String hubContentDocument;
    private final String sageMakerPublicHubContentArn;
    private final String referenceMinVersion;
    private final String supportStatus;
    private final List<String> hubContentSearchKeywords;
    private final List<HubContentDependency> hubContentDependencies;
    private final String hubContentStatus;
    private final String failureReason;
    private final Instant creationTime;

    private DescribeHubContentResponse(BuilderImpl builder) {
        super(builder);
        this.hubContentName = builder.hubContentName;
        this.hubContentArn = builder.hubContentArn;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentType = builder.hubContentType;
        this.documentSchemaVersion = builder.documentSchemaVersion;
        this.hubName = builder.hubName;
        this.hubArn = builder.hubArn;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.hubContentMarkdown = builder.hubContentMarkdown;
        this.hubContentDocument = builder.hubContentDocument;
        this.sageMakerPublicHubContentArn = builder.sageMakerPublicHubContentArn;
        this.referenceMinVersion = builder.referenceMinVersion;
        this.supportStatus = builder.supportStatus;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.hubContentDependencies = builder.hubContentDependencies;
        this.hubContentStatus = builder.hubContentStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final String hubContentArn() {
        return this.hubContentArn;
    }

    public final String hubContentVersion() {
        return this.hubContentVersion;
    }

    public final HubContentType hubContentType() {
        return HubContentType.fromValue(this.hubContentType);
    }

    public final String hubContentTypeAsString() {
        return this.hubContentType;
    }

    public final String documentSchemaVersion() {
        return this.documentSchemaVersion;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubArn() {
        return this.hubArn;
    }

    public final String hubContentDisplayName() {
        return this.hubContentDisplayName;
    }

    public final String hubContentDescription() {
        return this.hubContentDescription;
    }

    public final String hubContentMarkdown() {
        return this.hubContentMarkdown;
    }

    public final String hubContentDocument() {
        return this.hubContentDocument;
    }

    public final String sageMakerPublicHubContentArn() {
        return this.sageMakerPublicHubContentArn;
    }

    public final String referenceMinVersion() {
        return this.referenceMinVersion;
    }

    public final HubContentSupportStatus supportStatus() {
        return HubContentSupportStatus.fromValue(this.supportStatus);
    }

    public final String supportStatusAsString() {
        return this.supportStatus;
    }

    public final boolean hasHubContentSearchKeywords() {
        return this.hubContentSearchKeywords != null && !(this.hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubContentSearchKeywords() {
        return this.hubContentSearchKeywords;
    }

    public final boolean hasHubContentDependencies() {
        return this.hubContentDependencies != null && !(this.hubContentDependencies instanceof SdkAutoConstructList);
    }

    public final List<HubContentDependency> hubContentDependencies() {
        return this.hubContentDependencies;
    }

    public final HubContentStatus hubContentStatus() {
        return HubContentStatus.fromValue(this.hubContentStatus);
    }

    public final String hubContentStatusAsString() {
        return this.hubContentStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerPublicHubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceMinVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubContentDependencies() ? this.hubContentDependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubContentResponse)) {
            return false;
        }
        DescribeHubContentResponse other = (DescribeHubContentResponse)((Object)obj);
        return Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.hubContentArn(), other.hubContentArn()) && Objects.equals(this.hubContentVersion(), other.hubContentVersion()) && Objects.equals(this.hubContentTypeAsString(), other.hubContentTypeAsString()) && Objects.equals(this.documentSchemaVersion(), other.documentSchemaVersion()) && Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubArn(), other.hubArn()) && Objects.equals(this.hubContentDisplayName(), other.hubContentDisplayName()) && Objects.equals(this.hubContentDescription(), other.hubContentDescription()) && Objects.equals(this.hubContentMarkdown(), other.hubContentMarkdown()) && Objects.equals(this.hubContentDocument(), other.hubContentDocument()) && Objects.equals(this.sageMakerPublicHubContentArn(), other.sageMakerPublicHubContentArn()) && Objects.equals(this.referenceMinVersion(), other.referenceMinVersion()) && Objects.equals(this.supportStatusAsString(), other.supportStatusAsString()) && this.hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords() && Objects.equals(this.hubContentSearchKeywords(), other.hubContentSearchKeywords()) && this.hasHubContentDependencies() == other.hasHubContentDependencies() && Objects.equals(this.hubContentDependencies(), other.hubContentDependencies()) && Objects.equals(this.hubContentStatusAsString(), other.hubContentStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHubContentResponse").add("HubContentName", (Object)this.hubContentName()).add("HubContentArn", (Object)this.hubContentArn()).add("HubContentVersion", (Object)this.hubContentVersion()).add("HubContentType", (Object)this.hubContentTypeAsString()).add("DocumentSchemaVersion", (Object)this.documentSchemaVersion()).add("HubName", (Object)this.hubName()).add("HubArn", (Object)this.hubArn()).add("HubContentDisplayName", (Object)this.hubContentDisplayName()).add("HubContentDescription", (Object)this.hubContentDescription()).add("HubContentMarkdown", (Object)this.hubContentMarkdown()).add("HubContentDocument", (Object)this.hubContentDocument()).add("SageMakerPublicHubContentArn", (Object)this.sageMakerPublicHubContentArn()).add("ReferenceMinVersion", (Object)this.referenceMinVersion()).add("SupportStatus", (Object)this.supportStatusAsString()).add("HubContentSearchKeywords", this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null).add("HubContentDependencies", this.hasHubContentDependencies() ? this.hubContentDependencies() : null).add("HubContentStatus", (Object)this.hubContentStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "HubContentArn": {
                return Optional.ofNullable(clazz.cast(this.hubContentArn()));
            }
            case "HubContentVersion": {
                return Optional.ofNullable(clazz.cast(this.hubContentVersion()));
            }
            case "HubContentType": {
                return Optional.ofNullable(clazz.cast(this.hubContentTypeAsString()));
            }
            case "DocumentSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.documentSchemaVersion()));
            }
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubArn": {
                return Optional.ofNullable(clazz.cast(this.hubArn()));
            }
            case "HubContentDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubContentDisplayName()));
            }
            case "HubContentDescription": {
                return Optional.ofNullable(clazz.cast(this.hubContentDescription()));
            }
            case "HubContentMarkdown": {
                return Optional.ofNullable(clazz.cast(this.hubContentMarkdown()));
            }
            case "HubContentDocument": {
                return Optional.ofNullable(clazz.cast(this.hubContentDocument()));
            }
            case "SageMakerPublicHubContentArn": {
                return Optional.ofNullable(clazz.cast(this.sageMakerPublicHubContentArn()));
            }
            case "ReferenceMinVersion": {
                return Optional.ofNullable(clazz.cast(this.referenceMinVersion()));
            }
            case "SupportStatus": {
                return Optional.ofNullable(clazz.cast(this.supportStatusAsString()));
            }
            case "HubContentSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubContentSearchKeywords()));
            }
            case "HubContentDependencies": {
                return Optional.ofNullable(clazz.cast(this.hubContentDependencies()));
            }
            case "HubContentStatus": {
                return Optional.ofNullable(clazz.cast(this.hubContentStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentArn", HUB_CONTENT_ARN_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("DocumentSchemaVersion", DOCUMENT_SCHEMA_VERSION_FIELD);
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("HubContentDisplayName", HUB_CONTENT_DISPLAY_NAME_FIELD);
        map.put("HubContentDescription", HUB_CONTENT_DESCRIPTION_FIELD);
        map.put("HubContentMarkdown", HUB_CONTENT_MARKDOWN_FIELD);
        map.put("HubContentDocument", HUB_CONTENT_DOCUMENT_FIELD);
        map.put("SageMakerPublicHubContentArn", SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD);
        map.put("ReferenceMinVersion", REFERENCE_MIN_VERSION_FIELD);
        map.put("SupportStatus", SUPPORT_STATUS_FIELD);
        map.put("HubContentSearchKeywords", HUB_CONTENT_SEARCH_KEYWORDS_FIELD);
        map.put("HubContentDependencies", HUB_CONTENT_DEPENDENCIES_FIELD);
        map.put("HubContentStatus", HUB_CONTENT_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubContentResponse, T> g) {
        return obj -> g.apply((DescribeHubContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String hubContentName;
        private String hubContentArn;
        private String hubContentVersion;
        private String hubContentType;
        private String documentSchemaVersion;
        private String hubName;
        private String hubArn;
        private String hubContentDisplayName;
        private String hubContentDescription;
        private String hubContentMarkdown;
        private String hubContentDocument;
        private String sageMakerPublicHubContentArn;
        private String referenceMinVersion;
        private String supportStatus;
        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private List<HubContentDependency> hubContentDependencies = DefaultSdkAutoConstructList.getInstance();
        private String hubContentStatus;
        private String failureReason;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubContentResponse model) {
            super(model);
            this.hubContentName(model.hubContentName);
            this.hubContentArn(model.hubContentArn);
            this.hubContentVersion(model.hubContentVersion);
            this.hubContentType(model.hubContentType);
            this.documentSchemaVersion(model.documentSchemaVersion);
            this.hubName(model.hubName);
            this.hubArn(model.hubArn);
            this.hubContentDisplayName(model.hubContentDisplayName);
            this.hubContentDescription(model.hubContentDescription);
            this.hubContentMarkdown(model.hubContentMarkdown);
            this.hubContentDocument(model.hubContentDocument);
            this.sageMakerPublicHubContentArn(model.sageMakerPublicHubContentArn);
            this.referenceMinVersion(model.referenceMinVersion);
            this.supportStatus(model.supportStatus);
            this.hubContentSearchKeywords(model.hubContentSearchKeywords);
            this.hubContentDependencies(model.hubContentDependencies);
            this.hubContentStatus(model.hubContentStatus);
            this.failureReason(model.failureReason);
            this.creationTime(model.creationTime);
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentArn() {
            return this.hubContentArn;
        }

        public final void setHubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
        }

        @Override
        public final Builder hubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
            return this;
        }

        public final String getHubContentVersion() {
            return this.hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentType() {
            return this.hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getDocumentSchemaVersion() {
            return this.documentSchemaVersion;
        }

        public final void setDocumentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
        }

        @Override
        public final Builder documentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
            return this;
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubArn() {
            return this.hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getHubContentDisplayName() {
            return this.hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return this.hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final String getHubContentMarkdown() {
            return this.hubContentMarkdown;
        }

        public final void setHubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
        }

        @Override
        public final Builder hubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
            return this;
        }

        public final String getHubContentDocument() {
            return this.hubContentDocument;
        }

        public final void setHubContentDocument(String hubContentDocument) {
            this.hubContentDocument = hubContentDocument;
        }

        @Override
        public final Builder hubContentDocument(String hubContentDocument) {
            this.hubContentDocument = hubContentDocument;
            return this;
        }

        public final String getSageMakerPublicHubContentArn() {
            return this.sageMakerPublicHubContentArn;
        }

        public final void setSageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
        }

        @Override
        public final Builder sageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
            return this;
        }

        public final String getReferenceMinVersion() {
            return this.referenceMinVersion;
        }

        public final void setReferenceMinVersion(String referenceMinVersion) {
            this.referenceMinVersion = referenceMinVersion;
        }

        @Override
        public final Builder referenceMinVersion(String referenceMinVersion) {
            this.referenceMinVersion = referenceMinVersion;
            return this;
        }

        public final String getSupportStatus() {
            return this.supportStatus;
        }

        public final void setSupportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
        }

        @Override
        public final Builder supportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
            return this;
        }

        @Override
        public final Builder supportStatus(HubContentSupportStatus supportStatus) {
            this.supportStatus(supportStatus == null ? null : supportStatus.toString());
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (this.hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String ... hubContentSearchKeywords) {
            this.hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final List<HubContentDependency.Builder> getHubContentDependencies() {
            List<HubContentDependency.Builder> result = HubContentDependencyListCopier.copyToBuilder(this.hubContentDependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHubContentDependencies(Collection<HubContentDependency.BuilderImpl> hubContentDependencies) {
            this.hubContentDependencies = HubContentDependencyListCopier.copyFromBuilder(hubContentDependencies);
        }

        @Override
        public final Builder hubContentDependencies(Collection<HubContentDependency> hubContentDependencies) {
            this.hubContentDependencies = HubContentDependencyListCopier.copy(hubContentDependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentDependencies(HubContentDependency ... hubContentDependencies) {
            this.hubContentDependencies(Arrays.asList(hubContentDependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentDependencies(Consumer<HubContentDependency.Builder> ... hubContentDependencies) {
            this.hubContentDependencies(Stream.of(hubContentDependencies).map(c -> (HubContentDependency)((HubContentDependency.Builder)HubContentDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHubContentStatus() {
            return this.hubContentStatus;
        }

        public final void setHubContentStatus(String hubContentStatus) {
            this.hubContentStatus = hubContentStatus;
        }

        @Override
        public final Builder hubContentStatus(String hubContentStatus) {
            this.hubContentStatus = hubContentStatus;
            return this;
        }

        @Override
        public final Builder hubContentStatus(HubContentStatus hubContentStatus) {
            this.hubContentStatus(hubContentStatus == null ? null : hubContentStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeHubContentResponse build() {
            return new DescribeHubContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHubContentResponse> {
        public Builder hubContentName(String var1);

        public Builder hubContentArn(String var1);

        public Builder hubContentVersion(String var1);

        public Builder hubContentType(String var1);

        public Builder hubContentType(HubContentType var1);

        public Builder documentSchemaVersion(String var1);

        public Builder hubName(String var1);

        public Builder hubArn(String var1);

        public Builder hubContentDisplayName(String var1);

        public Builder hubContentDescription(String var1);

        public Builder hubContentMarkdown(String var1);

        public Builder hubContentDocument(String var1);

        public Builder sageMakerPublicHubContentArn(String var1);

        public Builder referenceMinVersion(String var1);

        public Builder supportStatus(String var1);

        public Builder supportStatus(HubContentSupportStatus var1);

        public Builder hubContentSearchKeywords(Collection<String> var1);

        public Builder hubContentSearchKeywords(String ... var1);

        public Builder hubContentDependencies(Collection<HubContentDependency> var1);

        public Builder hubContentDependencies(HubContentDependency ... var1);

        public Builder hubContentDependencies(Consumer<HubContentDependency.Builder> ... var1);

        public Builder hubContentStatus(String var1);

        public Builder hubContentStatus(HubContentStatus var1);

        public Builder failureReason(String var1);

        public Builder creationTime(Instant var1);
    }
}

