/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.CallbackStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.ClarifyCheckStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.ConditionStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.EMRStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.EndpointConfigStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.EndpointStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.FailStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.LambdaStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.ModelStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.QualityCheckStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.RegisterModelStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.TransformJobStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecutionStepMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecutionStepMetadata> {
    private static final SdkField<TrainingJobStepMetadata> TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingJob").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::trainingJob)).setter(PipelineExecutionStepMetadata.setter(Builder::trainingJob)).constructor(TrainingJobStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()}).build();
    private static final SdkField<ProcessingJobStepMetadata> PROCESSING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingJob").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::processingJob)).setter(PipelineExecutionStepMetadata.setter(Builder::processingJob)).constructor(ProcessingJobStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJob").build()}).build();
    private static final SdkField<TransformJobStepMetadata> TRANSFORM_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformJob").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::transformJob)).setter(PipelineExecutionStepMetadata.setter(Builder::transformJob)).constructor(TransformJobStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJob").build()}).build();
    private static final SdkField<TuningJobStepMetaData> TUNING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TuningJob").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::tuningJob)).setter(PipelineExecutionStepMetadata.setter(Builder::tuningJob)).constructor(TuningJobStepMetaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJob").build()}).build();
    private static final SdkField<ModelStepMetadata> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Model").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::model)).setter(PipelineExecutionStepMetadata.setter(Builder::model)).constructor(ModelStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<RegisterModelStepMetadata> REGISTER_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegisterModel").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::registerModel)).setter(PipelineExecutionStepMetadata.setter(Builder::registerModel)).constructor(RegisterModelStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisterModel").build()}).build();
    private static final SdkField<ConditionStepMetadata> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Condition").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::condition)).setter(PipelineExecutionStepMetadata.setter(Builder::condition)).constructor(ConditionStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<CallbackStepMetadata> CALLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Callback").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::callback)).setter(PipelineExecutionStepMetadata.setter(Builder::callback)).constructor(CallbackStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Callback").build()}).build();
    private static final SdkField<LambdaStepMetadata> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lambda").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::lambda)).setter(PipelineExecutionStepMetadata.setter(Builder::lambda)).constructor(LambdaStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lambda").build()}).build();
    private static final SdkField<EMRStepMetadata> EMR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EMR").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::emr)).setter(PipelineExecutionStepMetadata.setter(Builder::emr)).constructor(EMRStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMR").build()}).build();
    private static final SdkField<QualityCheckStepMetadata> QUALITY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QualityCheck").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::qualityCheck)).setter(PipelineExecutionStepMetadata.setter(Builder::qualityCheck)).constructor(QualityCheckStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityCheck").build()}).build();
    private static final SdkField<ClarifyCheckStepMetadata> CLARIFY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClarifyCheck").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::clarifyCheck)).setter(PipelineExecutionStepMetadata.setter(Builder::clarifyCheck)).constructor(ClarifyCheckStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClarifyCheck").build()}).build();
    private static final SdkField<FailStepMetadata> FAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fail").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::fail)).setter(PipelineExecutionStepMetadata.setter(Builder::fail)).constructor(FailStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fail").build()}).build();
    private static final SdkField<AutoMLJobStepMetadata> AUTO_ML_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJob").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::autoMLJob)).setter(PipelineExecutionStepMetadata.setter(Builder::autoMLJob)).constructor(AutoMLJobStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJob").build()}).build();
    private static final SdkField<EndpointStepMetadata> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::endpoint)).setter(PipelineExecutionStepMetadata.setter(Builder::endpoint)).constructor(EndpointStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<EndpointConfigStepMetadata> ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfig").getter(PipelineExecutionStepMetadata.getter(PipelineExecutionStepMetadata::endpointConfig)).setter(PipelineExecutionStepMetadata.setter(Builder::endpointConfig)).constructor(EndpointConfigStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_FIELD, PROCESSING_JOB_FIELD, TRANSFORM_JOB_FIELD, TUNING_JOB_FIELD, MODEL_FIELD, REGISTER_MODEL_FIELD, CONDITION_FIELD, CALLBACK_FIELD, LAMBDA_FIELD, EMR_FIELD, QUALITY_CHECK_FIELD, CLARIFY_CHECK_FIELD, FAIL_FIELD, AUTO_ML_JOB_FIELD, ENDPOINT_FIELD, ENDPOINT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineExecutionStepMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TrainingJobStepMetadata trainingJob;
    private final ProcessingJobStepMetadata processingJob;
    private final TransformJobStepMetadata transformJob;
    private final TuningJobStepMetaData tuningJob;
    private final ModelStepMetadata model;
    private final RegisterModelStepMetadata registerModel;
    private final ConditionStepMetadata condition;
    private final CallbackStepMetadata callback;
    private final LambdaStepMetadata lambda;
    private final EMRStepMetadata emr;
    private final QualityCheckStepMetadata qualityCheck;
    private final ClarifyCheckStepMetadata clarifyCheck;
    private final FailStepMetadata fail;
    private final AutoMLJobStepMetadata autoMLJob;
    private final EndpointStepMetadata endpoint;
    private final EndpointConfigStepMetadata endpointConfig;

    private PipelineExecutionStepMetadata(BuilderImpl builder) {
        this.trainingJob = builder.trainingJob;
        this.processingJob = builder.processingJob;
        this.transformJob = builder.transformJob;
        this.tuningJob = builder.tuningJob;
        this.model = builder.model;
        this.registerModel = builder.registerModel;
        this.condition = builder.condition;
        this.callback = builder.callback;
        this.lambda = builder.lambda;
        this.emr = builder.emr;
        this.qualityCheck = builder.qualityCheck;
        this.clarifyCheck = builder.clarifyCheck;
        this.fail = builder.fail;
        this.autoMLJob = builder.autoMLJob;
        this.endpoint = builder.endpoint;
        this.endpointConfig = builder.endpointConfig;
    }

    public final TrainingJobStepMetadata trainingJob() {
        return this.trainingJob;
    }

    public final ProcessingJobStepMetadata processingJob() {
        return this.processingJob;
    }

    public final TransformJobStepMetadata transformJob() {
        return this.transformJob;
    }

    public final TuningJobStepMetaData tuningJob() {
        return this.tuningJob;
    }

    public final ModelStepMetadata model() {
        return this.model;
    }

    public final RegisterModelStepMetadata registerModel() {
        return this.registerModel;
    }

    public final ConditionStepMetadata condition() {
        return this.condition;
    }

    public final CallbackStepMetadata callback() {
        return this.callback;
    }

    public final LambdaStepMetadata lambda() {
        return this.lambda;
    }

    public final EMRStepMetadata emr() {
        return this.emr;
    }

    public final QualityCheckStepMetadata qualityCheck() {
        return this.qualityCheck;
    }

    public final ClarifyCheckStepMetadata clarifyCheck() {
        return this.clarifyCheck;
    }

    public final FailStepMetadata fail() {
        return this.fail;
    }

    public final AutoMLJobStepMetadata autoMLJob() {
        return this.autoMLJob;
    }

    public final EndpointStepMetadata endpoint() {
        return this.endpoint;
    }

    public final EndpointConfigStepMetadata endpointConfig() {
        return this.endpointConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.callback());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.emr());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.clarifyCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.fail());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionStepMetadata)) {
            return false;
        }
        PipelineExecutionStepMetadata other = (PipelineExecutionStepMetadata)obj;
        return Objects.equals(this.trainingJob(), other.trainingJob()) && Objects.equals(this.processingJob(), other.processingJob()) && Objects.equals(this.transformJob(), other.transformJob()) && Objects.equals(this.tuningJob(), other.tuningJob()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.registerModel(), other.registerModel()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.callback(), other.callback()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.emr(), other.emr()) && Objects.equals(this.qualityCheck(), other.qualityCheck()) && Objects.equals(this.clarifyCheck(), other.clarifyCheck()) && Objects.equals(this.fail(), other.fail()) && Objects.equals(this.autoMLJob(), other.autoMLJob()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.endpointConfig(), other.endpointConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineExecutionStepMetadata").add("TrainingJob", (Object)this.trainingJob()).add("ProcessingJob", (Object)this.processingJob()).add("TransformJob", (Object)this.transformJob()).add("TuningJob", (Object)this.tuningJob()).add("Model", (Object)this.model()).add("RegisterModel", (Object)this.registerModel()).add("Condition", (Object)this.condition()).add("Callback", (Object)this.callback()).add("Lambda", (Object)this.lambda()).add("EMR", (Object)this.emr()).add("QualityCheck", (Object)this.qualityCheck()).add("ClarifyCheck", (Object)this.clarifyCheck()).add("Fail", (Object)this.fail()).add("AutoMLJob", (Object)this.autoMLJob()).add("Endpoint", (Object)this.endpoint()).add("EndpointConfig", (Object)this.endpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJob": {
                return Optional.ofNullable(clazz.cast(this.trainingJob()));
            }
            case "ProcessingJob": {
                return Optional.ofNullable(clazz.cast(this.processingJob()));
            }
            case "TransformJob": {
                return Optional.ofNullable(clazz.cast(this.transformJob()));
            }
            case "TuningJob": {
                return Optional.ofNullable(clazz.cast(this.tuningJob()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "RegisterModel": {
                return Optional.ofNullable(clazz.cast(this.registerModel()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "Callback": {
                return Optional.ofNullable(clazz.cast(this.callback()));
            }
            case "Lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "EMR": {
                return Optional.ofNullable(clazz.cast(this.emr()));
            }
            case "QualityCheck": {
                return Optional.ofNullable(clazz.cast(this.qualityCheck()));
            }
            case "ClarifyCheck": {
                return Optional.ofNullable(clazz.cast(this.clarifyCheck()));
            }
            case "Fail": {
                return Optional.ofNullable(clazz.cast(this.fail()));
            }
            case "AutoMLJob": {
                return Optional.ofNullable(clazz.cast(this.autoMLJob()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "EndpointConfig": {
                return Optional.ofNullable(clazz.cast(this.endpointConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrainingJob", TRAINING_JOB_FIELD);
        map.put("ProcessingJob", PROCESSING_JOB_FIELD);
        map.put("TransformJob", TRANSFORM_JOB_FIELD);
        map.put("TuningJob", TUNING_JOB_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("RegisterModel", REGISTER_MODEL_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("Callback", CALLBACK_FIELD);
        map.put("Lambda", LAMBDA_FIELD);
        map.put("EMR", EMR_FIELD);
        map.put("QualityCheck", QUALITY_CHECK_FIELD);
        map.put("ClarifyCheck", CLARIFY_CHECK_FIELD);
        map.put("Fail", FAIL_FIELD);
        map.put("AutoMLJob", AUTO_ML_JOB_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("EndpointConfig", ENDPOINT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionStepMetadata, T> g) {
        return obj -> g.apply((PipelineExecutionStepMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TrainingJobStepMetadata trainingJob;
        private ProcessingJobStepMetadata processingJob;
        private TransformJobStepMetadata transformJob;
        private TuningJobStepMetaData tuningJob;
        private ModelStepMetadata model;
        private RegisterModelStepMetadata registerModel;
        private ConditionStepMetadata condition;
        private CallbackStepMetadata callback;
        private LambdaStepMetadata lambda;
        private EMRStepMetadata emr;
        private QualityCheckStepMetadata qualityCheck;
        private ClarifyCheckStepMetadata clarifyCheck;
        private FailStepMetadata fail;
        private AutoMLJobStepMetadata autoMLJob;
        private EndpointStepMetadata endpoint;
        private EndpointConfigStepMetadata endpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionStepMetadata model) {
            this.trainingJob(model.trainingJob);
            this.processingJob(model.processingJob);
            this.transformJob(model.transformJob);
            this.tuningJob(model.tuningJob);
            this.model(model.model);
            this.registerModel(model.registerModel);
            this.condition(model.condition);
            this.callback(model.callback);
            this.lambda(model.lambda);
            this.emr(model.emr);
            this.qualityCheck(model.qualityCheck);
            this.clarifyCheck(model.clarifyCheck);
            this.fail(model.fail);
            this.autoMLJob(model.autoMLJob);
            this.endpoint(model.endpoint);
            this.endpointConfig(model.endpointConfig);
        }

        public final TrainingJobStepMetadata.Builder getTrainingJob() {
            return this.trainingJob != null ? this.trainingJob.toBuilder() : null;
        }

        public final void setTrainingJob(TrainingJobStepMetadata.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJobStepMetadata trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final ProcessingJobStepMetadata.Builder getProcessingJob() {
            return this.processingJob != null ? this.processingJob.toBuilder() : null;
        }

        public final void setProcessingJob(ProcessingJobStepMetadata.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        @Override
        public final Builder processingJob(ProcessingJobStepMetadata processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        public final TransformJobStepMetadata.Builder getTransformJob() {
            return this.transformJob != null ? this.transformJob.toBuilder() : null;
        }

        public final void setTransformJob(TransformJobStepMetadata.BuilderImpl transformJob) {
            this.transformJob = transformJob != null ? transformJob.build() : null;
        }

        @Override
        public final Builder transformJob(TransformJobStepMetadata transformJob) {
            this.transformJob = transformJob;
            return this;
        }

        public final TuningJobStepMetaData.Builder getTuningJob() {
            return this.tuningJob != null ? this.tuningJob.toBuilder() : null;
        }

        public final void setTuningJob(TuningJobStepMetaData.BuilderImpl tuningJob) {
            this.tuningJob = tuningJob != null ? tuningJob.build() : null;
        }

        @Override
        public final Builder tuningJob(TuningJobStepMetaData tuningJob) {
            this.tuningJob = tuningJob;
            return this;
        }

        public final ModelStepMetadata.Builder getModel() {
            return this.model != null ? this.model.toBuilder() : null;
        }

        public final void setModel(ModelStepMetadata.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(ModelStepMetadata model) {
            this.model = model;
            return this;
        }

        public final RegisterModelStepMetadata.Builder getRegisterModel() {
            return this.registerModel != null ? this.registerModel.toBuilder() : null;
        }

        public final void setRegisterModel(RegisterModelStepMetadata.BuilderImpl registerModel) {
            this.registerModel = registerModel != null ? registerModel.build() : null;
        }

        @Override
        public final Builder registerModel(RegisterModelStepMetadata registerModel) {
            this.registerModel = registerModel;
            return this;
        }

        public final ConditionStepMetadata.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(ConditionStepMetadata.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(ConditionStepMetadata condition) {
            this.condition = condition;
            return this;
        }

        public final CallbackStepMetadata.Builder getCallback() {
            return this.callback != null ? this.callback.toBuilder() : null;
        }

        public final void setCallback(CallbackStepMetadata.BuilderImpl callback) {
            this.callback = callback != null ? callback.build() : null;
        }

        @Override
        public final Builder callback(CallbackStepMetadata callback) {
            this.callback = callback;
            return this;
        }

        public final LambdaStepMetadata.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaStepMetadata.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaStepMetadata lambda) {
            this.lambda = lambda;
            return this;
        }

        public final EMRStepMetadata.Builder getEmr() {
            return this.emr != null ? this.emr.toBuilder() : null;
        }

        public final void setEmr(EMRStepMetadata.BuilderImpl emr) {
            this.emr = emr != null ? emr.build() : null;
        }

        @Override
        public final Builder emr(EMRStepMetadata emr) {
            this.emr = emr;
            return this;
        }

        public final QualityCheckStepMetadata.Builder getQualityCheck() {
            return this.qualityCheck != null ? this.qualityCheck.toBuilder() : null;
        }

        public final void setQualityCheck(QualityCheckStepMetadata.BuilderImpl qualityCheck) {
            this.qualityCheck = qualityCheck != null ? qualityCheck.build() : null;
        }

        @Override
        public final Builder qualityCheck(QualityCheckStepMetadata qualityCheck) {
            this.qualityCheck = qualityCheck;
            return this;
        }

        public final ClarifyCheckStepMetadata.Builder getClarifyCheck() {
            return this.clarifyCheck != null ? this.clarifyCheck.toBuilder() : null;
        }

        public final void setClarifyCheck(ClarifyCheckStepMetadata.BuilderImpl clarifyCheck) {
            this.clarifyCheck = clarifyCheck != null ? clarifyCheck.build() : null;
        }

        @Override
        public final Builder clarifyCheck(ClarifyCheckStepMetadata clarifyCheck) {
            this.clarifyCheck = clarifyCheck;
            return this;
        }

        public final FailStepMetadata.Builder getFail() {
            return this.fail != null ? this.fail.toBuilder() : null;
        }

        public final void setFail(FailStepMetadata.BuilderImpl fail) {
            this.fail = fail != null ? fail.build() : null;
        }

        @Override
        public final Builder fail(FailStepMetadata fail) {
            this.fail = fail;
            return this;
        }

        public final AutoMLJobStepMetadata.Builder getAutoMLJob() {
            return this.autoMLJob != null ? this.autoMLJob.toBuilder() : null;
        }

        public final void setAutoMLJob(AutoMLJobStepMetadata.BuilderImpl autoMLJob) {
            this.autoMLJob = autoMLJob != null ? autoMLJob.build() : null;
        }

        @Override
        public final Builder autoMLJob(AutoMLJobStepMetadata autoMLJob) {
            this.autoMLJob = autoMLJob;
            return this;
        }

        public final EndpointStepMetadata.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(EndpointStepMetadata.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(EndpointStepMetadata endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final EndpointConfigStepMetadata.Builder getEndpointConfig() {
            return this.endpointConfig != null ? this.endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfigStepMetadata.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfigStepMetadata endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public PipelineExecutionStepMetadata build() {
            return new PipelineExecutionStepMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecutionStepMetadata> {
        public Builder trainingJob(TrainingJobStepMetadata var1);

        default public Builder trainingJob(Consumer<TrainingJobStepMetadata.Builder> trainingJob) {
            return this.trainingJob((TrainingJobStepMetadata)((TrainingJobStepMetadata.Builder)TrainingJobStepMetadata.builder().applyMutation(trainingJob)).build());
        }

        public Builder processingJob(ProcessingJobStepMetadata var1);

        default public Builder processingJob(Consumer<ProcessingJobStepMetadata.Builder> processingJob) {
            return this.processingJob((ProcessingJobStepMetadata)((ProcessingJobStepMetadata.Builder)ProcessingJobStepMetadata.builder().applyMutation(processingJob)).build());
        }

        public Builder transformJob(TransformJobStepMetadata var1);

        default public Builder transformJob(Consumer<TransformJobStepMetadata.Builder> transformJob) {
            return this.transformJob((TransformJobStepMetadata)((TransformJobStepMetadata.Builder)TransformJobStepMetadata.builder().applyMutation(transformJob)).build());
        }

        public Builder tuningJob(TuningJobStepMetaData var1);

        default public Builder tuningJob(Consumer<TuningJobStepMetaData.Builder> tuningJob) {
            return this.tuningJob((TuningJobStepMetaData)((TuningJobStepMetaData.Builder)TuningJobStepMetaData.builder().applyMutation(tuningJob)).build());
        }

        public Builder model(ModelStepMetadata var1);

        default public Builder model(Consumer<ModelStepMetadata.Builder> model) {
            return this.model((ModelStepMetadata)((ModelStepMetadata.Builder)ModelStepMetadata.builder().applyMutation(model)).build());
        }

        public Builder registerModel(RegisterModelStepMetadata var1);

        default public Builder registerModel(Consumer<RegisterModelStepMetadata.Builder> registerModel) {
            return this.registerModel((RegisterModelStepMetadata)((RegisterModelStepMetadata.Builder)RegisterModelStepMetadata.builder().applyMutation(registerModel)).build());
        }

        public Builder condition(ConditionStepMetadata var1);

        default public Builder condition(Consumer<ConditionStepMetadata.Builder> condition) {
            return this.condition((ConditionStepMetadata)((ConditionStepMetadata.Builder)ConditionStepMetadata.builder().applyMutation(condition)).build());
        }

        public Builder callback(CallbackStepMetadata var1);

        default public Builder callback(Consumer<CallbackStepMetadata.Builder> callback) {
            return this.callback((CallbackStepMetadata)((CallbackStepMetadata.Builder)CallbackStepMetadata.builder().applyMutation(callback)).build());
        }

        public Builder lambda(LambdaStepMetadata var1);

        default public Builder lambda(Consumer<LambdaStepMetadata.Builder> lambda) {
            return this.lambda((LambdaStepMetadata)((LambdaStepMetadata.Builder)LambdaStepMetadata.builder().applyMutation(lambda)).build());
        }

        public Builder emr(EMRStepMetadata var1);

        default public Builder emr(Consumer<EMRStepMetadata.Builder> emr) {
            return this.emr((EMRStepMetadata)((EMRStepMetadata.Builder)EMRStepMetadata.builder().applyMutation(emr)).build());
        }

        public Builder qualityCheck(QualityCheckStepMetadata var1);

        default public Builder qualityCheck(Consumer<QualityCheckStepMetadata.Builder> qualityCheck) {
            return this.qualityCheck((QualityCheckStepMetadata)((QualityCheckStepMetadata.Builder)QualityCheckStepMetadata.builder().applyMutation(qualityCheck)).build());
        }

        public Builder clarifyCheck(ClarifyCheckStepMetadata var1);

        default public Builder clarifyCheck(Consumer<ClarifyCheckStepMetadata.Builder> clarifyCheck) {
            return this.clarifyCheck((ClarifyCheckStepMetadata)((ClarifyCheckStepMetadata.Builder)ClarifyCheckStepMetadata.builder().applyMutation(clarifyCheck)).build());
        }

        public Builder fail(FailStepMetadata var1);

        default public Builder fail(Consumer<FailStepMetadata.Builder> fail) {
            return this.fail((FailStepMetadata)((FailStepMetadata.Builder)FailStepMetadata.builder().applyMutation(fail)).build());
        }

        public Builder autoMLJob(AutoMLJobStepMetadata var1);

        default public Builder autoMLJob(Consumer<AutoMLJobStepMetadata.Builder> autoMLJob) {
            return this.autoMLJob((AutoMLJobStepMetadata)((AutoMLJobStepMetadata.Builder)AutoMLJobStepMetadata.builder().applyMutation(autoMLJob)).build());
        }

        public Builder endpoint(EndpointStepMetadata var1);

        default public Builder endpoint(Consumer<EndpointStepMetadata.Builder> endpoint) {
            return this.endpoint((EndpointStepMetadata)((EndpointStepMetadata.Builder)EndpointStepMetadata.builder().applyMutation(endpoint)).build());
        }

        public Builder endpointConfig(EndpointConfigStepMetadata var1);

        default public Builder endpointConfig(Consumer<EndpointConfigStepMetadata.Builder> endpointConfig) {
            return this.endpointConfig((EndpointConfigStepMetadata)((EndpointConfigStepMetadata.Builder)EndpointConfigStepMetadata.builder().applyMutation(endpointConfig)).build());
        }
    }
}

