/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataQualityJobDefinitionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateDataQualityJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionName").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::jobDefinitionName)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()}).build();
    private static final SdkField<DataQualityBaselineConfig> DATA_QUALITY_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityBaselineConfig").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::dataQualityBaselineConfig)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::dataQualityBaselineConfig)).constructor(DataQualityBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityBaselineConfig").build()}).build();
    private static final SdkField<DataQualityAppSpecification> DATA_QUALITY_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityAppSpecification").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::dataQualityAppSpecification)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::dataQualityAppSpecification)).constructor(DataQualityAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityAppSpecification").build()}).build();
    private static final SdkField<DataQualityJobInput> DATA_QUALITY_JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityJobInput").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::dataQualityJobInput)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::dataQualityJobInput)).constructor(DataQualityJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityJobInput").build()}).build();
    private static final SdkField<MonitoringOutputConfig> DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityJobOutputConfig").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::dataQualityJobOutputConfig)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::dataQualityJobOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityJobOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobResources").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::jobResources)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::jobResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()}).build();
    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::networkConfig)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::networkConfig)).constructor(MonitoringNetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::roleArn)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::stoppingCondition)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDataQualityJobDefinitionRequest.getter(CreateDataQualityJobDefinitionRequest::tags)).setter(CreateDataQualityJobDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD, DATA_QUALITY_BASELINE_CONFIG_FIELD, DATA_QUALITY_APP_SPECIFICATION_FIELD, DATA_QUALITY_JOB_INPUT_FIELD, DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataQualityJobDefinitionRequest.memberNameToFieldInitializer();
    private final String jobDefinitionName;
    private final DataQualityBaselineConfig dataQualityBaselineConfig;
    private final DataQualityAppSpecification dataQualityAppSpecification;
    private final DataQualityJobInput dataQualityJobInput;
    private final MonitoringOutputConfig dataQualityJobOutputConfig;
    private final MonitoringResources jobResources;
    private final MonitoringNetworkConfig networkConfig;
    private final String roleArn;
    private final MonitoringStoppingCondition stoppingCondition;
    private final List<Tag> tags;

    private CreateDataQualityJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.dataQualityBaselineConfig = builder.dataQualityBaselineConfig;
        this.dataQualityAppSpecification = builder.dataQualityAppSpecification;
        this.dataQualityJobInput = builder.dataQualityJobInput;
        this.dataQualityJobOutputConfig = builder.dataQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    public final String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public final DataQualityBaselineConfig dataQualityBaselineConfig() {
        return this.dataQualityBaselineConfig;
    }

    public final DataQualityAppSpecification dataQualityAppSpecification() {
        return this.dataQualityAppSpecification;
    }

    public final DataQualityJobInput dataQualityJobInput() {
        return this.dataQualityJobInput;
    }

    public final MonitoringOutputConfig dataQualityJobOutputConfig() {
        return this.dataQualityJobOutputConfig;
    }

    public final MonitoringResources jobResources() {
        return this.jobResources;
    }

    public final MonitoringNetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataQualityJobDefinitionRequest)) {
            return false;
        }
        CreateDataQualityJobDefinitionRequest other = (CreateDataQualityJobDefinitionRequest)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.dataQualityBaselineConfig(), other.dataQualityBaselineConfig()) && Objects.equals(this.dataQualityAppSpecification(), other.dataQualityAppSpecification()) && Objects.equals(this.dataQualityJobInput(), other.dataQualityJobInput()) && Objects.equals(this.dataQualityJobOutputConfig(), other.dataQualityJobOutputConfig()) && Objects.equals(this.jobResources(), other.jobResources()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataQualityJobDefinitionRequest").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("DataQualityBaselineConfig", (Object)this.dataQualityBaselineConfig()).add("DataQualityAppSpecification", (Object)this.dataQualityAppSpecification()).add("DataQualityJobInput", (Object)this.dataQualityJobInput()).add("DataQualityJobOutputConfig", (Object)this.dataQualityJobOutputConfig()).add("JobResources", (Object)this.jobResources()).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "DataQualityBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.dataQualityBaselineConfig()));
            }
            case "DataQualityAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.dataQualityAppSpecification()));
            }
            case "DataQualityJobInput": {
                return Optional.ofNullable(clazz.cast(this.dataQualityJobInput()));
            }
            case "DataQualityJobOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.dataQualityJobOutputConfig()));
            }
            case "JobResources": {
                return Optional.ofNullable(clazz.cast(this.jobResources()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobDefinitionName", JOB_DEFINITION_NAME_FIELD);
        map.put("DataQualityBaselineConfig", DATA_QUALITY_BASELINE_CONFIG_FIELD);
        map.put("DataQualityAppSpecification", DATA_QUALITY_APP_SPECIFICATION_FIELD);
        map.put("DataQualityJobInput", DATA_QUALITY_JOB_INPUT_FIELD);
        map.put("DataQualityJobOutputConfig", DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD);
        map.put("JobResources", JOB_RESOURCES_FIELD);
        map.put("NetworkConfig", NETWORK_CONFIG_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("StoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataQualityJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateDataQualityJobDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private DataQualityBaselineConfig dataQualityBaselineConfig;
        private DataQualityAppSpecification dataQualityAppSpecification;
        private DataQualityJobInput dataQualityJobInput;
        private MonitoringOutputConfig dataQualityJobOutputConfig;
        private MonitoringResources jobResources;
        private MonitoringNetworkConfig networkConfig;
        private String roleArn;
        private MonitoringStoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataQualityJobDefinitionRequest model) {
            super(model);
            this.jobDefinitionName(model.jobDefinitionName);
            this.dataQualityBaselineConfig(model.dataQualityBaselineConfig);
            this.dataQualityAppSpecification(model.dataQualityAppSpecification);
            this.dataQualityJobInput(model.dataQualityJobInput);
            this.dataQualityJobOutputConfig(model.dataQualityJobOutputConfig);
            this.jobResources(model.jobResources);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final DataQualityBaselineConfig.Builder getDataQualityBaselineConfig() {
            return this.dataQualityBaselineConfig != null ? this.dataQualityBaselineConfig.toBuilder() : null;
        }

        public final void setDataQualityBaselineConfig(DataQualityBaselineConfig.BuilderImpl dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig != null ? dataQualityBaselineConfig.build() : null;
        }

        @Override
        public final Builder dataQualityBaselineConfig(DataQualityBaselineConfig dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig;
            return this;
        }

        public final DataQualityAppSpecification.Builder getDataQualityAppSpecification() {
            return this.dataQualityAppSpecification != null ? this.dataQualityAppSpecification.toBuilder() : null;
        }

        public final void setDataQualityAppSpecification(DataQualityAppSpecification.BuilderImpl dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification != null ? dataQualityAppSpecification.build() : null;
        }

        @Override
        public final Builder dataQualityAppSpecification(DataQualityAppSpecification dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification;
            return this;
        }

        public final DataQualityJobInput.Builder getDataQualityJobInput() {
            return this.dataQualityJobInput != null ? this.dataQualityJobInput.toBuilder() : null;
        }

        public final void setDataQualityJobInput(DataQualityJobInput.BuilderImpl dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput != null ? dataQualityJobInput.build() : null;
        }

        @Override
        public final Builder dataQualityJobInput(DataQualityJobInput dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getDataQualityJobOutputConfig() {
            return this.dataQualityJobOutputConfig != null ? this.dataQualityJobOutputConfig.toBuilder() : null;
        }

        public final void setDataQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig != null ? dataQualityJobOutputConfig.build() : null;
        }

        @Override
        public final Builder dataQualityJobOutputConfig(MonitoringOutputConfig dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return this.jobResources != null ? this.jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataQualityJobDefinitionRequest build() {
            return new CreateDataQualityJobDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataQualityJobDefinitionRequest> {
        public Builder jobDefinitionName(String var1);

        public Builder dataQualityBaselineConfig(DataQualityBaselineConfig var1);

        default public Builder dataQualityBaselineConfig(Consumer<DataQualityBaselineConfig.Builder> dataQualityBaselineConfig) {
            return this.dataQualityBaselineConfig((DataQualityBaselineConfig)((DataQualityBaselineConfig.Builder)DataQualityBaselineConfig.builder().applyMutation(dataQualityBaselineConfig)).build());
        }

        public Builder dataQualityAppSpecification(DataQualityAppSpecification var1);

        default public Builder dataQualityAppSpecification(Consumer<DataQualityAppSpecification.Builder> dataQualityAppSpecification) {
            return this.dataQualityAppSpecification((DataQualityAppSpecification)((DataQualityAppSpecification.Builder)DataQualityAppSpecification.builder().applyMutation(dataQualityAppSpecification)).build());
        }

        public Builder dataQualityJobInput(DataQualityJobInput var1);

        default public Builder dataQualityJobInput(Consumer<DataQualityJobInput.Builder> dataQualityJobInput) {
            return this.dataQualityJobInput((DataQualityJobInput)((DataQualityJobInput.Builder)DataQualityJobInput.builder().applyMutation(dataQualityJobInput)).build());
        }

        public Builder dataQualityJobOutputConfig(MonitoringOutputConfig var1);

        default public Builder dataQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> dataQualityJobOutputConfig) {
            return this.dataQualityJobOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(dataQualityJobOutputConfig)).build());
        }

        public Builder jobResources(MonitoringResources var1);

        default public Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return this.jobResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(jobResources)).build());
        }

        public Builder networkConfig(MonitoringNetworkConfig var1);

        default public Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return this.networkConfig((MonitoringNetworkConfig)((MonitoringNetworkConfig.Builder)MonitoringNetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

