/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;

public class ListEndpointConfigsPublisher
implements SdkPublisher<ListEndpointConfigsResponse> {
    private final SageMakerAsyncClient client;
    private final ListEndpointConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEndpointConfigsPublisher(SageMakerAsyncClient client, ListEndpointConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEndpointConfigsPublisher(SageMakerAsyncClient client, ListEndpointConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEndpointConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEndpointConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListEndpointConfigsPublisher resume(ListEndpointConfigsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEndpointConfigsPublisher(this.client, (ListEndpointConfigsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEndpointConfigsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListEndpointConfigsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListEndpointConfigsResponseFetcher
    implements AsyncPageFetcher<ListEndpointConfigsResponse> {
        private ListEndpointConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEndpointConfigsResponse> nextPage(ListEndpointConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointConfigsPublisher.this.client.listEndpointConfigs(ListEndpointConfigsPublisher.this.firstRequest);
            }
            return ListEndpointConfigsPublisher.this.client.listEndpointConfigs((ListEndpointConfigsRequest)((Object)ListEndpointConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

