/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;

public class ListLabelingJobsIterable
implements SdkIterable<ListLabelingJobsResponse> {
    private final SageMakerClient client;
    private final ListLabelingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLabelingJobsIterable(SageMakerClient client, ListLabelingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLabelingJobsResponseFetcher();
    }

    public Iterator<ListLabelingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListLabelingJobsIterable resume(ListLabelingJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListLabelingJobsIterable(this.client, (ListLabelingJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListLabelingJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListLabelingJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListLabelingJobsResponseFetcher
    implements SyncPageFetcher<ListLabelingJobsResponse> {
        private ListLabelingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLabelingJobsResponse nextPage(ListLabelingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelingJobsIterable.this.client.listLabelingJobs(ListLabelingJobsIterable.this.firstRequest);
            }
            return ListLabelingJobsIterable.this.client.listLabelingJobs((ListLabelingJobsRequest)((Object)ListLabelingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

