/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelLifeCycle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelLifeCycle> {
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(ModelLifeCycle.getter(ModelLifeCycle::stage)).setter(ModelLifeCycle.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final SdkField<String> STAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageStatus").getter(ModelLifeCycle.getter(ModelLifeCycle::stageStatus)).setter(ModelLifeCycle.setter(Builder::stageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageStatus").build()}).build();
    private static final SdkField<String> STAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageDescription").getter(ModelLifeCycle.getter(ModelLifeCycle::stageDescription)).setter(ModelLifeCycle.setter(Builder::stageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD, STAGE_STATUS_FIELD, STAGE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stage;
    private final String stageStatus;
    private final String stageDescription;

    private ModelLifeCycle(BuilderImpl builder) {
        this.stage = builder.stage;
        this.stageStatus = builder.stageStatus;
        this.stageDescription = builder.stageDescription;
    }

    public final String stage() {
        return this.stage;
    }

    public final String stageStatus() {
        return this.stageStatus;
    }

    public final String stageDescription() {
        return this.stageDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelLifeCycle)) {
            return false;
        }
        ModelLifeCycle other = (ModelLifeCycle)obj;
        return Objects.equals(this.stage(), other.stage()) && Objects.equals(this.stageStatus(), other.stageStatus()) && Objects.equals(this.stageDescription(), other.stageDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ModelLifeCycle").add("Stage", (Object)this.stage()).add("StageStatus", (Object)this.stageStatus()).add("StageDescription", (Object)this.stageDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "StageStatus": {
                return Optional.ofNullable(clazz.cast(this.stageStatus()));
            }
            case "StageDescription": {
                return Optional.ofNullable(clazz.cast(this.stageDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelLifeCycle, T> g) {
        return obj -> g.apply((ModelLifeCycle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stage;
        private String stageStatus;
        private String stageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelLifeCycle model) {
            this.stage(model.stage);
            this.stageStatus(model.stageStatus);
            this.stageDescription(model.stageDescription);
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final String getStageStatus() {
            return this.stageStatus;
        }

        public final void setStageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
        }

        @Override
        public final Builder stageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
            return this;
        }

        public final String getStageDescription() {
            return this.stageDescription;
        }

        public final void setStageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
        }

        @Override
        public final Builder stageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
            return this;
        }

        public ModelLifeCycle build() {
            return new ModelLifeCycle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelLifeCycle> {
        public Builder stage(String var1);

        public Builder stageStatus(String var1);

        public Builder stageDescription(String var1);
    }
}

