/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelDataSource;
import software.amazon.awssdk.services.sagemaker.model.ModelInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageContainerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageContainerDefinition> {
    private static final SdkField<String> CONTAINER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerHostname").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::containerHostname)).setter(ModelPackageContainerDefinition.setter(Builder::containerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerHostname").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::image)).setter(ModelPackageContainerDefinition.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageDigest").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::imageDigest)).setter(ModelPackageContainerDefinition.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDigest").build()}).build();
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelDataUrl").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::modelDataUrl)).setter(ModelPackageContainerDefinition.setter(Builder::modelDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDataSource").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::modelDataSource)).setter(ModelPackageContainerDefinition.setter(Builder::modelDataSource)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataSource").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::productId)).setter(ModelPackageContainerDefinition.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::environment)).setter(ModelPackageContainerDefinition.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ModelInput> MODEL_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelInput").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::modelInput)).setter(ModelPackageContainerDefinition.setter(Builder::modelInput)).constructor(ModelInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelInput").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Framework").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::framework)).setter(ModelPackageContainerDefinition.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkVersion").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::frameworkVersion)).setter(ModelPackageContainerDefinition.setter(Builder::frameworkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()}).build();
    private static final SdkField<String> NEAREST_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NearestModelName").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::nearestModelName)).setter(ModelPackageContainerDefinition.setter(Builder::nearestModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NearestModelName").build()}).build();
    private static final SdkField<AdditionalS3DataSource> ADDITIONAL_S3_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalS3DataSource").getter(ModelPackageContainerDefinition.getter(ModelPackageContainerDefinition::additionalS3DataSource)).setter(ModelPackageContainerDefinition.setter(Builder::additionalS3DataSource)).constructor(AdditionalS3DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalS3DataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_HOSTNAME_FIELD, IMAGE_FIELD, IMAGE_DIGEST_FIELD, MODEL_DATA_URL_FIELD, MODEL_DATA_SOURCE_FIELD, PRODUCT_ID_FIELD, ENVIRONMENT_FIELD, MODEL_INPUT_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, NEAREST_MODEL_NAME_FIELD, ADDITIONAL_S3_DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelPackageContainerDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerHostname;
    private final String image;
    private final String imageDigest;
    private final String modelDataUrl;
    private final ModelDataSource modelDataSource;
    private final String productId;
    private final Map<String, String> environment;
    private final ModelInput modelInput;
    private final String framework;
    private final String frameworkVersion;
    private final String nearestModelName;
    private final AdditionalS3DataSource additionalS3DataSource;

    private ModelPackageContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.imageDigest = builder.imageDigest;
        this.modelDataUrl = builder.modelDataUrl;
        this.modelDataSource = builder.modelDataSource;
        this.productId = builder.productId;
        this.environment = builder.environment;
        this.modelInput = builder.modelInput;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.nearestModelName = builder.nearestModelName;
        this.additionalS3DataSource = builder.additionalS3DataSource;
    }

    public final String containerHostname() {
        return this.containerHostname;
    }

    public final String image() {
        return this.image;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final String modelDataUrl() {
        return this.modelDataUrl;
    }

    public final ModelDataSource modelDataSource() {
        return this.modelDataSource;
    }

    public final String productId() {
        return this.productId;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final ModelInput modelInput() {
        return this.modelInput;
    }

    public final String framework() {
        return this.framework;
    }

    public final String frameworkVersion() {
        return this.frameworkVersion;
    }

    public final String nearestModelName() {
        return this.nearestModelName;
    }

    public final AdditionalS3DataSource additionalS3DataSource() {
        return this.additionalS3DataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nearestModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalS3DataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageContainerDefinition)) {
            return false;
        }
        ModelPackageContainerDefinition other = (ModelPackageContainerDefinition)obj;
        return Objects.equals(this.containerHostname(), other.containerHostname()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.modelDataSource(), other.modelDataSource()) && Objects.equals(this.productId(), other.productId()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.modelInput(), other.modelInput()) && Objects.equals(this.framework(), other.framework()) && Objects.equals(this.frameworkVersion(), other.frameworkVersion()) && Objects.equals(this.nearestModelName(), other.nearestModelName()) && Objects.equals(this.additionalS3DataSource(), other.additionalS3DataSource());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackageContainerDefinition").add("ContainerHostname", (Object)this.containerHostname()).add("Image", (Object)this.image()).add("ImageDigest", (Object)this.imageDigest()).add("ModelDataUrl", (Object)this.modelDataUrl()).add("ModelDataSource", (Object)this.modelDataSource()).add("ProductId", (Object)this.productId()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("ModelInput", (Object)this.modelInput()).add("Framework", (Object)this.framework()).add("FrameworkVersion", (Object)this.frameworkVersion()).add("NearestModelName", (Object)this.nearestModelName()).add("AdditionalS3DataSource", (Object)this.additionalS3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerHostname": {
                return Optional.ofNullable(clazz.cast(this.containerHostname()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ImageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "ModelDataUrl": {
                return Optional.ofNullable(clazz.cast(this.modelDataUrl()));
            }
            case "ModelDataSource": {
                return Optional.ofNullable(clazz.cast(this.modelDataSource()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "ModelInput": {
                return Optional.ofNullable(clazz.cast(this.modelInput()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "FrameworkVersion": {
                return Optional.ofNullable(clazz.cast(this.frameworkVersion()));
            }
            case "NearestModelName": {
                return Optional.ofNullable(clazz.cast(this.nearestModelName()));
            }
            case "AdditionalS3DataSource": {
                return Optional.ofNullable(clazz.cast(this.additionalS3DataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerHostname", CONTAINER_HOSTNAME_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("ImageDigest", IMAGE_DIGEST_FIELD);
        map.put("ModelDataUrl", MODEL_DATA_URL_FIELD);
        map.put("ModelDataSource", MODEL_DATA_SOURCE_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("ModelInput", MODEL_INPUT_FIELD);
        map.put("Framework", FRAMEWORK_FIELD);
        map.put("FrameworkVersion", FRAMEWORK_VERSION_FIELD);
        map.put("NearestModelName", NEAREST_MODEL_NAME_FIELD);
        map.put("AdditionalS3DataSource", ADDITIONAL_S3_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageContainerDefinition, T> g) {
        return obj -> g.apply((ModelPackageContainerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerHostname;
        private String image;
        private String imageDigest;
        private String modelDataUrl;
        private ModelDataSource modelDataSource;
        private String productId;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private ModelInput modelInput;
        private String framework;
        private String frameworkVersion;
        private String nearestModelName;
        private AdditionalS3DataSource additionalS3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageContainerDefinition model) {
            this.containerHostname(model.containerHostname);
            this.image(model.image);
            this.imageDigest(model.imageDigest);
            this.modelDataUrl(model.modelDataUrl);
            this.modelDataSource(model.modelDataSource);
            this.productId(model.productId);
            this.environment(model.environment);
            this.modelInput(model.modelInput);
            this.framework(model.framework);
            this.frameworkVersion(model.frameworkVersion);
            this.nearestModelName(model.nearestModelName);
            this.additionalS3DataSource(model.additionalS3DataSource);
        }

        public final String getContainerHostname() {
            return this.containerHostname;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return this.modelDataSource != null ? this.modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        public final ModelInput.Builder getModelInput() {
            return this.modelInput != null ? this.modelInput.toBuilder() : null;
        }

        public final void setModelInput(ModelInput.BuilderImpl modelInput) {
            this.modelInput = modelInput != null ? modelInput.build() : null;
        }

        @Override
        public final Builder modelInput(ModelInput modelInput) {
            this.modelInput = modelInput;
            return this;
        }

        public final String getFramework() {
            return this.framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getFrameworkVersion() {
            return this.frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final String getNearestModelName() {
            return this.nearestModelName;
        }

        public final void setNearestModelName(String nearestModelName) {
            this.nearestModelName = nearestModelName;
        }

        @Override
        public final Builder nearestModelName(String nearestModelName) {
            this.nearestModelName = nearestModelName;
            return this;
        }

        public final AdditionalS3DataSource.Builder getAdditionalS3DataSource() {
            return this.additionalS3DataSource != null ? this.additionalS3DataSource.toBuilder() : null;
        }

        public final void setAdditionalS3DataSource(AdditionalS3DataSource.BuilderImpl additionalS3DataSource) {
            this.additionalS3DataSource = additionalS3DataSource != null ? additionalS3DataSource.build() : null;
        }

        @Override
        public final Builder additionalS3DataSource(AdditionalS3DataSource additionalS3DataSource) {
            this.additionalS3DataSource = additionalS3DataSource;
            return this;
        }

        public ModelPackageContainerDefinition build() {
            return new ModelPackageContainerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageContainerDefinition> {
        public Builder containerHostname(String var1);

        public Builder image(String var1);

        public Builder imageDigest(String var1);

        public Builder modelDataUrl(String var1);

        public Builder modelDataSource(ModelDataSource var1);

        default public Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return this.modelDataSource((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelDataSource)).build());
        }

        public Builder productId(String var1);

        public Builder environment(Map<String, String> var1);

        public Builder modelInput(ModelInput var1);

        default public Builder modelInput(Consumer<ModelInput.Builder> modelInput) {
            return this.modelInput((ModelInput)((ModelInput.Builder)ModelInput.builder().applyMutation(modelInput)).build());
        }

        public Builder framework(String var1);

        public Builder frameworkVersion(String var1);

        public Builder nearestModelName(String var1);

        public Builder additionalS3DataSource(AdditionalS3DataSource var1);

        default public Builder additionalS3DataSource(Consumer<AdditionalS3DataSource.Builder> additionalS3DataSource) {
            return this.additionalS3DataSource((AdditionalS3DataSource)((AdditionalS3DataSource.Builder)AdditionalS3DataSource.builder().applyMutation(additionalS3DataSource)).build());
        }
    }
}

