/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLMetricEnum {
    ACCURACY("Accuracy"),
    MSE("MSE"),
    F1("F1"),
    F1_MACRO("F1macro"),
    AUC("AUC"),
    RMSE("RMSE"),
    BALANCED_ACCURACY("BalancedAccuracy"),
    R2("R2"),
    RECALL("Recall"),
    RECALL_MACRO("RecallMacro"),
    PRECISION("Precision"),
    PRECISION_MACRO("PrecisionMacro"),
    MAE("MAE"),
    MAPE("MAPE"),
    MASE("MASE"),
    WAPE("WAPE"),
    AVERAGE_WEIGHTED_QUANTILE_LOSS("AverageWeightedQuantileLoss"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLMetricEnum> VALUE_MAP;
    private final String value;

    private AutoMLMetricEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLMetricEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLMetricEnum> knownValues() {
        EnumSet<AutoMLMetricEnum> knownValues = EnumSet.allOf(AutoMLMetricEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLMetricEnum.class, AutoMLMetricEnum::toString);
    }
}

