/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.OptimizationConfig;
import software.amazon.awssdk.services.sagemaker.model.OptimizationConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobDeploymentInstanceType;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobEnvironmentVariablesCopier;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobModelSource;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.OptimizationOutput;
import software.amazon.awssdk.services.sagemaker.model.OptimizationVpcConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptimizationJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeOptimizationJobResponse> {
    private static final SdkField<String> OPTIMIZATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobArn").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationJobArn)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobArn").build()}).build();
    private static final SdkField<String> OPTIMIZATION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobStatus").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationJobStatusAsString)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobStatus").build()}).build();
    private static final SdkField<Instant> OPTIMIZATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OptimizationStartTime").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationStartTime)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationStartTime").build()}).build();
    private static final SdkField<Instant> OPTIMIZATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OptimizationEndTime").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationEndTime)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEndTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::creationTime)).setter(DescribeOptimizationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::lastModifiedTime)).setter(DescribeOptimizationJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::failureReason)).setter(DescribeOptimizationJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobName").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationJobName)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build()}).build();
    private static final SdkField<OptimizationJobModelSource> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelSource").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::modelSource)).setter(DescribeOptimizationJobResponse.setter(Builder::modelSource)).constructor(OptimizationJobModelSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSource").build()}).build();
    private static final SdkField<Map<String, String>> OPTIMIZATION_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OptimizationEnvironment").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationEnvironment)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEnvironment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEPLOYMENT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentInstanceType").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::deploymentInstanceTypeAsString)).setter(DescribeOptimizationJobResponse.setter(Builder::deploymentInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentInstanceType").build()}).build();
    private static final SdkField<List<OptimizationConfig>> OPTIMIZATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptimizationConfigs").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationConfigs)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptimizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OptimizationJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::outputConfig)).setter(DescribeOptimizationJobResponse.setter(Builder::outputConfig)).constructor(OptimizationJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<OptimizationOutput> OPTIMIZATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OptimizationOutput").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::optimizationOutput)).setter(DescribeOptimizationJobResponse.setter(Builder::optimizationOutput)).constructor(OptimizationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationOutput").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::roleArn)).setter(DescribeOptimizationJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::stoppingCondition)).setter(DescribeOptimizationJobResponse.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<OptimizationVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(DescribeOptimizationJobResponse.getter(DescribeOptimizationJobResponse::vpcConfig)).setter(DescribeOptimizationJobResponse.setter(Builder::vpcConfig)).constructor(OptimizationVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_ARN_FIELD, OPTIMIZATION_JOB_STATUS_FIELD, OPTIMIZATION_START_TIME_FIELD, OPTIMIZATION_END_TIME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, OPTIMIZATION_JOB_NAME_FIELD, MODEL_SOURCE_FIELD, OPTIMIZATION_ENVIRONMENT_FIELD, DEPLOYMENT_INSTANCE_TYPE_FIELD, OPTIMIZATION_CONFIGS_FIELD, OUTPUT_CONFIG_FIELD, OPTIMIZATION_OUTPUT_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, VPC_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OptimizationJobArn", OPTIMIZATION_JOB_ARN_FIELD);
            this.put("OptimizationJobStatus", OPTIMIZATION_JOB_STATUS_FIELD);
            this.put("OptimizationStartTime", OPTIMIZATION_START_TIME_FIELD);
            this.put("OptimizationEndTime", OPTIMIZATION_END_TIME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("OptimizationJobName", OPTIMIZATION_JOB_NAME_FIELD);
            this.put("ModelSource", MODEL_SOURCE_FIELD);
            this.put("OptimizationEnvironment", OPTIMIZATION_ENVIRONMENT_FIELD);
            this.put("DeploymentInstanceType", DEPLOYMENT_INSTANCE_TYPE_FIELD);
            this.put("OptimizationConfigs", OPTIMIZATION_CONFIGS_FIELD);
            this.put("OutputConfig", OUTPUT_CONFIG_FIELD);
            this.put("OptimizationOutput", OPTIMIZATION_OUTPUT_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("StoppingCondition", STOPPING_CONDITION_FIELD);
            this.put("VpcConfig", VPC_CONFIG_FIELD);
        }
    });
    private final String optimizationJobArn;
    private final String optimizationJobStatus;
    private final Instant optimizationStartTime;
    private final Instant optimizationEndTime;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final String optimizationJobName;
    private final OptimizationJobModelSource modelSource;
    private final Map<String, String> optimizationEnvironment;
    private final String deploymentInstanceType;
    private final List<OptimizationConfig> optimizationConfigs;
    private final OptimizationJobOutputConfig outputConfig;
    private final OptimizationOutput optimizationOutput;
    private final String roleArn;
    private final StoppingCondition stoppingCondition;
    private final OptimizationVpcConfig vpcConfig;

    private DescribeOptimizationJobResponse(BuilderImpl builder) {
        super(builder);
        this.optimizationJobArn = builder.optimizationJobArn;
        this.optimizationJobStatus = builder.optimizationJobStatus;
        this.optimizationStartTime = builder.optimizationStartTime;
        this.optimizationEndTime = builder.optimizationEndTime;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.optimizationJobName = builder.optimizationJobName;
        this.modelSource = builder.modelSource;
        this.optimizationEnvironment = builder.optimizationEnvironment;
        this.deploymentInstanceType = builder.deploymentInstanceType;
        this.optimizationConfigs = builder.optimizationConfigs;
        this.outputConfig = builder.outputConfig;
        this.optimizationOutput = builder.optimizationOutput;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.vpcConfig = builder.vpcConfig;
    }

    public final String optimizationJobArn() {
        return this.optimizationJobArn;
    }

    public final OptimizationJobStatus optimizationJobStatus() {
        return OptimizationJobStatus.fromValue(this.optimizationJobStatus);
    }

    public final String optimizationJobStatusAsString() {
        return this.optimizationJobStatus;
    }

    public final Instant optimizationStartTime() {
        return this.optimizationStartTime;
    }

    public final Instant optimizationEndTime() {
        return this.optimizationEndTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String optimizationJobName() {
        return this.optimizationJobName;
    }

    public final OptimizationJobModelSource modelSource() {
        return this.modelSource;
    }

    public final boolean hasOptimizationEnvironment() {
        return this.optimizationEnvironment != null && !(this.optimizationEnvironment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> optimizationEnvironment() {
        return this.optimizationEnvironment;
    }

    public final OptimizationJobDeploymentInstanceType deploymentInstanceType() {
        return OptimizationJobDeploymentInstanceType.fromValue(this.deploymentInstanceType);
    }

    public final String deploymentInstanceTypeAsString() {
        return this.deploymentInstanceType;
    }

    public final boolean hasOptimizationConfigs() {
        return this.optimizationConfigs != null && !(this.optimizationConfigs instanceof SdkAutoConstructList);
    }

    public final List<OptimizationConfig> optimizationConfigs() {
        return this.optimizationConfigs;
    }

    public final OptimizationJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final OptimizationOutput optimizationOutput() {
        return this.optimizationOutput;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final OptimizationVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizationEnvironment() ? this.optimizationEnvironment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizationConfigs() ? this.optimizationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptimizationJobResponse)) {
            return false;
        }
        DescribeOptimizationJobResponse other = (DescribeOptimizationJobResponse)((Object)obj);
        return Objects.equals(this.optimizationJobArn(), other.optimizationJobArn()) && Objects.equals(this.optimizationJobStatusAsString(), other.optimizationJobStatusAsString()) && Objects.equals(this.optimizationStartTime(), other.optimizationStartTime()) && Objects.equals(this.optimizationEndTime(), other.optimizationEndTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.optimizationJobName(), other.optimizationJobName()) && Objects.equals(this.modelSource(), other.modelSource()) && this.hasOptimizationEnvironment() == other.hasOptimizationEnvironment() && Objects.equals(this.optimizationEnvironment(), other.optimizationEnvironment()) && Objects.equals(this.deploymentInstanceTypeAsString(), other.deploymentInstanceTypeAsString()) && this.hasOptimizationConfigs() == other.hasOptimizationConfigs() && Objects.equals(this.optimizationConfigs(), other.optimizationConfigs()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.optimizationOutput(), other.optimizationOutput()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOptimizationJobResponse").add("OptimizationJobArn", (Object)this.optimizationJobArn()).add("OptimizationJobStatus", (Object)this.optimizationJobStatusAsString()).add("OptimizationStartTime", (Object)this.optimizationStartTime()).add("OptimizationEndTime", (Object)this.optimizationEndTime()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("OptimizationJobName", (Object)this.optimizationJobName()).add("ModelSource", (Object)this.modelSource()).add("OptimizationEnvironment", this.hasOptimizationEnvironment() ? this.optimizationEnvironment() : null).add("DeploymentInstanceType", (Object)this.deploymentInstanceTypeAsString()).add("OptimizationConfigs", this.hasOptimizationConfigs() ? this.optimizationConfigs() : null).add("OutputConfig", (Object)this.outputConfig()).add("OptimizationOutput", (Object)this.optimizationOutput()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptimizationJobArn": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobArn()));
            }
            case "OptimizationJobStatus": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobStatusAsString()));
            }
            case "OptimizationStartTime": {
                return Optional.ofNullable(clazz.cast(this.optimizationStartTime()));
            }
            case "OptimizationEndTime": {
                return Optional.ofNullable(clazz.cast(this.optimizationEndTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "OptimizationJobName": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobName()));
            }
            case "ModelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSource()));
            }
            case "OptimizationEnvironment": {
                return Optional.ofNullable(clazz.cast(this.optimizationEnvironment()));
            }
            case "DeploymentInstanceType": {
                return Optional.ofNullable(clazz.cast(this.deploymentInstanceTypeAsString()));
            }
            case "OptimizationConfigs": {
                return Optional.ofNullable(clazz.cast(this.optimizationConfigs()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "OptimizationOutput": {
                return Optional.ofNullable(clazz.cast(this.optimizationOutput()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptimizationJobResponse, T> g) {
        return obj -> g.apply((DescribeOptimizationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String optimizationJobArn;
        private String optimizationJobStatus;
        private Instant optimizationStartTime;
        private Instant optimizationEndTime;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private String optimizationJobName;
        private OptimizationJobModelSource modelSource;
        private Map<String, String> optimizationEnvironment = DefaultSdkAutoConstructMap.getInstance();
        private String deploymentInstanceType;
        private List<OptimizationConfig> optimizationConfigs = DefaultSdkAutoConstructList.getInstance();
        private OptimizationJobOutputConfig outputConfig;
        private OptimizationOutput optimizationOutput;
        private String roleArn;
        private StoppingCondition stoppingCondition;
        private OptimizationVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptimizationJobResponse model) {
            super(model);
            this.optimizationJobArn(model.optimizationJobArn);
            this.optimizationJobStatus(model.optimizationJobStatus);
            this.optimizationStartTime(model.optimizationStartTime);
            this.optimizationEndTime(model.optimizationEndTime);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.optimizationJobName(model.optimizationJobName);
            this.modelSource(model.modelSource);
            this.optimizationEnvironment(model.optimizationEnvironment);
            this.deploymentInstanceType(model.deploymentInstanceType);
            this.optimizationConfigs(model.optimizationConfigs);
            this.outputConfig(model.outputConfig);
            this.optimizationOutput(model.optimizationOutput);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getOptimizationJobArn() {
            return this.optimizationJobArn;
        }

        public final void setOptimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
        }

        @Override
        public final Builder optimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
            return this;
        }

        public final String getOptimizationJobStatus() {
            return this.optimizationJobStatus;
        }

        public final void setOptimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
        }

        @Override
        public final Builder optimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
            return this;
        }

        @Override
        public final Builder optimizationJobStatus(OptimizationJobStatus optimizationJobStatus) {
            this.optimizationJobStatus(optimizationJobStatus == null ? null : optimizationJobStatus.toString());
            return this;
        }

        public final Instant getOptimizationStartTime() {
            return this.optimizationStartTime;
        }

        public final void setOptimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
        }

        @Override
        public final Builder optimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
            return this;
        }

        public final Instant getOptimizationEndTime() {
            return this.optimizationEndTime;
        }

        public final void setOptimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
        }

        @Override
        public final Builder optimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getOptimizationJobName() {
            return this.optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        public final OptimizationJobModelSource.Builder getModelSource() {
            return this.modelSource != null ? this.modelSource.toBuilder() : null;
        }

        public final void setModelSource(OptimizationJobModelSource.BuilderImpl modelSource) {
            this.modelSource = modelSource != null ? modelSource.build() : null;
        }

        @Override
        public final Builder modelSource(OptimizationJobModelSource modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        public final Map<String, String> getOptimizationEnvironment() {
            if (this.optimizationEnvironment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.optimizationEnvironment;
        }

        public final void setOptimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
        }

        @Override
        public final Builder optimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
            return this;
        }

        public final String getDeploymentInstanceType() {
            return this.deploymentInstanceType;
        }

        public final void setDeploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
        }

        @Override
        public final Builder deploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
            return this;
        }

        @Override
        public final Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
            this.deploymentInstanceType(deploymentInstanceType == null ? null : deploymentInstanceType.toString());
            return this;
        }

        public final List<OptimizationConfig.Builder> getOptimizationConfigs() {
            List<OptimizationConfig.Builder> result = OptimizationConfigsCopier.copyToBuilder(this.optimizationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizationConfigs(Collection<OptimizationConfig.BuilderImpl> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copyFromBuilder(optimizationConfigs);
        }

        @Override
        public final Builder optimizationConfigs(Collection<OptimizationConfig> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copy(optimizationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(OptimizationConfig ... optimizationConfigs) {
            this.optimizationConfigs(Arrays.asList(optimizationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(Consumer<OptimizationConfig.Builder> ... optimizationConfigs) {
            this.optimizationConfigs(Stream.of(optimizationConfigs).map(c -> (OptimizationConfig)((OptimizationConfig.Builder)OptimizationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OptimizationJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OptimizationJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OptimizationJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final OptimizationOutput.Builder getOptimizationOutput() {
            return this.optimizationOutput != null ? this.optimizationOutput.toBuilder() : null;
        }

        public final void setOptimizationOutput(OptimizationOutput.BuilderImpl optimizationOutput) {
            this.optimizationOutput = optimizationOutput != null ? optimizationOutput.build() : null;
        }

        @Override
        public final Builder optimizationOutput(OptimizationOutput optimizationOutput) {
            this.optimizationOutput = optimizationOutput;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final OptimizationVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(OptimizationVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(OptimizationVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public DescribeOptimizationJobResponse build() {
            return new DescribeOptimizationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptimizationJobResponse> {
        public Builder optimizationJobArn(String var1);

        public Builder optimizationJobStatus(String var1);

        public Builder optimizationJobStatus(OptimizationJobStatus var1);

        public Builder optimizationStartTime(Instant var1);

        public Builder optimizationEndTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder optimizationJobName(String var1);

        public Builder modelSource(OptimizationJobModelSource var1);

        default public Builder modelSource(Consumer<OptimizationJobModelSource.Builder> modelSource) {
            return this.modelSource((OptimizationJobModelSource)((OptimizationJobModelSource.Builder)OptimizationJobModelSource.builder().applyMutation(modelSource)).build());
        }

        public Builder optimizationEnvironment(Map<String, String> var1);

        public Builder deploymentInstanceType(String var1);

        public Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType var1);

        public Builder optimizationConfigs(Collection<OptimizationConfig> var1);

        public Builder optimizationConfigs(OptimizationConfig ... var1);

        public Builder optimizationConfigs(Consumer<OptimizationConfig.Builder> ... var1);

        public Builder outputConfig(OptimizationJobOutputConfig var1);

        default public Builder outputConfig(Consumer<OptimizationJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((OptimizationJobOutputConfig)((OptimizationJobOutputConfig.Builder)OptimizationJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder optimizationOutput(OptimizationOutput var1);

        default public Builder optimizationOutput(Consumer<OptimizationOutput.Builder> optimizationOutput) {
            return this.optimizationOutput((OptimizationOutput)((OptimizationOutput.Builder)OptimizationOutput.builder().applyMutation(optimizationOutput)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder vpcConfig(OptimizationVpcConfig var1);

        default public Builder vpcConfig(Consumer<OptimizationVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((OptimizationVpcConfig)((OptimizationVpcConfig.Builder)OptimizationVpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

