/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations;
import software.amazon.awssdk.services.sagemaker.model.MetricDataListCopier;
import software.amazon.awssdk.services.sagemaker.model.MetricDatum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CandidateProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CandidateProperties> {
    private static final SdkField<CandidateArtifactLocations> CANDIDATE_ARTIFACT_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CandidateArtifactLocations").getter(CandidateProperties.getter(CandidateProperties::candidateArtifactLocations)).setter(CandidateProperties.setter(Builder::candidateArtifactLocations)).constructor(CandidateArtifactLocations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateArtifactLocations").build()}).build();
    private static final SdkField<List<MetricDatum>> CANDIDATE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CandidateMetrics").getter(CandidateProperties.getter(CandidateProperties::candidateMetrics)).setter(CandidateProperties.setter(Builder::candidateMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_ARTIFACT_LOCATIONS_FIELD, CANDIDATE_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CandidateArtifactLocations", CANDIDATE_ARTIFACT_LOCATIONS_FIELD);
            this.put("CandidateMetrics", CANDIDATE_METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CandidateArtifactLocations candidateArtifactLocations;
    private final List<MetricDatum> candidateMetrics;

    private CandidateProperties(BuilderImpl builder) {
        this.candidateArtifactLocations = builder.candidateArtifactLocations;
        this.candidateMetrics = builder.candidateMetrics;
    }

    public final CandidateArtifactLocations candidateArtifactLocations() {
        return this.candidateArtifactLocations;
    }

    public final boolean hasCandidateMetrics() {
        return this.candidateMetrics != null && !(this.candidateMetrics instanceof SdkAutoConstructList);
    }

    public final List<MetricDatum> candidateMetrics() {
        return this.candidateMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateArtifactLocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCandidateMetrics() ? this.candidateMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateProperties)) {
            return false;
        }
        CandidateProperties other = (CandidateProperties)obj;
        return Objects.equals(this.candidateArtifactLocations(), other.candidateArtifactLocations()) && this.hasCandidateMetrics() == other.hasCandidateMetrics() && Objects.equals(this.candidateMetrics(), other.candidateMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"CandidateProperties").add("CandidateArtifactLocations", (Object)this.candidateArtifactLocations()).add("CandidateMetrics", this.hasCandidateMetrics() ? this.candidateMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CandidateArtifactLocations": {
                return Optional.ofNullable(clazz.cast(this.candidateArtifactLocations()));
            }
            case "CandidateMetrics": {
                return Optional.ofNullable(clazz.cast(this.candidateMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CandidateProperties, T> g) {
        return obj -> g.apply((CandidateProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CandidateArtifactLocations candidateArtifactLocations;
        private List<MetricDatum> candidateMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateProperties model) {
            this.candidateArtifactLocations(model.candidateArtifactLocations);
            this.candidateMetrics(model.candidateMetrics);
        }

        public final CandidateArtifactLocations.Builder getCandidateArtifactLocations() {
            return this.candidateArtifactLocations != null ? this.candidateArtifactLocations.toBuilder() : null;
        }

        public final void setCandidateArtifactLocations(CandidateArtifactLocations.BuilderImpl candidateArtifactLocations) {
            this.candidateArtifactLocations = candidateArtifactLocations != null ? candidateArtifactLocations.build() : null;
        }

        @Override
        public final Builder candidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
            this.candidateArtifactLocations = candidateArtifactLocations;
            return this;
        }

        public final List<MetricDatum.Builder> getCandidateMetrics() {
            List<MetricDatum.Builder> result = MetricDataListCopier.copyToBuilder(this.candidateMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCandidateMetrics(Collection<MetricDatum.BuilderImpl> candidateMetrics) {
            this.candidateMetrics = MetricDataListCopier.copyFromBuilder(candidateMetrics);
        }

        @Override
        public final Builder candidateMetrics(Collection<MetricDatum> candidateMetrics) {
            this.candidateMetrics = MetricDataListCopier.copy(candidateMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateMetrics(MetricDatum ... candidateMetrics) {
            this.candidateMetrics(Arrays.asList(candidateMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateMetrics(Consumer<MetricDatum.Builder> ... candidateMetrics) {
            this.candidateMetrics(Stream.of(candidateMetrics).map(c -> (MetricDatum)((MetricDatum.Builder)MetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CandidateProperties build() {
            return new CandidateProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CandidateProperties> {
        public Builder candidateArtifactLocations(CandidateArtifactLocations var1);

        default public Builder candidateArtifactLocations(Consumer<CandidateArtifactLocations.Builder> candidateArtifactLocations) {
            return this.candidateArtifactLocations((CandidateArtifactLocations)((CandidateArtifactLocations.Builder)CandidateArtifactLocations.builder().applyMutation(candidateArtifactLocations)).build());
        }

        public Builder candidateMetrics(Collection<MetricDatum> var1);

        public Builder candidateMetrics(MetricDatum ... var1);

        public Builder candidateMetrics(Consumer<MetricDatum.Builder> ... var1);
    }
}

